.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/FILESYSTEMIMAGE.man,v 1.1 1993/09/20 21:22:00 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/FILESYSTEMIMAGE.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH FILESYSTEMIMAGE 7
.SH Name
FILESYSTEMIMAGE - image of a file system
.SH Description
The
.PN FILESYSTEMIMAGE
structure is used to store information about a directory tree in a file system.
The components of
.PN FILESYSTEMIMAGE
are:
.nf
typedef struct FileSystemImage
{
	int type;
	u_long mode;
	long uid, gid;
	u_long size;
	u_long mtime, dtime;
	u_long count;
	char *name, *link;
	struct FileSystemImage *next, *child;
}
#define FILESYSTEMIMAGE_Type(fp)  ((fp)->type)
#define FILESYSTEMIMAGE_Mode(fp)  ((fp)->mode)
#define FILESYSTEMIMAGE_Uid(fp)  ((fp)->uid)
#define FILESYSTEMIMAGE_Gid(fp)  ((fp)->gid)
#define FILESYSTEMIMAGE_Size(fp)  ((fp)->size)
#define FILESYSTEMIMAGE_MTime(fp)  ((fp)->mtime)
#define FILESYSTEMIMAGE_DTime(fp)  ((fp)->dtime)
#define FILESYSTEMIMAGE_Count(fp)  ((fp)->count)
#define FILESYSTEMIMAGE_Name(fp)  ((fp)->name)
#define FILESYSTEMIMAGE_Link(fp)  ((fp)->link)
#define FILESYSTEMIMAGE_FSMountID(fp)  ((fp)->link)
#define FILESYSTEMIMAGE_Next(fp)  ((fp)->next)
#define FILESYSTEMIMAGE_Child(fp)  ((fp)->child)
.fi
.PP
.PN FILESYSTEMIMAGE_Type
specifies the type of the file represented by the node. Possible types are
.nf
FS_NUL
FS_REG
FS_SYMLNK
FS_HARDLNK
FS_DIR
FS_FSMOUNT
FS_OTHER
.fi
.PP
.SH Author
Sohan C. Ramakrishna-Pillai
