/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_LocatePath.c,v 1.5 1994/08/12 03:20:59 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


/*
 * update man page - to reflect new syntax
 */
char *
Collection_LocatePath(collectionname, searchpath,
		      versiondelimiter, version)
     char *collectionname;
     char **searchpath;
     int versiondelimiter, version;
{
  register char **sp, **cp;
  Boolean LocatedPath;
  char trialpath[MAXPATHLEN];
  char collectionpath[MAXPATHLEN];
  FILESTAT statusbuffer;
  STRINGSET *candidatelistset;
  int collectionnamelen;
  int maxversion, thisversion;
  char *collectionlocation;

  if (searchpath == NULL) {
    FatalError(E_NULLSEARCHPATH,
	       "NULL searchpath for collection %s\n", collectionname);
  }
  if (version >= 0) {
    sp = searchpath;
    LocatedPath = FALSE;
    while (!LocatedPath && (*sp != NULL)
	   && (PROGRAM_ErrorNo == E_NULL)) {
      (void) sprintf(trialpath, "%s/%s%c%d",
		     *sp, collectionname, versiondelimiter, version);
      if ((File_GetStatus(trialpath,
			  &statusbuffer,
			  TRUE /* followlinks */ ) == 0)
	  && (FILESTAT_Type(&statusbuffer) & F_DIR)) {
	LocatedPath = TRUE;
	(void) strcpy(collectionpath, trialpath);
      }
    }
  } else {			/* version < 0 */
    sp = searchpath;
    LocatedPath = FALSE;
    while (!LocatedPath && (*sp != NULL)
	   && (PROGRAM_ErrorNo == E_NULL)) {
      /* look for it in this directory */
      if ((File_ListMatchesinDirectory(*sp,
				       collectionname,
				       &candidatelistset) == 0)
	  && (candidatelistset != NULL)
	  && (STRINGSET_Size(candidatelistset) > 0)
	  && (STRINGSET_Values(candidatelistset) != NULL)) {
	maxversion = -1;
	collectionnamelen = strlen(collectionname);
	for (cp = STRINGSET_Values(candidatelistset);
	     (*cp != NULL) && (PROGRAM_ErrorNo == E_NULL);
	     cp++) {
	  (void) sprintf(trialpath, "%s/%s", *sp, *cp);
	  errno = 0;
	  if ((File_GetStatus(trialpath,
			      &statusbuffer,
			      TRUE /* followlinks */ ) == 0)
	      && (FILESTAT_Type(&statusbuffer) & F_DIR)) {
	    if ((*(*cp + collectionnamelen) == '\0')
		&& (maxversion < 0)) {
	      LocatedPath = TRUE;
	      (void) strcpy(collectionpath, trialpath);
	    } else if (*(*cp + collectionnamelen)
		       == versiondelimiter) {
	      thisversion = atoi(*cp + collectionnamelen + 1);
	      if ((errno == 0) && (thisversion > maxversion)) {
		LocatedPath = TRUE;
		maxversion = thisversion;
		(void) strcpy(collectionpath, trialpath);
	      }
	    }
	  }
	}			/* for loop through list of matching files in 
				 * directory */
	StringArray_Free(candidatelistset);
      }
      sp++;
    }
  }

  if (PROGRAM_ErrorNo == E_NULL) {
    if (LocatedPath)
      collectionlocation = String(collectionpath, strlen(collectionpath));
    else
      collectionlocation = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? collectionlocation : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_LocatePath.c,v $ */

