/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_COLLECTIONLIST_H
#define _DEPOT_COLLECTIONLIST_H

/* $Id: CollectionList.h,v 1.5 1994/08/12 03:27:03 ww0r Exp $
 *
 * Author: Sohan C. Ramakrishna Pillai
 */


typedef struct CollectionList
{
  unsigned int size;
  COLLECTION **collection;
} COLLECTIONLIST;

#define COLLECTIONLIST_Size(clp) ((clp)->size)
#define COLLECTIONLIST_CollectionArray(clp) ((clp)->collection)
#define COLLECTIONLIST_Collection(clp,n) (*((clp)->collection + \
					    ((n < ((clp)->size)) ? \
					     (n) : ((clp)->size))))

extern COLLECTIONLIST *CollectionList_Read();
extern int CollectionList_Write();

extern int CollectionList_SetCollectionStatus();
extern int CollectionList_IgnoreCollection();

extern Boolean CollectionList_Comparator();
extern COLLECTIONLIST *CollectionList();
extern char **CollectionNameList();
extern char **CollectionPathList();
extern COLLECTIONLIST *CollectionList_AddCollectionName();
extern COLLECTION *CollectionList_LocateCollectionByName();

#endif /* _DEPOT_COLLECTIONLIST_H */
