/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: CollectionList_SetCollectionStatus.c,v 1.4 1994/08/12 03:29:54 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"



/*
 * int CollectionList_SetCollectionStatus(clist, collectionname, status)
 *	COLLECTIONLIST *clist;
 *	char *collectionname;
 *	unsigned status;
 * sets the appropriate status flag(s) for the named collection in the
 * collection list clist
 */
int CollectionList_SetCollectionStatus(clist, collectionname, status)
     COLLECTIONLIST *clist;
     char *collectionname;
     unsigned status;
{
  register unsigned int i;
  register COLLECTION *cp;
  Boolean LocatedCollection;

  if (collectionname == NULL)
    {
      FatalError(E_NULLCOLLECTIONNAME,
		 "Attempt to set status of unnamed collection.\n");
    }
  else if (clist != NULL)
    {
      i = 0; LocatedCollection = FALSE;
      while ( (PROGRAM_ErrorNo == E_NULL)
	     && (i < COLLECTIONLIST_Size(clist))
	     && (LocatedCollection == FALSE))
	{
	  cp = COLLECTIONLIST_Collection(clist, i);
	  if ((cp != NULL)
	      && (String_Comparator(collectionname, COLLECTION_Name(cp)) == 0))
	    { LocatedCollection = TRUE; }
	  i++;
	}
      if ((LocatedCollection) && (PROGRAM_ErrorNo == E_NULL))
	COLLECTION_Status(cp) |= status;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}



/*
 * int CollectionList_IgnoreCollection(clist, collectionname)
 *      COLLECTIONLIST *clist;
 *      char *collectionname;
 * sets the ignore flag of the named collection in the collection list clist
 */
int CollectionList_IgnoreCollection(clist, collectionname)
     COLLECTIONLIST *clist;
     char *collectionname;
{
  return CollectionList_SetCollectionStatus(clist, collectionname, C_IGNORE);
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/CollectionList/RCS/CollectionList_SetCollectionStatus.c,v $ */
