/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Command_Build.c,v 1.5 1995/02/02 16:32:33 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "Preference.h"
#include "Command.h"



static Boolean Command_LocateExecFileInPATH();

#define Command_ExpandMagic(str)     (str)
/*
 * $$$NOTE$$$ $$$DESIGN$$$
 * We don't need this since we chdir to the target directory anyway.
 * Check if we need to have depot do remote updates ..., if so, we need this
 * and a lot more in computation of paths etc. in various places.
 */



COMMAND *
Command_Build(label, targetdbp, preferencedbp, collectionlistp)
     char *label;
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedbp;
     COLLECTIONLIST *collectionlistp;
{
  register char **sp;
  COMMAND *commandp;

  SENTENCE *labelcommand;
  char *commandpath;
  Boolean LocatedExecFile;
  char ExecFilePath[MAXPATHLEN + 1], ExecFileNodePath[MAXPATHLEN + 1];
  FILESTAT ExecFileStatus;
  TARGETDB *commandnodep;
  TARGETSOURCE *commandsourcep;
  char *collectionpath;

  labelcommand = Preference_GetSentence(preferencedbp,
					label,
					"command",
					NULL);
  if ((PROGRAM_ErrorNo == E_NULL)
      && ((labelcommand == NULL) || (SENTENCE_Size(labelcommand) <= 0))) {
    FatalError(E_BADCOMMANDLABEL,
	       "No command specified for command label %s.\n", label);
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    commandp = (COMMAND *) emalloc(sizeof(COMMAND));
    if (PROGRAM_ErrorNo == E_NULL) {
      COMMAND_Label(commandp) = String(label, strlen(label));
      COMMAND_Args(commandp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    commandpath = SENTENCE_String(labelcommand, 0);
    LocatedExecFile = FALSE;
    /* 
     * if commandpath is an absolute path
     *   check it's executability;
     * else
     *   if it exists in the target database
     *     check its source for executability;
     *   else 
     *     check if it is on the PATH;
     */
    if (*commandpath == '/') {	/* absolute path */
      (void) strcpy(ExecFilePath, commandpath);
      File_GetStatus(ExecFilePath, &ExecFileStatus, TRUE /* followlinks */ );
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (FILESTAT_Type(&ExecFileStatus) == F_REG)
	  && (FILESTAT_Mode(&ExecFileStatus) & FSTATMODE_EXEC)) {
	LocatedExecFile = TRUE;
	COMMAND_Args(commandp) = StringArray_AppendString(NULL,
							  ExecFilePath);
      } else {
	FatalError(E_BADEXECFILE,
		   "File not executable: %s\n", ExecFilePath);
      }
    } else {
      /* superfluous check - see $$$NOTE above$$$ */
      ExecFileNodePath[0] = '/';	/* add leading / */
      if (strncmp("%t/", commandpath, 3) == 0)
	(void) strcpy(ExecFileNodePath + 1, commandpath + 2);
      else
	(void) strcpy(ExecFileNodePath + 1, commandpath);
      commandnodep = TargetDB_LocateNode(targetdbp, ExecFileNodePath, TDB_LAX);
      if ((PROGRAM_ErrorNo == E_NULL) && (commandnodep != NULL)) {
	/* file to execute is being mapped in */
	commandsourcep =
	  SourceList_SourceToUse(TARGETDB_SourceList(commandnodep));
	if ((PROGRAM_ErrorNo == E_NULL) && (commandsourcep != NULL)) {
	  if (!(TARGETDB_UpdateSpec(commandsourcep) & U_MAP)) {
	    FatalError(E_BADEXECFILE,
		       "Executable file %s not being mapped in.\n",
		       commandpath);
	  } else {
	    commandpath = TARGETSOURCE_Path(commandsourcep);
	    if (*commandpath == '/') {
	      (void) strcpy(ExecFilePath, commandpath);
	    } else {
	      collectionpath =
		COLLECTION_Path(COLLECTIONLIST_Collection(collectionlistp,
				TARGETSOURCE_CollectionId(commandsourcep)));
	      (void) sprintf(ExecFilePath, "%s/%s",
			     collectionpath, commandpath);
	    }
	    File_GetStatus(ExecFilePath,
			   &ExecFileStatus,
			   TRUE /* followlinks */ );
	    if ((PROGRAM_ErrorNo == E_NULL)
		&& (FILESTAT_Type(&ExecFileStatus) == F_REG)
		&& (FILESTAT_Mode(&ExecFileStatus) & FSTATMODE_EXEC)) {
	      LocatedExecFile = TRUE;
	      COMMAND_Args(commandp) =
		StringArray_AppendString(NULL, ExecFilePath);
	    } else {
	      FatalError(E_BADEXECFILE,
			 "File %s mapped in is not executable.\n",
			 ExecFilePath);
	    }
	  }
	}
      }
      if ((PROGRAM_ErrorNo == E_NULL) && !LocatedExecFile) {
	if (((char *) strrchr(commandpath, '/')) != NULL) {
	  FatalError(E_BADEXECFILE,
		     "No executable file %s found.\n", commandpath);
	} else {		/* no /s in commandpath */
	  LocatedExecFile =
	    Command_LocateExecFileInPATH(commandpath, ExecFilePath);
	  if (LocatedExecFile) {
	    COMMAND_Args(commandp) =
	      StringArray_AppendString(NULL, ExecFilePath);
	  } else {
	    FatalError(E_BADEXECFILE,
		       "No executable file %s found in PATH.\n",
		       commandpath);
	  }
	}
      }
    }
  }
  if ((PROGRAM_ErrorNo == E_NULL) && !LocatedExecFile) {
    FatalError(E_BADCOMMANDLABEL,
	       "Could not locate executable file for label %s\n", label);
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    for (sp = SENTENCE_Values(labelcommand) + 1;
	 (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	 sp++) {
      COMMAND_Args(commandp) =
	StringArray_AppendString(COMMAND_Args(commandp),
				 Command_ExpandMagic(*sp));
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? commandp : NULL;
}




static Boolean 
Command_LocateExecFileInPATH(filename, filepath)
     char *filename, *filepath;
{
  register char **pp;
  char *Path;
  char **PathArray;
  STRINGARRAY *pathstringarray;
  Boolean LocatedExecFile;
  FILESTAT statusbuffer;
#ifndef STDC_HEADERS
  extern char *getenv();
#endif

  Path = getenv("PATH");
  pathstringarray = StringToStringArray(Path,
					':' /* delimited by :s */ ,
					-1 /* no quotechar */ );
  if (PROGRAM_ErrorNo == E_NULL) {
    if (pathstringarray == NULL) {
      PathArray = NULL;
    } else {
      PathArray = STRINGARRAY_Values(pathstringarray);
    }
  }
  pp = PathArray;
  LocatedExecFile = FALSE;
  if ((PROGRAM_ErrorNo == E_NULL) && (PathArray != NULL)) {
    while ((PROGRAM_ErrorNo == E_NULL) && (*pp != NULL) && !LocatedExecFile) {
      (void) sprintf(filepath, "%s/%s", *pp, filename);
      File_GetStatus(filepath, &statusbuffer, TRUE /* followlinks */ );
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (FILESTAT_Type(&statusbuffer) == F_REG)
	  && (FILESTAT_Mode(&statusbuffer) & FSTATMODE_EXEC)) {
	LocatedExecFile = TRUE;
      }
      pp++;
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? LocatedExecFile : FALSE;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Command/RCS/Command_Build.c,v $ */
