

%{

/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: GlobalDepotConf_Parse.l,v 1.5 1994/08/12 13:53:04 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"
#include "GlobalDepotConf_Read.h"

static unsigned short spectype;
static char yyerrormessage[1024];

#define dbgprintf(x) /* fprintf x */

void
yyparseinit() {
  BEGIN 0;
}

%}


/* definitions */
W	[ \t]
COM	#[^\n]*
RET	\n
QUOT	\\
C	[^ \t\n\\#]
D	[0-9]
QUOTC	{QUOT}.


%START SPEC SRC TRG CMD UNK

%%


<SPEC>{C}+  {
	{
	  if (yytext[0] == '~')
	    {
	      dbgprintf((stdout, "SPEC %s\n", yytext));
	      spectype = DepotConf_SpecType(yytext+1);
	      switch(spectype)
		{
		case DC_MAP:
		  BEGIN SRC; return (MAPPING);
		  break;
		case DC_DELETE:
		  BEGIN TRG; return (DELETE);
		  break;
		case DC_COMMAND:
		  BEGIN CMD; return (COMMAND);
		  break;
		case DC_DELETECOMMAND:
		  BEGIN CMD; return (DELETECOMMAND);
		  break;
		case DC_UNKNOWN:
		default:
		  sprintf(yyerrormessage,
			  "Invalid specification %s in global depot.conf\n",
			  yytext+1);
		  yyerror(yyerrormessage);
		  BEGIN UNK; return (UNKSPEC);
		  break;
		}
	    }
	  else
	    {
	      dbgprintf((stdout, "SOURCE %s\n", yytext));
	      yylval.strval=String(yytext, strlen(yytext));
	      spectype = DC_MAP; BEGIN TRG; return (SOURCE);
	    }
	}}

<SPEC>({C}|{QUOTC})+	{
	{
	  if (yytext[0] == '~')
	    {
	      dbgprintf((stdout, "SPEC %s\n", yytext));
	      spectype = DepotConf_SpecType(yytext+1);
	      switch(spectype)
		{
		case DC_MAP:
		  BEGIN SRC; return (MAPPING);
		  break;
		case DC_DELETE:
		  BEGIN TRG; return (DELETE);
		  break;
		case DC_COMMAND:
		  BEGIN CMD; return (COMMAND);
		  break;
		case DC_DELETECOMMAND:
		  BEGIN CMD; return (DELETECOMMAND);
		  break;
		case DC_UNKNOWN:
		default:
		  sprintf(yyerrormessage,
			  "Invalid specification %s in global depot.conf\n",
			  yytext+1);
		  yyerror(yyerrormessage);
		  BEGIN UNK; return (UNKSPEC);
		  break;
		}
	    }
	  else
	    {
	      dbgprintf((stdout, "SOURCE %s\n", yytext));
	      yylval.strval=String_RemoveQuotes(yytext, '\\');
	      spectype = DC_MAP; BEGIN TRG; return (SOURCE);
	    }
	}}



<SRC>{C}+ {
	{
	  dbgprintf((stdout, "SOURCE %s\n", yytext));
	  yylval.strval = String(yytext, strlen(yytext));
	  BEGIN TRG; return(SOURCE);
	}}


<SRC>({C}|{QUOTC})+ {
	{
	  dbgprintf((stdout, "SOURCE %s\n", yytext));
	  yylval.strval = String_RemoveQuotes(yytext, '\\');
	  BEGIN TRG; return(SOURCE);
	}}


<TRG>{C}+ {
	{
	  dbgprintf((stdout, "TARGET %s\n", yytext));
	  yylval.strval = String(yytext, strlen(yytext));
	  return(TARGET);
	}}


<TRG>({C}|{QUOTC})+ {
	{
	  dbgprintf((stdout, "TARGET %s\n", yytext));
	  yylval.strval = String_RemoveQuotes(yytext, '\\');
	  return(TARGET);
	}}


<CMD>{C}+ {
	{
	  dbgprintf((stdout, "COMMANDLABEL %s\n", yytext));
	  yylval.strval = String(yytext, strlen(yytext));
	  BEGIN TRG; return(COMMANDLABEL);
	}}


<CMD>({C}|{QUOTC})+ {
	{
	  dbgprintf((stdout, "COMMANDLABEL %s\n", yytext));
	  yylval.strval = String_RemoveQuotes(yytext, '\\');
	  BEGIN TRG; return(COMMANDLABEL);
	}}


{W}+	{
	  dbgprintf((stdout, "WHITESPACE\n"));
	  yylval.ival = 1;
	  /* return(WHITESPACE); */
	}

{COM}	{
	  dbgprintf((stdout, "COMMENT\n"));
	  yylval.ival = 1;
	  BEGIN 0; return(COMMENT);
	}

{RET}	{
	  dbgprintf((stdout, "NEWLINE\n"));
	  yylval.ival = 1;
	  BEGIN 0; return(NEWLINE);
	}

{C}+	{
	  dbgprintf((stdout, "COLLECTION %s\n", yytext));
	  yylval.strval=String(yytext, strlen(yytext));
	  BEGIN SPEC; return (COLLECTION);
	}

({C}|{QUOTC})+	{
	{
	  dbgprintf((stdout, "COLLECTION %s\n", yytext));
	  yylval.strval=String_RemoveQuotes(yytext, '\\');
	  BEGIN SPEC; return (COLLECTION);
	}}


%%
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/GlobalDepotConf_Parse.l,v $ */







