/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: DepotDB_PreferenceDB_Read.c,v 1.4 1994/08/22 23:01:33 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"


PREFERENCEDB *DepotDB_PreferenceDB_Read(dbh)
     DEPOTDBHANDLE *dbh;
{
  PREFERENCEDB *pdb;

  if (fseek(DEPOTDBHANDLE_FP(dbh),
	    DEPOTDBHANDLE_OFF_PREFERENCE(dbh),
	    SEEK_SET)   <   0)
    {
      FatalError(E_FSEEKFAILED,
		 "Failed to fseek preference info in depot database file:%s\n",
		 strerror(errno));
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      pdb = PreferenceDB_Read(DEPOTDBHANDLE_FP(dbh));
    }

  return (PROGRAM_ErrorNo == E_NULL) ? pdb : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/011/src/lib/DepotDB/RCS/DepotDB_PreferenceDB_Read.c,v $ */
