/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: DepotDB_Read.c,v 1.5 1994/08/12 13:58:29 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"


DEPOTDB *DepotDB_Read(dbh)
     DEPOTDBHANDLE *dbh;
{
  DEPOTDB *DepotDB;

  DepotDB = (DEPOTDB *)emalloc(sizeof(DEPOTDB));

  if (PROGRAM_ErrorNo == E_NULL)
    { DEPOTDB_OldPreferenceDB(DepotDB) = DepotDB_PreferenceDB_Read(dbh); }
  if (PROGRAM_ErrorNo == E_NULL)
    { DEPOTDB_OldDepotConfDB(DepotDB) = DepotDB_DepotConfDB_Read(dbh); }
  if (PROGRAM_ErrorNo == E_NULL)
    { DEPOTDB_OldCollectionList(DepotDB) = DepotDB_CollectionList_Read(dbh); }
  if (PROGRAM_ErrorNo == E_NULL)
    { DEPOTDB_TargetDB(DepotDB) = DepotDB_TargetDB_Read(dbh); }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_DEPOTDBREADFAILED,
		 "Attempt to read depot database file failed.\n");
    }

  return (PROGRAM_ErrorNo == E_NULL) ? DepotDB : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotDB/RCS/DepotDB_Read.c,v $ */

