/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: DepotQuery_CollectionInfo.c,v 1.4 1994/08/12 14:01:53 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"

#include "config.h"



COLLECTION *DepotQuery_GetCollectionInfo(targetdir, collectionname)
     char *targetdir, *collectionname;
{
  register unsigned int i;
  register COLLECTION *cp;
  Boolean LocatedCollection;
  COLLECTIONLIST *clist;

  char DepotDBFilePath[MAXPATHLEN+1];
  DEPOTDBHANDLE *dbh;

  COLLECTION *collectionp;

  collectionp = NULL;
  if (collectionname == NULL)
    {
      FatalError(E_NULLCOLLECTIONNAME,
		 "Attempt to get collection info for unnamed collection.\n");
    }
  else
    {
      (void)sprintf(DepotDBFilePath, "%s/%s/%s",
		    targetdir, DEPOTSPECIALDIRECTORY, DEPOTDBFILE);
      dbh = DepotDB_Open(DepotDBFilePath);
    }

  if (PROGRAM_ErrorNo == E_NULL)
    { clist = DepotDB_CollectionList_Read(dbh); }

  if ((PROGRAM_ErrorNo == E_NULL) && (clist != NULL))
    {
      i = 0; LocatedCollection = FALSE;
      while ( (PROGRAM_ErrorNo == E_NULL)
	     && (i < COLLECTIONLIST_Size(clist))
	     && (LocatedCollection == FALSE))
	{
	  cp = COLLECTIONLIST_Collection(clist, i);
	  if ((cp != NULL)
	      && (String_Comparator(collectionname, COLLECTION_Name(cp)) == 0))
	    { LocatedCollection = TRUE; }
	  i++;
	}
      if ((PROGRAM_ErrorNo == E_NULL) && LocatedCollection)
	collectionp = cp;
    }

  return (PROGRAM_ErrorNo == E_NULL) ? collectionp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotQuery/RCS/DepotQuery_CollectionInfo.c,v $ */
