/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: File_CreateSymLink.c,v 1.6 1994/12/20 22:08:32 ww0r Exp $";
#endif /* LINT  */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"


int 
File_CreateSymLink(name1, name2)
     char *name1, *name2;
{
  char newname[MAXPATHLEN];
  
  /* we run the risk that by potentially truncating name2, we 
   * get a non-unique name. It would be too expensive to do this
   * right... *sigh*
   */
  (void)strncpy(newname, name2, MAXPATHLEN-4); 
  (void)strcat(newname,".NEW");
  
  Filtered_Message(PROGRAM_Verbose, "SYMLINK %s %s\n", name1, newname);
  if (symlink(name1, newname) < 0) {
    if (errno == EEXIST) {
      if (File_RemovePath(newname, NULL) < 0) {
	FatalError(E_RMPATHFAILED,
		   "Could not remove path %s: %s\n",
		   newname, strerror(errno));
      } else {
	(void)File_CreateSymLink(name1, newname);
      }
    } else {
      FatalError(E_SYMLINKFAILED,
		 "Could not symlink from %s to %s: %s\n",
		 newname, name1, strerror(errno));
      return -1;
    }
  }
  if (File_Move(newname, name2) < 0) {
    return -1;
  }

    return ((PROGRAM_ErrorNo == E_NULL) ? 0 : -1);
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/FileOps/RCS/File_CreateSymLink.c,v $ */
