/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: File_ListDirectory.c,v 1.5 1994/08/12 14:11:36 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"


int File_ListDirectory(path, filelistp)
     char *path;
     STRINGSET **filelistp;
{
  register struct dirent *de;
  register DIR *dp;

  if ((dp = opendir(path)) == NULL)
    {
      if (errno == ENOENT) {
	fprintf(stderr,"DEPOT WARNING: No such file or directory: %s\n", 
		path);
	*filelistp = NULL;
	return -1;
      }
      FatalError(E_OPENDIRFAILED,
		 "Could not open directory %s: %s\n", path, strerror(errno));
    }

  *filelistp = NULL;
  while ((PROGRAM_ErrorNo == E_NULL)
	 && ((de = readdir(dp)) != NULL))
    {
      if ((strcmp(de->d_name, ".") != 0)
	  && (strcmp(de->d_name, "..") != 0))
	{
	  *filelistp = StringSet_AddString(*filelistp, de->d_name);
	}
    }
  (void)closedir(dp);

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/FileOps/RCS/File_ListDirectory.c,v $ */
