/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#if !defined(SABER) && !defined(LINT)
static char rcs_id[]="$Id: File_RemovePath.c,v 1.7 1994/09/07 07:45:26 ww0r Exp $";
#endif /* LINT && SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "busy.h"

int File_RemovePath(path, status)
     char *path;
     FILESTAT *status;
{
  register struct dirent *de;
  register DIR *dp;
  FILESTAT statbuf;
  char newpath[MAXPATHLEN];

  if (status == NULL)    {
    status = &statbuf;
    if (File_GetStatus(path, status, FALSE /* !followlinks */) < 0)	{
      FatalError(E_GETSTATUSFAILED,
		 "Could not get status of file %s\n", path);
      return -1;
    }
  }

  if (FILESTAT_Type(status) != F_DIR) {
    Filtered_Message(PROGRAM_Verbose, "REMOVE %s", path);
    if (unlink(path) < 0)	{
      if (errno == ETXTBSY) {
	char *busyname;

	busyname = _genbusy_name(path);
	if (PROGRAM_ErrorNo != E_NULL)
	  return(-1);

	if (busyname == NULL) {
	  Filtered_Message(PROGRAM_Verbose, "...Busy file... already renamed");
	} else {
	  Filtered_Message(PROGRAM_Verbose, 
			   "...Busy file...MOVE %s %s", path, busyname);
	  if (rename(path, busyname) < 0) {
	    Filtered_Message(PROGRAM_Verbose, "...");
	    goto error;
	  }
	}
      } else {
	error:
	FatalError(E_UNLINKFAILED,
		   "\nCould not unlink %s: %s\n", path, strerror(errno));
	return -1;
      }
    }
    Filtered_Message(PROGRAM_Verbose, "\n");
  } else {                           /* FILESTAT_Type(status) == F_DIR */
    if ((dp = opendir(path)) == NULL)	{
      FatalError(E_OPENDIRFAILED,
		 "Could not open directory %s\n", path);
      return -1;
    }
    while ((de = readdir(dp)) != NULL)	{
      if ( (strcmp(de->d_name, ".") != 0)
	   && (strcmp(de->d_name, "..") != 0))	    {
	(void)sprintf(newpath, "%s/%s", path, de->d_name);
	if (File_RemovePath(newpath, NULL) < 0)		{
	  FatalError(E_RMPATHFAILED,
		     "Could not remove path %s: %s\n",
		     path, strerror(errno));
	  (void)closedir(dp);
	  return -1;
	}
      }
    }
    (void)closedir(dp);
    Filtered_Message(PROGRAM_Verbose, "REMOVE DIRECTORY %s\n", path);
    if (rmdir(path) < 0)	{
      FatalError(E_RMDIRFAILED,
		 "Could not remove directory %s: %s\n",
		 path, strerror(errno));
      return -1;
    }
  }
  return 0;
}

/* $Source: /afs/andrew/system/src/local/depot2/012/src/lib/FileOps/RCS/File_RemovePath.c,v $ */

