/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: FileSystemImage_Locate.c,v 1.5 1995/02/09 18:14:23 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 *
 * Author: Sohan C. Ramakrishna Pillai
 *
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"


static FILESYSTEMIMAGE *FileSystemImage_LocateChildNode();


FILESYSTEMIMAGE *
FileSystemImage_LocateNode(fsimagep, pathtonode, cname)
     FILESYSTEMIMAGE *fsimagep;
     char *pathtonode;
     char *cname; 
{
  register char **sp;

  FILESYSTEMIMAGE *childnodep;
  char **targetpatharray;
  STRINGARRAY *targetpathstringarray = NULL;

  if (fsimagep == NULL) {
    FatalError(E_BADFILESYSTEMIMAGE,
	       "Attempt to search for path in NULL file system image for collection %s\n",
	       cname);
  }
  if (pathtonode == NULL) {
    FatalError(E_BADIMAGEPATHNAME,
	       "Attempt to search for NULL path in file system image for collection %s\n",
	       cname);
  }
  /* split pathtonode into array of its components */
  if (PROGRAM_ErrorNo == E_NULL) {
    targetpathstringarray = StringToStringArray(pathtonode,
						'/' /* delimited by /s */ ,
						-1 /* no quotechar */ );
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (targetpathstringarray == NULL)
      targetpatharray = NULL;
    else
      targetpatharray = STRINGARRAY_Values(targetpathstringarray);
  }
  childnodep = fsimagep;
  if ((PROGRAM_ErrorNo == E_NULL) && (targetpatharray != NULL)) {
    for (sp = targetpatharray;
	 (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	 sp++) {
      /* locate child node */
      childnodep = FileSystemImage_LocateChildNode(childnodep, *sp, cname);
    }
  }
  if (targetpathstringarray != NULL)
    StringArray_Free(targetpathstringarray);

  return (PROGRAM_ErrorNo == E_NULL) ? childnodep : NULL;
}



static FILESYSTEMIMAGE *
FileSystemImage_LocateChildNode(fsimagep, childname, cname)
     FILESYSTEMIMAGE *fsimagep;
     char *childname;
     char *cname;
{
  register FILESYSTEMIMAGE *fp;

  FILESYSTEMIMAGE *childnodep;
  Boolean LocatedChild;

  if (fsimagep == NULL) {
    FatalError(E_BADFILESYSTEMIMAGE,
	       "Attempt to search for child in NULL file system image in collection: %s\n",
	       cname);
  }
  if (childname == NULL) {
    FatalError(E_BADIMAGEPATHNAME,
	  "Attempt to search for child named NULL in file system image for collection: %s\n",
	       cname);
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    for (fp = FILESYSTEMIMAGE_Child(fsimagep), LocatedChild = FALSE;
	 (PROGRAM_ErrorNo == E_NULL) && !LocatedChild && (fp != NULL);
	 fp = FILESYSTEMIMAGE_Next(fp)) {
      if (String_Comparator(childname, FILESYSTEMIMAGE_Name(fp)) == 0) {
	LocatedChild = TRUE;
	childnodep = fp;
      }
    }
  }
  if ((PROGRAM_ErrorNo == E_NULL) && !LocatedChild) {
    FatalError(E_FSIMAGELOCATEFAILED,
	       "No child named %s could be located for collection: %s\n", childname,
	       cname);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? childnodep : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/FileSystemImage/RCS/FileSystemImage_Locate.c,v $ */
