/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: FileSystem_GetFSInfo.c,v 1.5 1994/11/08 16:44:16 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */


#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "FileSystem.h"


int FileSystem_GetFSInfo(path, buffer, modtimep)
     char *path, *buffer;
     time_t *modtimep;
{
  FSINFO fsinfo;

#ifdef HAVE_AFS
  fsinfo.path = path;
  fsinfo.fs_id = buffer;
  if (AFS_GetVolumeInfo(&fsinfo) < 0)
    {
      FatalError(E_AFSPROBLEM, "Unable to get volume info for %s\n", path);
    }
  else
    *modtimep = fsinfo.fs_modtime;
#else
  *modtimep = 0;
#endif /* HAVE_AFS */
  return (PROGRAM_ErrorNo == E_NULL)? 0 : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/lib/FileSystemUtil/RCS/FileSystem_GetFSInfo.c,v $ */
