/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintDB_GetRelatedHints.c,v 1.4 1994/08/12 18:00:05 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"


/*
 * Search hint database for hint info for the last subtree on path
 */
HINTDB 
HintDB_GetRelatedHints(hintdb, pathprefix)
     HINTDB hintdb;
     char *pathprefix;
{
  register HINTDB hpp;
  HINTDB relatedhintdb;

  Boolean before, during;
  int Comparison;

  relatedhintdb = NULL;
  hpp = hintdb;
  if (hintdb != NULL) {
    before = TRUE;
    during = FALSE;
    while ((PROGRAM_ErrorNo == E_NULL) && before && (*hpp != NULL)) {
      if (HINT_PathName(*hpp) == NULL) {
	before = during = FALSE;
	FatalError(E_BADHINTNAME,
		   "No name found for hint in hint database.\n");
      } else {
	Comparison = strncmp(HINT_PathName(*hpp), pathprefix,
			     strlen(pathprefix));
	if (Comparison == 0) {
	  before = FALSE;
	  during = TRUE;
	  relatedhintdb = HintDB_InsertHint(relatedhintdb, *hpp,
					    FALSE /* OverWrite */ );
	  hpp++;
	} else if (Comparison > 0) {
	  before = during = FALSE;
	} else {		/* Comparison < 0 */
	  hpp++;
	}
      }
    }

    while ((PROGRAM_ErrorNo == E_NULL) && during && (*hpp != NULL)) {
      if (HINT_PathName(*hpp) == NULL) {
	before = during = FALSE;
	FatalError(E_BADHINTNAME,
		   "No name found for hint in hint database.\n");
      } else {
	Comparison = strncmp(HINT_PathName(*hpp), pathprefix,
			     strlen(pathprefix));
	if (Comparison == 0) {
	  during = TRUE;
	  relatedhintdb = HintDB_InsertHint(relatedhintdb, *hpp,
					    FALSE /* OverWrite */ );
	  hpp++;
	} else if (Comparison > 0) {
	  before = during = FALSE;
	} else {		/* Comparison < 0 */
	  FatalError(E_BADHINTDB,
		     "Attempt to search in corrupted hint database.\n");
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? relatedhintdb : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/HintDB_GetRelatedHints.c,v $ */
