/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintUtil.c,v 1.7 1994/12/16 21:14:47 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"


Boolean Hint_Comparator();

HINT *
Hint_Create(pathname, uniqueid, modtime)
     char *pathname;
     char *uniqueid;
     time_t modtime;
{
  HINT *hintp;
  /* $$$HERE$$$ */

  if (pathname == NULL) {
    FatalError(E_BADHINTNAME,
	       "Attempt to create hint with NULL pathname.\n");
  }
  if (uniqueid == NULL) {
    FatalError(E_BADHINTID,
	       "Attempt to create hint with NULL id.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    hintp = (HINT *) emalloc(sizeof(HINT));
  if (PROGRAM_ErrorNo == E_NULL) {
    HINT_PathName(hintp) = String(pathname, strlen(pathname));
    HINT_UniqueID(hintp) = String(uniqueid, strlen(uniqueid));
    HINT_ModTime(hintp) = modtime;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? hintp : NULL;
}

void
Hint_Free(hintp)
  HINT *hintp;
{
  if ((hintp == NULL) 
      || (PROGRAM_ErrorNo != E_NULL))
    return;

  free(HINT_PathName(hintp));
  free(HINT_UniqueID(hintp));
  free(hintp);

  return;
}

void
HintDB_Free(hintdb)
  HINTDB hintdb;
{
  register HINTDB hp;
  
  if ((hintdb == NULL) || (PROGRAM_ErrorNo != E_NULL))
    return;

  for (hp = hintdb; *hp != NULL; hp++) {
    Hint_Free(*hp);
  }

  free(hintdb); 

  return;
}
       

/*
 * int HintDB_Size(hintdb)
 *      HINTDB hintdb;
 * returns size of hint database = number of hints in database hintdb
 */
unsigned int 
HintDB_Size(hintdb)
     HINTDB hintdb;
{
  register HINTDB hp;
  unsigned int size;

  if (hintdb == NULL)
    size = 0;
  else {
    hp = hintdb;
    while (*hp != NULL)
      hp++;
    size = hp - hintdb;
  }

  return size;
}


Boolean 
Hint_Comparator(hp1, hp2)
     HINT *hp1, *hp2;
{
  Boolean Comparison;

  if ((hp1 == NULL) || (hp2 == NULL)) {
    if ((hp1 == NULL) && (hp2 == NULL))
      Comparison = TRUE;
    else
      Comparison = FALSE;
  } else {
    if (HINT_ModTime(hp1) != HINT_ModTime(hp2)) 
      Comparison = FALSE;
    else if (String_Comparator(HINT_UniqueID(hp1),
			       HINT_UniqueID(hp2)) != 0)
      Comparison = FALSE;
    else if (String_Comparator(HINT_PathName(hp1),
			       HINT_PathName(hp2)) != 0)
      Comparison = FALSE;
    else 
      Comparison = TRUE;
  }

  return (PROGRAM_ErrorNo == E_NULL) ? Comparison : FALSE;
}


Boolean 
HintDB_Comparator(hintdb1, hintdb2)
     HINTDB hintdb1, hintdb2;
{
  register HINTDB hpp1, hpp2;
  Boolean eohintdb;
  Boolean Comparison;

  if ((hintdb1 == NULL) || (hintdb2 == NULL)) {
    if ((hintdb1 == NULL) && (hintdb2 == NULL))
      Comparison = TRUE;
    else
      Comparison = FALSE;
  } else {
    hpp1 = hintdb1;
    hpp2 = hintdb2;
    Comparison = TRUE;
    eohintdb = FALSE;
    while ((PROGRAM_ErrorNo == E_NULL)
	   && (Comparison == TRUE) && !eohintdb) {
      if ((*hpp1 == NULL) || (*hpp2 == NULL)) {
	if ((*hpp1 == NULL) && (*hpp2 == NULL))
	  Comparison = TRUE;
	else
	  Comparison = FALSE;
	eohintdb = TRUE;
      } else {
	Comparison = Hint_Comparator(*hpp1, *hpp2);
	hpp1++, hpp2++;
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? Comparison : FALSE;
}

void
Hint_Dump(fp,hint) 
  FILE *fp;
  HINT *hint;
{
  fprintf(fp, "PATH: %s\tID:%s\tmodtime=%d\n", 
	  HINT_PathName(hint),
	  HINT_UniqueID(hint),
	  HINT_ModTime(hint));
}

void
HintDB_Dump(fp,hdb)
  FILE *fp;
  HINTDB hdb;
{
  HINTDB hpp;
  
  if ((hpp = hdb) == NULL) {
    fprintf(fp,"hintdb is NULL\n");
    return;
  }
  while (*hpp != NULL) {
    Hint_Dump(fp, *hpp);
    hpp++;
  }
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/Hint/RCS/HintUtil.c,v $ */
