/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Preference_CompoundGet.c,v 1.6 1994/08/12 22:12:06 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"


STRINGSET *
Preference_GetCollectionNameList(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;

  STRINGSET *collectionnamelist;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  collectionnamelist = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((String_Comparator(PREFERENCE_Operand(*pp), PREF_WILDITEM) != 0)
	    && Preference_CollectionOperand(PREFERENCE_OptionID(*pp))) {
	  collectionnamelist =
	    StringSet_AddString(collectionnamelist,
				PREFERENCE_Operand(*pp));
	}
	if (Preference_CollectionValue(PREFERENCE_OptionID(*pp))) {
	  collectionnamelist = StringSet_Merge(collectionnamelist,
					       PREFERENCE_StrSetVal(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? collectionnamelist : NULL;
}


/* XXXX this duplicates GetSearchPathlist. Should merge the two
 * one of these days
 */
STRINGARRAY *
Preference_GetSearchPathEntry(prefdbp, item)
     PREFERENCEDB *prefdbp;
     char *item;
{

  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  register char **sp;
  register STRINGARRAY *strarrp;
  int searchpathoptionid;
  STRINGSET *searchpathlist;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  if (item == NULL) {
    FatalError(E_BADSTRING, "NULL string given\n");
  }
  searchpathoptionid = Preference_OptionID("searchpath");
  searchpathlist = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL); pp++) {
	if ((PREFERENCE_OptionID(*pp) == searchpathoptionid) &&
	    (strcmp(PREFERENCE_Operand(*pp), item) == 0) &&
	    ((strarrp = PREFERENCE_StrArrVal(*pp)) != NULL)) {
	  sp = STRINGARRAY_Values(strarrp);
	  if (sp != NULL) {
	    while ((PROGRAM_ErrorNo == E_NULL) && (*sp != NULL)) {
	      searchpathlist = StringArray_AppendString(searchpathlist, *sp);
	      sp++;
	    }
	  }
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? searchpathlist : NULL;
}


STRINGSET *
Preference_GetSearchPathList(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  register char **sp;
  register STRINGARRAY *strarrp;

  int searchpathoptionid;
  STRINGSET *searchpathlist;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  searchpathoptionid = Preference_OptionID("searchpath");
  searchpathlist = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == searchpathoptionid)
	    && ((strarrp = PREFERENCE_StrArrVal(*pp)) != NULL)) {
	  sp = STRINGARRAY_Values(strarrp);
	  if (sp != NULL) {
	    while ((PROGRAM_ErrorNo == E_NULL) && (*sp != NULL)) {
	      searchpathlist = StringSet_AddString(searchpathlist, *sp);
	      sp++;
	    }
	  }
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? searchpathlist : NULL;
}


STRINGSET *
Preference_GetOwnerNamesToSet(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;

  int owneroptionid;
  STRINGSET *uidnameset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  owneroptionid = Preference_OptionID("target.owner");
  uidnameset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == owneroptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  uidnameset = StringSet_AddString(uidnameset,
					   PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? uidnameset : NULL;
}



STRINGSET *
Preference_GetGroupNamesToSet(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  int groupoptionid;
  STRINGSET *gidnameset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  groupoptionid = Preference_OptionID("target.group");
  gidnameset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == groupoptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  gidnameset = StringSet_AddString(gidnameset,
					   PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? gidnameset : NULL;
}



STRINGSET *
Preference_GetSetUIDNamesToSet(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;

  int setuidoptionid;
  STRINGSET *uidnameset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  setuidoptionid = Preference_OptionID("target.setuid");
  uidnameset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == setuidoptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  uidnameset = StringSet_AddString(uidnameset,
					   PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? uidnameset : NULL;
}



STRINGSET *
Preference_GetSetGIDNamesToSet(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  int setgidoptionid;
  STRINGSET *gidnameset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  setgidoptionid = Preference_OptionID("target.setgid");
  gidnameset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == setgidoptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  gidnameset = StringSet_AddString(gidnameset,
					   PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? gidnameset : NULL;
}



STRINGSET *
Preference_GetModeMasksToSet(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  int modemaskoptionid;
  STRINGSET *modemaskset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  modemaskoptionid = Preference_OptionID("target.modemask");
  modemaskset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == modemaskoptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  modemaskset = StringSet_AddString(modemaskset,
					    PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? modemaskset : NULL;
}



STRINGSET *
Preference_GetTargetCommandList(prefdbp)
     PREFERENCEDB *prefdbp;
{
  register unsigned i;
  register PREFERENCE ***arrayp;
  register PREFERENCE **pp;
  int targetcommandoptionid;
  STRINGSET *labelset;

  if (prefdbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database\n");
  }
  targetcommandoptionid = Preference_OptionID("target.command");
  labelset = NULL;
  for (i = 0, arrayp = *prefdbp;
       (PROGRAM_ErrorNo == E_NULL) && (i < Preference_HashTableSize);
       i++, arrayp++) {
    if (arrayp == NULL) {
      FatalError(E_BADPREFERENCEDB,
		 "Error navigating hash table of preference database.\n");
    }
    if ((PROGRAM_ErrorNo == E_NULL) && (*arrayp != NULL)) {
      for (pp = *arrayp;
	   (PROGRAM_ErrorNo == E_NULL) && (*pp != NULL);
	   pp++) {
	if ((PREFERENCE_OptionID(*pp) == targetcommandoptionid)
	    && (PREFERENCE_StrArrVal(*pp) != NULL)) {
	  labelset = StringSet_AddString(labelset,
					 PREFERENCE_Operand(*pp));
	}
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? labelset : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Preference/RCS/Preference_CompoundGet.c,v $ */
