/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceUtil.c,v 1.4 1994/10/12 19:37:09 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETSOURCE *
TargetSource(targetsourcep)
     TARGETSOURCE *targetsourcep;
{
  TARGETSOURCE *newsourcep;

  if (targetsourcep == NULL) {
    FatalError(E_BADTARGETSOURCE,
	       "Attempt to to recreate NULL targetsource.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    newsourcep = (TARGETSOURCE *) emalloc(sizeof(TARGETSOURCE));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCE_Path(newsourcep)
      = String(TARGETSOURCE_Path(targetsourcep),
	       strlen(TARGETSOURCE_Path(targetsourcep)));
    TARGETSOURCE_UpdateSpec(newsourcep)
      = TARGETSOURCE_UpdateSpec(targetsourcep);
    TARGETSOURCE_CollectionId(newsourcep)
      = TARGETSOURCE_CollectionId(targetsourcep);
    TARGETSOURCE_Status(newsourcep) = TARGETSOURCE_Status(targetsourcep);
    TARGETSOURCE_OldUpdateSpec(newsourcep)
      = TARGETSOURCE_OldUpdateSpec(targetsourcep);
    TARGETSOURCE_SecondarySource(newsourcep)
      = (TARGETSOURCE_SecondarySource(targetsourcep) == NULL) ?
      NULL : TargetSource(TARGETSOURCE_SecondarySource(targetsourcep));
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcep : NULL;
}



TARGETSOURCE *
TargetSource_Create(source, update_spec, collection_id,
		    status, update_spec_old, secondary_source)
     char *source;
     unsigned update_spec;
     int collection_id;
     unsigned status;
     unsigned update_spec_old;
     TARGETSOURCE *secondary_source;
{
  TARGETSOURCE *newsourcep;

  if (source == NULL) {
    FatalError(E_BADTARGETSOURCEPATH,
	       "Attempt to to create source with NULL source path.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    newsourcep = (TARGETSOURCE *) emalloc(sizeof(TARGETSOURCE));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCE_Path(newsourcep) = String(source, strlen(source));
    TARGETSOURCE_UpdateSpec(newsourcep) = update_spec;
    TARGETSOURCE_CollectionId(newsourcep) = collection_id;
    TARGETSOURCE_Status(newsourcep) = status;
    TARGETSOURCE_OldUpdateSpec(newsourcep) = update_spec_old;
    TARGETSOURCE_SecondarySource(newsourcep)
      = (secondary_source == NULL) ? NULL : TargetSource(secondary_source);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcep : NULL;
}


/* $$$NOTE$$$
 * This does not compare the values of the OldUpdateSpec field - a fact which
 * is not in keeping with the general *_Comparator() paradigm used.
 */
Boolean 
TargetSource_Comparator(sp1, sp2)
     TARGETSOURCE *sp1, *sp2;
{
  Boolean Comparison;

  if ((sp1 == NULL) && (sp2 == NULL))
    Comparison = TRUE;
  else if ((sp1 == NULL) && (sp2 == NULL)) {	/* one is NULL, but other is not */
    Comparison = FALSE;
  } else {			/* both are non-NULL */
    if (String_Comparator(TARGETSOURCE_Path(sp1),
			  TARGETSOURCE_Path(sp2)) != 0)
      Comparison = FALSE;
    else if (TARGETSOURCE_UpdateSpec(sp1) != TARGETSOURCE_UpdateSpec(sp2))
      Comparison = FALSE;
    else if (TARGETSOURCE_CollectionId(sp1) != TARGETSOURCE_CollectionId(sp2))
      Comparison = FALSE;
    else if (TARGETSOURCE_Status(sp1) != TARGETSOURCE_Status(sp2))
      Comparison = FALSE;
    else if (TargetSource_Comparator(TARGETSOURCE_SecondarySource(sp1),
				     TARGETSOURCE_SecondarySource(sp2))
	     != TRUE)
      Comparison = FALSE;
    else
      Comparison = TRUE;
  }

  return (PROGRAM_ErrorNo == E_NULL) ? Comparison : FALSE;
}



/*
 * $$$$KLUDGE$$$
 * Give me a better name than this!
 *      This is much the same as TargetSource_Comparator(),
 * except in that the U_TARGET update_spec and any status are ignored.
 */
Boolean 
TargetSource_DuplicateComparator(sp1, sp2)
     TARGETSOURCE *sp1, *sp2;
{
  Boolean Comparison;

  if ((sp1 == NULL) && (sp2 == NULL))
    Comparison = TRUE;
  else if ((sp1 == NULL) && (sp2 == NULL)) {	/* one is NULL, but other is not */
    Comparison = FALSE;
  } else {			/* both are non-NULL */
    if (String_Comparator(TARGETSOURCE_Path(sp1),
			  TARGETSOURCE_Path(sp2)) != 0)
      Comparison = FALSE;
    else if ((TARGETSOURCE_UpdateSpec(sp1) & ~U_TARGET)
	     != (TARGETSOURCE_UpdateSpec(sp2) & ~U_TARGET))
      Comparison = FALSE;
    else if (TARGETSOURCE_CollectionId(sp1) != TARGETSOURCE_CollectionId(sp2))
      Comparison = FALSE;
    else if (TargetSource_DuplicateComparator
	     (TARGETSOURCE_SecondarySource(sp1),
	      TARGETSOURCE_SecondarySource(sp2)) != TRUE)
      Comparison = FALSE;
    else
      Comparison = TRUE;
  }

  return (PROGRAM_ErrorNo == E_NULL) ? Comparison : FALSE;
}



void 
TargetSource_Free(sourcep)
     TARGETSOURCE *sourcep;
{
  if (sourcep == NULL) {
    FatalError(E_BADTARGETSOURCE,
	       "Attempt to free NULL target source.\n");
  } else {
    if (TARGETSOURCE_Path(sourcep) != NULL)
      String_Free(TARGETSOURCE_Path(sourcep));
    if (TARGETSOURCE_SecondarySource(sourcep) != NULL)
      TargetSource_Free(TARGETSOURCE_SecondarySource(sourcep));
    (void) free(sourcep);
  }

  return;
}

/* $Source: /afs/andrew/system/src/local/depot2/014/src/lib/TargetDB/RCS/SourceUtil.c,v $ */
