/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDBUtil.c,v 1.6 1994/10/25 17:34:05 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETDB *
TargetDB(targetdbp)
     TARGETDB *targetdbp;
{
  register unsigned int i;
  register TARGETDB **fp, **tp;
  TARGETDB *newtargetdbp;

  if (targetdbp == NULL) {
    FatalError(E_NULLTARGETDB,
	       "Attempt to to recreate NULL targetdb entry.\n");
  } else if (TARGETDB_Name(targetdbp) == NULL) {
    FatalError(E_BADTARGETNAME,
	       "Attempt to to recreate targetdb entry with NULL name.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    newtargetdbp = (TARGETDB *) emalloc(sizeof(TARGETDB));
  if (PROGRAM_ErrorNo == E_NULL)
    TARGETDB_Name(newtargetdbp) = String(TARGETDB_Name(targetdbp),
					 strlen(TARGETDB_Name(targetdbp)));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETDB_UpdateSpec(newtargetdbp) = TARGETDB_UpdateSpec(targetdbp);
    if (TARGETDB_UpdateSpec(newtargetdbp)
	& (U_OWNER | U_GROUP | U_MODE | U_SETUID | U_SETGID)) {
      if (TARGETDB_FileStatus(targetdbp) == NULL) {
	FatalError(E_BADTARGETFILESTATUS,
		   "Unexpected NULL target file status info while duplicating target database.\n");
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	TARGETDB_FileStatus(newtargetdbp) =
	  (FILESTAT *) emalloc(sizeof(FILESTAT));
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	if (TARGETDB_UpdateSpec(newtargetdbp) & (U_OWNER | U_SETUID)) {
	  FILESTAT_Uid(TARGETDB_FileStatus(newtargetdbp)) =
	    FILESTAT_Uid(TARGETDB_FileStatus(targetdbp));
	}
	if (TARGETDB_UpdateSpec(newtargetdbp) & (U_GROUP | U_SETGID)) {
	  FILESTAT_Gid(TARGETDB_FileStatus(newtargetdbp)) =
	    FILESTAT_Gid(TARGETDB_FileStatus(targetdbp));
	}
	if (TARGETDB_UpdateSpec(newtargetdbp) & U_MODE) {
	  FILESTAT_Mode(TARGETDB_FileStatus(newtargetdbp)) =
	    FILESTAT_Mode(TARGETDB_FileStatus(targetdbp));
	}
      }
    } else {
      TARGETDB_FileStatus(newtargetdbp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCE_Status(newtargetdbp) = TARGETSOURCE_Status(targetdbp);
    TARGETDB_SourceList(newtargetdbp) =
      (TARGETDB_SourceList(targetdbp) == NULL) ?
      NULL : SourceList(TARGETDB_SourceList(targetdbp));
    TARGETDB_OldUpdateSpec(newtargetdbp) = TARGETDB_OldUpdateSpec(targetdbp);
    if (TARGETDB_OldUpdateSpec(newtargetdbp)
	& (U_OWNER | U_GROUP | U_MODE | U_SETUID | U_SETGID)) {
      if (TARGETDB_OldFileStatus(targetdbp) == NULL) {
	FatalError(E_BADTARGETFILESTATUS,
		   "Unexpected NULL target file status info while duplicating target database.\n");
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	TARGETDB_OldFileStatus(newtargetdbp) =
	  (FILESTAT *) emalloc(sizeof(FILESTAT));
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	if (TARGETDB_OldUpdateSpec(newtargetdbp) & (U_OWNER | U_SETUID)) {
	  FILESTAT_Uid(TARGETDB_OldFileStatus(newtargetdbp)) =
	    FILESTAT_Uid(TARGETDB_OldFileStatus(targetdbp));
	}
	if (TARGETDB_OldUpdateSpec(newtargetdbp) & (U_OWNER | U_SETGID)) {
	  FILESTAT_Gid(TARGETDB_OldFileStatus(newtargetdbp)) =
	    FILESTAT_Gid(TARGETDB_OldFileStatus(targetdbp));
	}
	if (TARGETDB_OldUpdateSpec(newtargetdbp) & U_MODE) {
	  FILESTAT_Mode(TARGETDB_OldFileStatus(newtargetdbp)) =
	    FILESTAT_Mode(TARGETDB_OldFileStatus(targetdbp));
	}
      }
    } else {
      TARGETDB_OldFileStatus(newtargetdbp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETDB_ChildCount(newtargetdbp) = TARGETDB_ChildCount(targetdbp);
    TARGETDB_Children(newtargetdbp) = NULL;
    if (TARGETDB_ChildCount(newtargetdbp) != 0) {
      TARGETDB_Children(newtargetdbp)
	= (TARGETDBENTRY **) emalloc(TARGETDB_ChildCount(newtargetdbp)
				     * sizeof(TARGETDBENTRY *));
      for (i = 0,
	   tp = TARGETDB_Children(newtargetdbp),
	   fp = TARGETDB_Children(targetdbp);
	   ((i < TARGETDB_ChildCount(newtargetdbp))
	    && (PROGRAM_ErrorNo == E_NULL));
	   i++, tp++, fp++)
	*tp = TargetDB(*fp);
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDB *
TargetDB_Create(name, update_spec, filestatusp, status,
		sourcelist, update_spec_old, filestatusp_old,
		childcount, children)
     char *name;
     unsigned int update_spec;
     FILESTAT *filestatusp;
     unsigned int status;
     TARGETSOURCELIST *sourcelist;
     unsigned int update_spec_old;
     FILESTAT *filestatusp_old;
     unsigned int childcount;
     TARGETDB **children;
{
  register unsigned int i;
  register TARGETDB **fp, **tp;
  TARGETDB *targetdbp;

  if (name == NULL) {
    FatalError(E_BADTARGETNAME,
	       "Attempt to to create targetdb entry with NULL name.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    targetdbp = (TARGETDB *) emalloc(sizeof(TARGETDB));
  if (PROGRAM_ErrorNo == E_NULL)
    TARGETDB_Name(targetdbp) = String(name, strlen(name));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETDB_UpdateSpec(targetdbp) = update_spec;
    if (TARGETDB_UpdateSpec(targetdbp)
	& (U_OWNER | U_GROUP | U_MODE | U_SETUID | U_SETGID)) {
      if (filestatusp == NULL) {
	FatalError(E_BADTARGETFILESTATUS,
		   "Unexpected NULL target file status info while creating target database node.\n");
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	TARGETDB_FileStatus(targetdbp) =
	  (FILESTAT *) emalloc(sizeof(FILESTAT));
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	if (TARGETDB_UpdateSpec(targetdbp) & (U_OWNER | U_SETUID)) {
	  FILESTAT_Uid(TARGETDB_FileStatus(targetdbp)) =
	    FILESTAT_Uid(filestatusp);
	}
	if (TARGETDB_UpdateSpec(targetdbp) & (U_GROUP | U_SETGID)) {
	  FILESTAT_Gid(TARGETDB_FileStatus(targetdbp)) =
	    FILESTAT_Gid(filestatusp);
	}
	if (TARGETDB_UpdateSpec(targetdbp) & U_MODE) {
	  FILESTAT_Mode(TARGETDB_FileStatus(targetdbp)) =
	    FILESTAT_Mode(filestatusp);
	}
      }
    } else {
      TARGETDB_FileStatus(targetdbp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCE_Status(targetdbp) = status;
    TARGETDB_SourceList(targetdbp) =
      (sourcelist == NULL) ? NULL : SourceList(sourcelist);
    TARGETDB_OldUpdateSpec(targetdbp) = update_spec_old;
    if (TARGETDB_OldUpdateSpec(targetdbp)
	& (U_OWNER | U_GROUP | U_MODE | U_SETUID | U_SETGID)) {
      if (filestatusp_old == NULL) {
	FatalError(E_BADTARGETFILESTATUS,
		   "Unexpected NULL target file status info while creating target database node.\n");
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	TARGETDB_OldFileStatus(targetdbp) =
	  (FILESTAT *) emalloc(sizeof(FILESTAT));
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	if (TARGETDB_OldUpdateSpec(targetdbp) & (U_OWNER | U_SETUID)) {
	  FILESTAT_Uid(TARGETDB_OldFileStatus(targetdbp)) =
	    FILESTAT_Uid(filestatusp_old);
	}
	if (TARGETDB_OldUpdateSpec(targetdbp) & (U_GROUP | U_SETGID)) {
	  FILESTAT_Gid(TARGETDB_OldFileStatus(targetdbp)) =
	    FILESTAT_Gid(filestatusp_old);
	}
	if (TARGETDB_OldUpdateSpec(targetdbp) & U_MODE) {
	  FILESTAT_Mode(TARGETDB_OldFileStatus(targetdbp)) =
	    FILESTAT_Mode(filestatusp_old);
	}
      }
    } else {
      TARGETDB_OldFileStatus(targetdbp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETDB_ChildCount(targetdbp) = childcount;
    TARGETDB_Children(targetdbp) = NULL;
    if (childcount != 0) {
      TARGETDB_Children(targetdbp)
	= (TARGETDBENTRY **) emalloc(childcount * sizeof(TARGETDBENTRY *));
      for (i = 0, tp = TARGETDB_Children(targetdbp), fp = children;
	   (i < childcount) && (PROGRAM_ErrorNo == E_NULL);
	   i++, tp++, fp++)
	*tp = TargetDB(*fp);
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? targetdbp : NULL;
}



void 
TargetDB_Free(targetdbp)
     TARGETDB *targetdbp;
{
  register unsigned int i;
  register TARGETDB **childp;

  if (targetdbp == NULL) {
    FatalError(E_NULLTARGETDB,
	       "Attempt to to free NULL targetdb entry.\n");
  } else {
    if (TARGETDB_Name(targetdbp) != NULL)
      String_Free(TARGETDB_Name(targetdbp));
    if (TARGETDB_SourceList(targetdbp) != NULL)
      SourceList_Free(TARGETDB_SourceList(targetdbp));
    for (i = 0, childp = TARGETDB_Children(targetdbp);
	 (PROGRAM_ErrorNo == E_NULL) && (i < TARGETDB_ChildCount(targetdbp));
	 i++, childp++) {
      if (*childp != NULL)
	TargetDB_Free(*childp);
    }
    if (TARGETDB_Children(targetdbp) != NULL)
      free(TARGETDB_Children(targetdbp));
    free(targetdbp);
  }

  return;
}

/* $Source: /afs/andrew/system/src/local/depot2/015/src/lib/TargetDB/RCS/TargetDBUtil.c,v $ */
