/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Delete.c,v 1.6 1995/01/24 15:17:39 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"

static TARGETDB *TargetDB_DeletePathInSubtree();



TARGETDB *
TargetDB_DeleteTargetPath(targetdbp, pathtodelete, flags)
     TARGETDB *targetdbp;
     char *pathtodelete;
     unsigned short flags;
{
  TARGETDB *newtargetdbp;

  if (targetdbp == NULL) {
    return NULL;
  }
  if (pathtodelete == NULL) {
    FatalError(E_BADTARGETPATH,
	       "Attempt to delete NULL path in a targetdb.\n");
  }
  /* split pathtodelete into array of its components */
  if (PROGRAM_ErrorNo == E_NULL) {
    if (String_Comparator(pathtodelete, "/") == 0) {
      if (targetdbp != NULL)
	TargetDB_Free(targetdbp);
      newtargetdbp = NULL;
    } else {
      char **targetpatharray = NULL;
      STRINGARRAY *targetpathstringarray = NULL;


      targetpathstringarray = StringToStringArray(pathtodelete,
						  '/' /* delimited by /s */ ,
						  -1 /* no quotechar */ );
      if (PROGRAM_ErrorNo == E_NULL) {
	if (targetpathstringarray == NULL) {
	  targetpatharray = NULL;
	} else {
	  targetpatharray = STRINGARRAY_Values(targetpathstringarray);
	}
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	newtargetdbp = TargetDB_DeletePathInSubtree(targetdbp,
						    targetpatharray,
						    flags);
      }
      if ((PROGRAM_ErrorNo == E_NULL) && ( targetpathstringarray != NULL))
	(void) StringArray_Free(targetpathstringarray);
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



static TARGETDB *
TargetDB_DeletePathInSubtree(targetdbp, targetpatharray, flags)
     TARGETDB *targetdbp;
     char **targetpatharray;
     unsigned short flags;
{
  TARGETDB *newtargetdbp;

  int childnodeindex;
  TARGETDB *childnodep;
  TARGETDB *newchildnodep;

  if (targetdbp == NULL) {
    FatalError(E_NULLTARGETDB,
	       "Attempt to delete subtree of NULL targetdb entry.\n");
  }
  if (targetpatharray == NULL) {
    FatalError(E_BADTARGETPATH,
	       "Attempt to delete NULL path in a targetdb.\n");
  }
  newtargetdbp = targetdbp;

  if (PROGRAM_ErrorNo == E_NULL) {
    if (*targetpatharray == NULL) {	/* node to be deleted */
      if (newtargetdbp != NULL)
	TargetDB_Free(newtargetdbp);
      newtargetdbp = NULL;
    } else {
      /* get a handle on child node corresponding to path to be deleted */
      childnodeindex = TargetDB_LocateIndexToChildNode(newtargetdbp,
						       *targetpatharray,
						       flags);
      if (PROGRAM_ErrorNo == E_NULL) {
	if (childnodeindex < 0) {
	  if (flags & TDB_LAX)
	    childnodep = NULL;
	  else {
	    FatalError(E_NOSUCHTARGETDBCHILD,
		       "No entry named %s found in search for child node.\n",
		       *targetpatharray);
	  }
	} else
	  childnodep = *(TARGETDB_Children(newtargetdbp) + childnodeindex);
      }
      /* recursively delete path to be deleted */
      if ((PROGRAM_ErrorNo == E_NULL) && (childnodep != NULL)) {
	newchildnodep = TargetDB_DeletePathInSubtree(childnodep,
						     targetpatharray + 1,
						     flags);
	if (PROGRAM_ErrorNo == E_NULL) {
	  *(TARGETDB_Children(newtargetdbp) + childnodeindex) = newchildnodep;
	  if (newchildnodep == NULL) {
	    newtargetdbp = TargetDB_RemoveChildByIndex(newtargetdbp,
						       childnodeindex);
	    if ((PROGRAM_ErrorNo == E_NULL)
		&& (TARGETDB_ChildCount(newtargetdbp) == 0)) {	
	      /* no children left - fold up node */
	      if (newtargetdbp != NULL)
		TargetDB_Free(newtargetdbp);
	      newtargetdbp = NULL;
	    }
	  }
	}
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



TARGETDBENTRY *
TargetDB_RemoveChildByIndex(targetdbnodep,
			    childnodeindex)
     TARGETDBENTRY *targetdbnodep;
     int childnodeindex;
{
  register unsigned int i;
  register TARGETDBENTRY **fp, **tp;

  TARGETDBENTRY *childnodep;

  if (targetdbnodep == NULL) {
    FatalError(E_NULLTARGETDB,
	       "Attempt to remove child from NULL targetdb.\n");
  }
  if ((childnodeindex < 0)
      || (childnodeindex > TARGETDB_ChildCount(targetdbnodep))) {
    FatalError(E_BADTARGETDBCHILDINDEX,
	       "Attempt to remove non-existent child from targetdb.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    childnodep = *(TARGETDB_Children(targetdbnodep) + childnodeindex);
    if (childnodep != NULL)
      TargetDB_Free(childnodep);
    *(TARGETDB_Children(targetdbnodep) + childnodeindex) = NULL;
    TARGETDB_ChildCount(targetdbnodep)--;
  }
  for (i = childnodeindex;
    (PROGRAM_ErrorNo == E_NULL) && (i < TARGETDB_ChildCount(targetdbnodep));
       i++) {
    tp = TARGETDB_Children(targetdbnodep) + i;
    fp = tp + 1;
    *tp = *fp;
  }

  if (PROGRAM_ErrorNo == E_NULL)
    TARGETDB_Children(targetdbnodep)
      = (TARGETDBENTRY **) erealloc((void *) TARGETDB_Children(targetdbnodep),
				    TARGETDB_ChildCount(targetdbnodep)
				    * sizeof(TARGETDBENTRY *));

  return (PROGRAM_ErrorNo == E_NULL) ? targetdbnodep : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/TargetDB/RCS/TargetDB_Delete.c,v $ */
