/***********************************************************
        Copyright 1995 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: compress.c,v 1.1 1995/02/13 06:44:47 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

#include "depotlib.h"
#include "util.h"
#include "Error.h"

/*
 * Silly routines to convert a string into something we can exec
 */

#ifndef HAVE_STDLIB_H
extern char *getenv();
#endif

static STRINGARRAY *
process_string(name) 
  char *name; 
{
  char *str;
  STRINGARRAY *av;

  if ((str = getenv(name)) == NULL) {
    str = name;
  }

  av = StringToStringArray(str,' ', 0);
  return av;
}

STRINGARRAY *
compress_command() {
  return process_string(DEPOT_COMPRESS);
}

STRINGARRAY *
decompress_command() {
  return process_string(DEPOT_DECOMPRESS);
}
  
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/util/RCS/compress.c,v $ */
