/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: malloc.c,v 1.6 1994/08/13 01:54:54 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"


void *emalloc(size)
  size_t size;
/* malloc(3) with error checking */
{
  void *ptr;

  if ((ptr = (void *)malloc(size)) == NULL)
    {
      FatalError(E_OUTOFMEMORY,
		 " out of memory: malloc() failed to allocate %d bytes\n", size);
      return NULL;
    }
  else
    return ptr;
}


void *ecalloc(nelem, size)
  size_t nelem, size;
/* calloc(3) with error checking */
{
  void *ptr;

  if ((ptr = (void *)calloc(nelem, size)) == NULL)
    {
      FatalError(E_OUTOFMEMORY,
		 " out of memory: calloc() failed to allocate %d bytes\n", size);
      return NULL;
    }
  else
    return ptr ;
}


void *erealloc(ptr, size)
  void *ptr;
  size_t size;
/* realloc(3) with error checking */
{
  void *newptr;

  if (size == 0) {
    return ptr;
  }
  if ((newptr = (void *)realloc(ptr, size)) == NULL)
    {
      FatalError(E_OUTOFMEMORY,
		 " out of memory: realloc() failed to allocate %d bytes\n", size);
      return NULL;
    }
  else
    return newptr ;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/util/RCS/malloc.c,v $ */
