/*
 * DIRB
 *
 * calculanec.c - Obtiene el codigo NEC
 * Ultima modificacion: 23/11/2005
 *
 */

#include "dirb.h"



/*
 * CALCULA_NEC: Obtiene el codigo de pagina no existente
 *
 */

struct result calcula_nec(char *direccion) {
  struct result nec1, nec2;
  struct result mynec;
  char url[STRING_SIZE];
  char rand_url1[STRING_SIZE]="randomfile1";
  char rand_url2[STRING_SIZE]="frand2";

  // Inicializamos

  memset(&nec1, 0, sizeof(struct result));
  memset(&nec2, 0, sizeof(struct result));
  memset(&mynec, 0, sizeof(struct result));


  // Calculo del primer NEC

  memset(url, 0, STRING_SIZE);
  strncpy(url, direccion, STRING_SIZE-1);

  strncat(url, rand_url1, STRING_SIZE-1-strlen(direccion));

  nec1=get_url(url);

  if(options.debuging>1) printf("[+] calcula_nec() NEC1: %d\n", nec1.codigo_http);


  switch(nec1.codigo_http) {

    case 200:
      if(options.finetunning==1) {
        nec1.body_size=nec1.body_words;
        }
      break;

    case 301:
    case 302:

      if(options.finetunning==1) {
	    location_clean(nec1.location, rand_url1);
	    if(options.debuging>3) printf("[+++] calcula_nec() CLEANED1: %s\n", nec1.location);
	    }

      break;

    default:
	  break;

    }


  // Calculo del segundo NEC

  memset(url, 0, STRING_SIZE);
  strncpy(url, direccion, STRING_SIZE-1);

  strncat(url, rand_url2, STRING_SIZE-1-strlen(direccion));

  nec2=get_url(url);

  if(options.debuging>1) printf("[+] calcula_nec() NEC2: %d\n", nec2.codigo_http);


  // Comparamos

  if(nec1.codigo_http==nec2.codigo_http) {

    switch(nec2.codigo_http) {

      case 200:

        if(options.finetunning==1) {
          nec2.body_size=nec2.body_words;
	      }

        if(nec1.body_size!=nec2.body_size) {
          IMPRIME("(!) WARNING: NEC page not stable, unable to determine the correct URLs {200}.\n");
          IMPRIME("\t(Try using FineTunning: '-f')\n");
          if(options.exitonwarn) exit(-3);
          } else {
          mynec.body_size=nec1.body_size;
          }
        break;

      case 301:
      case 302:

        if(options.finetunning==1) {
          location_clean(nec2.location, rand_url2);
          if(options.debuging>3) printf("[+++] calcula_nec() CLEANED2: %s\n", nec2.location);
          }

        if(strncmp(nec1.location, nec2.location, STRING_SIZE-1)!=0) {
          IMPRIME("(!) WARNING: NEC page not stable, unable to determine the correct URLs {30X}.\n");
          IMPRIME("\t(Try using FineTunning: '-f')\n");
          if(options.exitonwarn) exit(-3);
          } else {
          strncpy(mynec.location, nec1.location, STRING_SIZE-1);
          }
        break;

      default:
        mynec.body_size=nec1.body_size;
        break;

	  }

	} else {

    IMPRIME("(!) WARNING: NEC not stable, unable to determine the correct URLs {%d,%d}.\n", nec1.codigo_http, nec2.codigo_http);
    IMPRIME("\t(Try using Application Server Mode)\n");
    if(options.exitonwarn) exit(-3);
    }

  mynec.codigo_http=nec1.codigo_http;
  strncpy(mynec.server, nec1.server, STRING_SIZE-1);

  if(options.debuging>1) printf("[+] calcula_nec() NEC: %d - %d\n", mynec.codigo_http, mynec.body_size);

  return mynec;

}


