/*
 * DIRB
 *
 * crea_wordlist.c - Crea la lista de palabras a probar
 * Last modification: 19/06/2005
 *
 */

#include <stdio.h>
#include "dirb.h"


/*
 * CREA_WORDLIST: Crea la lista de palabras a probar a partir de un fichero
 *
 */

struct words *crea_wordlist(char *ficheros) {
  FILE *file;
  struct words *current;
  struct words *exts_current;
  char cbuffer[STRING_SIZE];
  char current_file[STRING_SIZE];
  char *apunt;


  // Inicializamos

  current=(struct words *)malloc(sizeof(struct words));
  memset(current, 0, sizeof(struct words));
  wordlist_base=current;
  contador=0;


  IMPRIME("Generating Wordlist...\n");


  // Abrimos el fichero de extensiones y creamos su lista

  if(options.extensions_file) {

    exts_current=crea_fich_wordlist(options.exts_file);
    exts_base=exts_current;

    } else if(options.extensions_list) {

    exts_current=crea_extslist(options.exts_list);
    exts_base=exts_current;

    } else {

    exts_current=(struct words *)malloc(sizeof(struct words));
    memset(exts_current, 0, sizeof(struct words));
    exts_base=exts_current;

    strncpy(exts_current->word, "", 2);

    exts_current->siguiente=(struct words *)malloc(sizeof(struct words));
    exts_current=exts_current->siguiente;
    memset(exts_current, 0, sizeof(struct words));

    }


  // Bucle de generacion de wordlist

  while(strlen(ficheros)>0) {

    // Separamos la lista de ficheros

    strncpy(current_file, ficheros, STRING_SIZE-1);

    apunt=(char *)strchr(current_file, ',');

    if(apunt!=0) *apunt='\0';

    ficheros=ficheros+strlen(current_file)+1;

    // Abrimos el fichero

    if((file=fopen(current_file, "r"))==0) {
      IMPRIME("\n(!) FATAL: Error opening wordlist file: %s\n", current_file);
      exit(-1);
      }

    // Bucle por cada fichero

    while(!feof(file)) {

      // Inicializamos

      memset(cbuffer, 0, STRING_SIZE);


      // Leemos y limpiamos

      if(fgets(cbuffer, STRING_SIZE-1, file)==0) {
        if(options.debuging>4) printf("[++++] crea_wordlist() Ending the parse of file: %s\n", current_file);
        break;
        }

      limpia(cbuffer);


      // Bucle de extensiones

      exts_current=exts_base;

      while(exts_current->siguiente!=0) {

        // Metemos en la lista

        strncpy(current->word, cbuffer, STRING_SIZE-1);
        strncat(current->word, exts_current->word, STRING_SIZE-1-strlen(current->word));

        if(options.debuging>5) printf("[+++++] crea_wordlist() WORD: %s\n", current->word);

        contador++;

        current->siguiente=(struct words *)malloc(sizeof(struct words));
        current=current->siguiente;
        memset(current, 0, sizeof(struct words));
        exts_current=exts_current->siguiente;

        }

      }

    fclose(file);

    }


  // Operaciones finales

  wordlist_final=current;

  elimina_dupwords(wordlist_base);

  IMPRIME("Generated Words: %d\n", contador);

  if(contador>BIGWORDLIST) {
    IMPRIME("(!) WARNING: Wordlist is too large. This will take a long time to end.\n");
    IMPRIME("\t(Use mode '-w' if you want to scan anyway)\n");
    if(options.exitonwarn) exit(-3);
    }

  return wordlist_base;

}


/*
 * CREA_FICH_WORDLIST: Crea una lista de palabras a partir de un fichero
 *
 */

struct words *crea_fich_wordlist(char *fichero) {
  FILE *file;
  char cbuffer[STRING_SIZE];
  struct words *ecurrent;
  struct words *ebase;
  struct words *efinal;


  // Inicializamos

  ecurrent=(struct words *)malloc(sizeof(struct words));
  memset(ecurrent, 0, sizeof(struct words));
  memset(cbuffer, 0, STRING_SIZE);
  ebase=ecurrent;


  // Abrimos el fichero y creamos su lista

  if((file=fopen(fichero, "r"))==0) {
	IMPRIME("\n(!) FATAL: Error opening words file: %s\n", fichero);
	exit(-1);
	}


  while(!feof(file)) {

	memset(cbuffer, 0, STRING_SIZE);

	// Leemos y limpiamos

	if(fgets(cbuffer, STRING_SIZE-1, file)==0) {
      if(options.debuging>4) printf("[++++] crea_fich_wordlist() Ending the parse of file: %s\n", fichero);
      break;
      }

    limpia(cbuffer);

    // Metemos en la lista

    strncpy(ecurrent->word, cbuffer, STRING_SIZE-1);

    if(options.debuging>5) printf("[+++++] crea_fich_wordlist() ADD_WORD: %s\n", ecurrent->word);

    ecurrent->siguiente=(struct words *)malloc(sizeof(struct words));
    ecurrent=ecurrent->siguiente;
    memset(ecurrent, 0, sizeof(struct words));

    }

  elimina_dupwords(ebase);

  ecurrent=ebase;

  while(ecurrent->siguiente!=0) {
    if(options.debuging>5) printf("[+++++] crea_fich_wordlist() WORD: %s\n", ecurrent->word);
    ecurrent=ecurrent->siguiente;
    }

  efinal=ecurrent;

  fclose(file);

  return ebase;

}



/*
 * CREA_EXTSLIST: Crea la lista de extensiones
 *
 */

struct words *crea_extslist(char *lista) {
  char cbuffer[STRING_SIZE];
  struct words *ecurrent;
  struct words *ebase;
  struct words *efinal;
  char *apunt;


  // Inicializamos

  ecurrent=(struct words *)malloc(sizeof(struct words));
  memset(ecurrent, 0, sizeof(struct words));
  memset(cbuffer, 0, STRING_SIZE);
  ebase=ecurrent;


  while(strlen(lista)>0) {

    // Separamos la lista de extensiones

    strncpy(cbuffer, lista, STRING_SIZE-1);

    apunt=(char *)strchr(cbuffer, ',');

    if(apunt!=0) *apunt='\0';

    lista=lista+strlen(cbuffer)+1;

    // Metemos en la lista

    strncpy(ecurrent->word, cbuffer, STRING_SIZE-1);

    if(options.debuging>5) printf("[+++++] crea_extslist() EXT: %s\n", ecurrent->word);

    ecurrent->siguiente=(struct words *)malloc(sizeof(struct words));
    ecurrent=ecurrent->siguiente;
    memset(ecurrent, 0, sizeof(struct words));

    }

  elimina_dupwords(ebase);

  ecurrent=ebase;

  while(ecurrent->siguiente!=0) {
    if(options.debuging>5) printf("[+++++] crea_extslist() EXT: %s\n", ecurrent->word);
    ecurrent=ecurrent->siguiente;
    }

  efinal=ecurrent;

  return ebase;

}



