/*
 * this file is ripped of the FutureGroove Music's
 * multimedia library
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/uio.h>
#include <sys/types.h>

int last_char;

//
// read a char from a stream without waiting if none is present
//
int UNIX_getc_nowait(FILE *stream)
{
  char c;
  int nread;
  int chr, *ch = &chr;
  int eof, *end_of_file = &eof;
  int avl, *avail = &avl;
  
  int fd = fileno (stream);
  struct termios otermios_rec, termios_rec;
#if defined (linux)
  int flags;
#endif

  if (isatty (fd))
    {
      tcgetattr (fd, &termios_rec);
      memcpy (&otermios_rec, &termios_rec, sizeof (struct termios));

      /* Set RAW mode */
      termios_rec.c_lflag = termios_rec.c_lflag & ~ICANON;

      /* Set zero wait period */
      termios_rec.c_cc[VMIN] = 0;
      termios_rec.c_cc[VTIME] = 0;
      tcsetattr (fd, TCSANOW, &termios_rec);

#if defined (linux)
      /* If we don't set this mode on Linux, Ctrl-C and Ctrl-Z processing
         get messed up */
      flags = fcntl (fd, F_GETFL);
      fcntl (fd, F_SETFL, O_NONBLOCK | flags);
#endif

      nread = read (fd, &c, 1);
      if (nread > 0)
        {
          if (c == termios_rec.c_cc[VEOF])
            {
              *avail = 0;
              *end_of_file = 1;
            }
          else
            {
              *avail = 1;
              *end_of_file = 0;
            }
        }
      else
        {
          *avail = 0;
          *end_of_file = 0;
        }

#if defined(linux)
      fcntl (fd, F_SETFL, flags);
#endif
      tcsetattr (fd, TCSANOW, &otermios_rec);
      *ch = c;
    }
  else
    /* If we're not on a terminal, then we don't need any fancy processing */
    {
      *ch = fgetc (stream);
      if (feof (stream))
        {
          *end_of_file = 1;
          *avail = 0;
        }
      else
        {
          *end_of_file = 0;
          *avail = 1;
        }
    }
   last_char = *ch;

   if(*avail == 0) return 0;
   else return *ch;
}

