
#include "crc.h"

typedef unsigned short crctabtype[256];

#ifdef WITHCRC32
typedef unsigned long crc32tabtype[256];
#endif

static crctabtype crc16_table = {
  0, 0xc0c1L, 0xc181L, 0x140, 0xc301L, 0x3c0, 0x280, 0xc241L, 0xc601L, 0x6c0,
  0x780, 0xc741L, 0x500, 0xc5c1L, 0xc481L, 0x440, 0xcc01L, 0xcc0, 0xd80,
  0xcd41L, 0xf00, 0xcfc1L, 0xce81L, 0xe40, 0xa00, 0xcac1L, 0xcb81L, 0xb40,
  0xc901L, 0x9c0, 0x880, 0xc841L, 0xd801L, 0x18c0, 0x1980, 0xd941L, 0x1b00,
  0xdbc1L, 0xda81L, 0x1a40, 0x1e00, 0xdec1L, 0xdf81L, 0x1f40, 0xdd01L, 0x1dc0,
  0x1c80, 0xdc41L, 0x1400, 0xd4c1L, 0xd581L, 0x1540, 0xd701L, 0x17c0, 0x1680,
  0xd641L, 0xd201L, 0x12c0, 0x1380, 0xd341L, 0x1100, 0xd1c1L, 0xd081L, 0x1040,
  0xf001L, 0x30c0, 0x3180, 0xf141L, 0x3300, 0xf3c1L, 0xf281L, 0x3240, 0x3600,
  0xf6c1L, 0xf781L, 0x3740, 0xf501L, 0x35c0, 0x3480, 0xf441L, 0x3c00, 0xfcc1L,
  0xfd81L, 0x3d40, 0xff01L, 0x3fc0, 0x3e80, 0xfe41L, 0xfa01L, 0x3ac0, 0x3b80,
  0xfb41L, 0x3900, 0xf9c1L, 0xf881L, 0x3840, 0x2800, 0xe8c1L, 0xe981L, 0x2940,
  0xeb01L, 0x2bc0, 0x2a80, 0xea41L, 0xee01L, 0x2ec0, 0x2f80, 0xef41L, 0x2d00,
  0xedc1L, 0xec81L, 0x2c40, 0xe401L, 0x24c0, 0x2580, 0xe541L, 0x2700, 0xe7c1L,
  0xe681L, 0x2640, 0x2200, 0xe2c1L, 0xe381L, 0x2340, 0xe101L, 0x21c0, 0x2080,
  0xe041L, 0xa001L, 0x60c0, 0x6180, 0xa141L, 0x6300, 0xa3c1L, 0xa281L, 0x6240,
  0x6600, 0xa6c1L, 0xa781L, 0x6740, 0xa501L, 0x65c0, 0x6480, 0xa441L, 0x6c00,
  0xacc1L, 0xad81L, 0x6d40, 0xaf01L, 0x6fc0, 0x6e80, 0xae41L, 0xaa01L, 0x6ac0,
  0x6b80, 0xab41L, 0x6900, 0xa9c1L, 0xa881L, 0x6840, 0x7800, 0xb8c1L, 0xb981L,
  0x7940, 0xbb01L, 0x7bc0, 0x7a80, 0xba41L, 0xbe01L, 0x7ec0, 0x7f80, 0xbf41L,
  0x7d00, 0xbdc1L, 0xbc81L, 0x7c40, 0xb401L, 0x74c0, 0x7580, 0xb541L, 0x7700,
  0xb7c1L, 0xb681L, 0x7640, 0x7200, 0xb2c1L, 0xb381L, 0x7340, 0xb101L, 0x71c0,
  0x7080, 0xb041L, 0x5000, 0x90c1L, 0x9181L, 0x5140, 0x9301L, 0x53c0, 0x5280,
  0x9241L, 0x9601L, 0x56c0, 0x5780, 0x9741L, 0x5500, 0x95c1L, 0x9481L, 0x5440,
  0x9c01L, 0x5cc0, 0x5d80, 0x9d41L, 0x5f00, 0x9fc1L, 0x9e81L, 0x5e40, 0x5a00,
  0x9ac1L, 0x9b81L, 0x5b40, 0x9901L, 0x59c0, 0x5880, 0x9841L, 0x8801L, 0x48c0,
  0x4980, 0x8941L, 0x4b00, 0x8bc1L, 0x8a81L, 0x4a40, 0x4e00, 0x8ec1L, 0x8f81L,
  0x4f40, 0x8d01L, 0x4dc0, 0x4c80, 0x8c41L, 0x4400, 0x84c1L, 0x8581L, 0x4540,
  0x8701L, 0x47c0, 0x4680, 0x8641L, 0x8201L, 0x42c0, 0x4380, 0x8341L, 0x4100,
  0x81c1L, 0x8081L, 0x4040
};



static crctabtype ccitt_table = {
  0, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7, 0x8108L, 0x9129L,
  0xa14aL, 0xb16bL, 0xc18cL, 0xd1adL, 0xe1ceL, 0xf1efL, 0x1231, 0x210, 0x3273,
  0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6, 0x9339L, 0x8318L, 0xb37bL, 0xa35aL,
  0xd3bdL, 0xc39cL, 0xf3ffL, 0xe3deL, 0x2462, 0x3443, 0x420, 0x1401, 0x64e6,
  0x74c7, 0x44a4, 0x5485, 0xa56aL, 0xb54bL, 0x8528L, 0x9509L, 0xe5eeL,
  0xf5cfL, 0xc5acL, 0xd58dL, 0x3653, 0x2672, 0x1611, 0x630, 0x76d7, 0x66f6,
  0x5695, 0x46b4, 0xb75bL, 0xa77aL, 0x9719L, 0x8738L, 0xf7dfL, 0xe7feL,
  0xd79dL, 0xc7bcL, 0x48c4, 0x58e5, 0x6886, 0x78a7, 0x840, 0x1861, 0x2802,
  0x3823, 0xc9ccL, 0xd9edL, 0xe98eL, 0xf9afL, 0x8948L, 0x9969L, 0xa90aL,
  0xb92bL, 0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0xa50, 0x3a33, 0x2a12,
  0xdbfdL, 0xcbdcL, 0xfbbfL, 0xeb9eL, 0x9b79L, 0x8b58L, 0xbb3bL, 0xab1aL,
  0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0xc60, 0x1c41, 0xedaeL,
  0xfd8fL, 0xcdecL, 0xddcdL, 0xad2aL, 0xbd0bL, 0x8d68L, 0x9d49L, 0x7e97,
  0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0xe70, 0xff9fL, 0xefbeL,
  0xdfddL, 0xcffcL, 0xbf1bL, 0xaf3aL, 0x9f59L, 0x8f78L, 0x9188L, 0x81a9L,
  0xb1caL, 0xa1ebL, 0xd10cL, 0xc12dL, 0xf14eL, 0xe16fL, 0x1080, 0xa1, 0x30c2,
  0x20e3, 0x5004, 0x4025, 0x7046, 0x6067, 0x83b9L, 0x9398L, 0xa3fbL, 0xb3daL,
  0xc33dL, 0xd31cL, 0xe37fL, 0xf35eL, 0x2b1, 0x1290, 0x22f3, 0x32d2, 0x4235,
  0x5214, 0x6277, 0x7256, 0xb5eaL, 0xa5cbL, 0x95a8L, 0x8589L, 0xf56eL,
  0xe54fL, 0xd52cL, 0xc50dL, 0x34e2, 0x24c3, 0x14a0, 0x481, 0x7466, 0x6447,
  0x5424, 0x4405, 0xa7dbL, 0xb7faL, 0x8799L, 0x97b8L, 0xe75fL, 0xf77eL,
  0xc71dL, 0xd73cL, 0x26d3, 0x36f2, 0x691, 0x16b0, 0x6657, 0x7676, 0x4615,
  0x5634, 0xd94cL, 0xc96dL, 0xf90eL, 0xe92fL, 0x99c8L, 0x89e9L, 0xb98aL,
  0xa9abL, 0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x8e1, 0x3882, 0x28a3,
  0xcb7dL, 0xdb5cL, 0xeb3fL, 0xfb1eL, 0x8bf9L, 0x9bd8L, 0xabbbL, 0xbb9aL,
  0x4a75, 0x5a54, 0x6a37, 0x7a16, 0xaf1, 0x1ad0, 0x2ab3, 0x3a92, 0xfd2eL,
  0xed0fL, 0xdd6cL, 0xcd4dL, 0xbdaaL, 0xad8bL, 0x9de8L, 0x8dc9L, 0x7c26,
  0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0xcc1, 0xef1fL, 0xff3eL,
  0xcf5dL, 0xdf7cL, 0xaf9bL, 0xbfbaL, 0x8fd9L, 0x9ff8L, 0x6e17, 0x7e36,
  0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0xed1, 0x1ef0
};

#ifdef WITHCRC32
static crc32tabtype crc32_table = {
  0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
  0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
  0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
  0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
  0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
  0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
  0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
  0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
  0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
  0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
  0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
  0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
  0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
  0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
  0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
  0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
  0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
  0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
  0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
  0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
  0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
  0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
  0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
  0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
  0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
  0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
  0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
  0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
  0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
  0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
  0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
  0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
  0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
  0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
  0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
  0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
  0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
  0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
  0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
  0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
  0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
  0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
  0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
  0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
  0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
  0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
  0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
  0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
  0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
  0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
  0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
  0x2d02ef8dL
};
#endif

void crc_16(unsigned char Data, unsigned short *crc)
{
  *crc = ((*crc) >> 8) ^ crc16_table[((*crc) ^ Data) & 0xff];
}


void crc_16_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc = ((*crc) >> 8) ^ crc16_table[((*crc) ^ *adr++) & 0xff];
}


void crcfcs(unsigned char Data, unsigned short *crc)
{
  *crc = ((*crc) >> 8) ^ ccitt_table[((*crc) ^ Data) & 0xff];
}


void crcfcs_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc = ((*crc) >> 8) ^ ccitt_table[((*crc) ^ *adr++) & 0xff];
}


void crcthp(unsigned char Data, unsigned short *crc)
{
  *crc = ((*crc) << 8) ^ Data ^ ccitt_table[(*crc) >> 8];
}


void crcthp_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc = ((*crc) << 8) ^ *adr++ ^ ccitt_table[(*crc) >> 8];
}


void crcfbb(unsigned char Data, unsigned short *crc)
{
  *crc = ((*crc) << 8) ^ ccitt_table[((*crc) >> 8) ^ Data];
}


void crcfbb_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc = ((*crc) << 8) ^ ccitt_table[((*crc) >> 8) ^ *adr++];
}

#ifdef WITHCRC32
void crc_32_buf(unsigned char *adr, long size, unsigned long *crc)
{
  while (size-- > 0)
    *crc = crc32_table[((int)*crc ^ (*adr++)) & 0xff] ^ (*crc >> 8);
/*  *crc = *crc ^ 0xffffffffL; */
}
#endif

void checksum16(unsigned char Data, unsigned short *crc)
{
  *crc += Data;
}


void checksum16_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc += *adr++;
}


void checksum8(unsigned char Data, unsigned short *crc)
{
  *crc = (*crc + Data) & 0xff;
}


void checksum8_buf(unsigned char *adr, long size, unsigned short *crc)
{
  while (size-- > 0)
    *crc += *adr++;
  *crc &= 0xff;
}


