/* Header for module tools, generated by p2c */
#ifndef TOOLS_H
#define TOOLS_H

#include "pastrix.h"
#include "boxlocal.h"


typedef void (*fdoutproctype)(const short x, const char *s);

extern char conv_umlaut_from_local(char code);
extern char conv_umlaut_to_local(char code);
extern void conv_string_from_local(char *s);
extern void conv_string_to_local(char *s);
extern boolean conv_file_umlaut(boolean to_local, char *fname);
extern boolean positive_arg(char *s);
extern void dp_watchdog(short what, short value);
extern short packer(boolean gzip, boolean preserve_original, boolean encode, char *s1, char *s2, boolean crlfconv);
extern short mempacker(boolean gzip, boolean encode, char *mem, long size,
			   char **rmem, long *rsize, char *f2,
			   boolean crlfconv);
extern short call_prg(char *prog, char *par, char *redir);
extern short exec_prg(char *prog, char *par, char *redir);
extern void calc_MD5_pw(char *MD5prompt, char *MD5pw, char *MD5result);
extern void calc_MD2_pw(char *MD2prompt, char *MD2pw, char *MD2result);
extern void calc_MD_prompt(boolean only_numbers, char *MDprompt);
extern short calc_prozent(long v1, long v2);
extern void stripcr(char *fn);
extern boolean insecure(char *s);
#ifdef HAS_NO_STRCASECMP
extern boolean useq(char *s1, char *s2);
#else
#define useq(s1, s2) (strcasecmp(s1, s2) == 0)
#endif
extern short uspos(char *s1, char *s2);
extern boolean get_fileline(char *fn, short line, char *l);
extern boolean get_keyline(char *fn, char *key, boolean casesense, char *l);
extern boolean replace_keyline(char *fn, char *key, boolean casesense,
			       char *e);
extern void expand_tabs(char *hs, short tabsize);
extern boolean give_cookie(short x, fdoutproctype outproc, char *fname);
extern void calc_ixsecs_to_string(time_t l, char *hs);
extern void quick_speed(void);
extern long get_cpu_speed(short mode);
extern short filecp(char *filea, char *fileb, char *root, boolean del_source,
		    short x, fdoutproctype outproc);
extern void file_delete(short x, char *cmd, fdoutproctype outproc);
extern void file_dir(boolean supervisor, char *path, char *options, short x,
		     fdoutproctype outproc);
extern char calccs(char *s);
extern char strcpycs(register char *s2, register char *s1);
extern void Gettimestr(char *ts);
extern void GetDatestr(char *ds);
extern unsigned short Make_DTime(short Hour, short Min, short Sec);
extern unsigned short Make_DDate(short Day, short Mon, short Yr);
extern void Get_DDate(unsigned short ddate, short *Day, short *Mon, short *Yr);
extern void Get_DTime(unsigned short dtime, short *Hour, short *Min, short *Sec);
extern time_t calcfdate(unsigned short date, unsigned short time);
extern time_t calc_ixtime(short d, short m, short y, short h, short mi, short s);
extern void decode_ixtime(time_t ix, short *d, short *m, short *y, short *h,
			  short *min, short *s);
extern void free_languages(languagetyp **root);
extern void user_language(char **root, long *size, char *fname, char *call,
			  char *lan);
extern void load_languages(languagetyp **root, char *pfad);
extern void get_language(short nr, languagetyp *root, char *which, char *s);
extern short week_day(short d, short m, short y);
extern void wochentag(char *lan, short d, short m, short y, char *s);
extern void datum2string(unsigned short datum, char *datestring);
extern void datum22string(short day, short mon, short year, char *datestring);
extern void datum22string4(short day, short mon, short year, char *datestring);
extern void ixdatum2string(time_t datum, char *datestring);
extern void ixdatum2string4(time_t datum, char *datestring);
extern void zeit2string(unsigned short zeit, char *timestring);
extern void zeit22string(short hour, short min, short sec, char *timestring);
extern void dosdt2string(unsigned short date, unsigned short time, char *timestring);
extern void ixzeit2string(time_t zeit, char *timestring);
extern void ix2string(time_t zeit, char *timestring);
extern void ix2string4(time_t zeit, char *timestring);
extern time_t dos2ixtime(unsigned short ddate, unsigned short dtime);
extern void ix2dostime(time_t ix, unsigned short *ddate, unsigned short *dtime);
extern time_t string2ixtime(char *ds, char *ts);
extern unsigned short str2datum(char *datestring);
extern unsigned short str2zeit(char *timestring);
extern void unhpath(char *ins, char *outs);
extern void del_tnc3port(char *callin, char *callout);
extern void del_callextender(char *callin, char *callout);
extern void get_callextender(char *callin, char *callout);
extern boolean callsign(char *rubrik);
extern boolean hcallsign(char *rubrik);
extern time_t utc_clock(void);
extern time_t daydiff(unsigned short date1, unsigned short time1,
		    unsigned short date2, unsigned short time2);
extern unsigned short file_crc(short methode, char *name,
			       unsigned short preload, long start, long size);
extern boolean prefix(char *call, char *subst, char *name, double *lon, double *lat,
		      short *waz, short *itu, char *continent);
extern void loc_dist(double o1, double n1, double o2, double n2,
		     double *entfernung, double *richtung, double *gegenrichtung);
extern boolean calc_qth(char *loc, double *l, double *b);
extern boolean get_wwloc(char *inp, char *outp);
extern boolean get_digimap_data(boolean bbs, char *call_, char *sysop, char *mbsysop, char *qthloc,
			 char *qthname, char *mbsystem, char *digisystem, char *remarks,
			 char *updatetime);
extern short merge_digimap_data(char *base, char *updfile);
extern short FuzzyMatching(char *CheckStr, char* SearchStr, short SearchStrLen,
      	      	      	    short NGram1Len, short NGram2Len);
extern void PrepareFuzzySearch(char *SearchStr, char *NormalisedStr,
			      	short *SearchStrLen, short *NGram1Len, short *NGram2Len);
extern boolean check_other_callsyntax(char *syntax);

#define sys_ixtime() time(NULL)
#define compare(w, cmd) (*w && (strstr(cmd, w) == cmd))
#define conv_file_to_local(fname) conv_file_umlaut(true, fname)
#define conv_file_from_local(fname) conv_file_umlaut(false, fname)

#endif /*TOOLS_H*/

