/*
 *****************************************************************
 *                                                               *
 *    Copyright (c) DynIP,  a division of                        *
 *    CanWeb Internet Services Ltd., 1997-1998                   *
 *								 *
 * Redistribution and use in source and binary forms, with or	 * 
 * without modification, are permitted provided that the 	 *
 * following conditions are met:				 *
 *								 *
 * 1. Redistributions of source code must retain the above	 * 
 *    copyright notice, this list of conditions and the 	 *
 *    following disclaimer.					 *
 *								 *
 * 2. Redistributions in binary form must reproduce the above 	 *
 *    copyright notice, this list of conditions and the 	 *
 *    following disclaimer in the documentation and/or other 	 *
 *    materials provided with the distribution.			 *
 *								 *
 * 3. All advertising materials mentioning features or use of 	 *
 *    this software must display the following acknowledgement:	 *
 *								 *
 *    ``This product includes software developed by CanWeb	 *
 *      Internet Services Ltd.''				 *
 *								 *
 * 4. Neither CanWeb Internet Services Ltd., DynIP,              *
 *    or the developers of this software product may be used     *
 *    to endorse or promote products derived from this           *
 *    software without specific prior written permission.	 *
 *								 *
 * THIS SOFTWARE IS PROVIDED BY CANWEB INTERNET SERVICES LTD.	 *
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 	 *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY *
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO 	 *
 * EVENT SHALL CANWEB INTERNET SERVICES LTD. BE LIABLE FOR ANY 	 *
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 	 *
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 	 *
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 	 *
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 	 *
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT	 *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING*
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF*
 * THE POSSIBILITY OF SUCH DAMAGE.				 *
 *								 *
 *****************************************************************
 */

#include "log.h"
#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>
#include <string.h>

static int  iOptions, iLastError, iInitialize = 0;
static char achProgram[MODLOG_MAXTEMP];

int logOpen(char *pArgv, int options)
{
char	*pProgName;

if (iInitialize)
	return (iLastError = MODLOG_ERROR_INIT);

iOptions = options;

if ((pProgName = strrchr(pArgv, '/')) != NULL)
       	pProgName++;
else	pProgName = &pArgv[0];

if (iOptions & MODLOG_OPTION_SYSLOG)
	openlog(pProgName, LOG_PID, LOG_ERR);

sprintf(achProgram,"%s[%d]: ", pProgName, getpid());

iInitialize = 1;
return (iLastError = MODLOG_ERROR_NONE);
}

int logClose(void)
{
if (!iInitialize)
	return (iLastError = MODLOG_ERROR_INIT);

if (iOptions & MODLOG_OPTION_SYSLOG)
	closelog();

iInitialize = 0;
return (iLastError = MODLOG_ERROR_NONE);
}

int logWrite(char *pString, ...)
{
va_list va;
char    achBuffer[MODLOG_MAXBUFFER];

if (!iInitialize)
	return (iLastError = MODLOG_ERROR_INIT);

va_start(va, pString);

vsprintf(achBuffer, pString, va);

va_end(va);

if (iOptions & MODLOG_OPTION_TTY)
        printf("%s%s", achProgram,achBuffer);

if (iOptions & MODLOG_OPTION_SYSLOG)
	syslog(LOG_ERR,achBuffer);

return (iLastError = MODLOG_ERROR_NONE);
}

int logGetLastError(void)
{
int	iError;

iError 		= iLastError;
iLastError 	= MODLOG_ERROR_NONE;

return (iError);
}

int logSetLastError(int iError)
{
iLastError = iError;

return (MODLOG_ERROR_NONE);
}

