/*
   File: common.h
   Defines all routines that are common to all parser generators.
  
   CVS ID: "$Id: common.h,v 1.2 2002/11/12 13:36:01 marcs Exp $"
*/
#ifndef IncCommon
#define IncCommon

/* general includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>
#include <ebs_lexds.h>

/* local includes */
#include <tree.h>

/* coding support */
export FILE *out;
export void code_string (char *format, ...);
export void code_line (char *format, ...);
export void open_output_file (string basename, string infix, string suffix);
export void close_output_file ();

export void generate_std_includes (string_list predefs);
export string rule_qualifier (rule srule);
export void code_nodenrs (string fname);
export void code_lattices ();
export void code_lexicon ();

/* coding of values */
export void reset_temporaries ();
export int generate_temp_value (value val, int indent);

/* coding of non call members */
export void may_generate_lookahead_check (rule srule, string s);
export void generate_terminal (string s, int *nr_pushes);
export void generate_semiterminal (member m, int *sonnr,
				   int *nrpushes, int code_build);
export void generate_cut (int *nrpushes);


export void generate_affix_output (pos_list dpy, int *nrpushes);
export void generate_affix_decls (alt a);
export void generate_affix_undecls (alt a);
export void generate_display (pos_list dpy, int *nr_pushes);

export void generate_alt_header (rule srule, int altnr, alt a,
				 int code_build, int cut);
export void generate_alt_trailer (rule srule, int altnr, alt a,
				  int nrpushes, int code_build, int cut);
export void generate_placeholder_alt_header (rule srule,
					     int untyped, char look);
export void generate_placeholder_alt_trailer (rule srule,
					      int untyped, int nrpushes);
export void generate_buildplaceholdernode (rule srule,
					   int untyped, int *nrpushes);

export void generate_start_rule (string_list predefs);
export void generate_module_interface (string fname, string_list predefs);
export void generate_main (string fname);
#endif /* IncCommon */
