/*
   File: lex.h
   Does lexical analysis of EAGs
  
   CVS ID: "$Id: lex.h,v 1.2 2002/11/12 13:36:03 marcs Exp $"
*/
#ifndef IncLex
#define IncLex

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>

/* Define the tokens, to begin with undefined */
typedef enum { UNDEFINED,

/* General categories */
IDENTIFIER, NUMBER, STRING, SET,

/* Punctuation marks */
DOLLAR, COLON, DOUBLECOLON,
POINT, SEMICOLON, COMMA,
LEFTBRACE, RIGHTBRACE,
LEFTPARENTHESIS, RIGHTPARENTHESIS,
SUB, BUS, FLOW,
UP, STAR, PLUS,
EXCLAMATIONMARK, PIPE, CUT,

/* Reserved words */
GRAMMAR_SYMBOL, LEXICON_SYMBOL,
DEFINES_SYMBOL, USES_SYMBOL,

/* End of file */
EOFSYMBOL } symbol;

export string current_fname;
export int line, column;
export int nval;
export string sval;
export symbol thistoken;
export symbol nexttoken;
export int lex_errors;

export void init_lex ();
export void init_lex_file (FILE *fd, string fname);
export void insymbol ();

#endif /* IncLex */
