/*
   File: XSupp.c
   Defines the global variables to support building simple X11 applications

   CVS ID: "$Id: XSupp.c,v 1.2 2002/11/12 13:19:48 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libebs includes */
#include <ebs_global.h>

/* local includes */
#include <XSupp.h>

/*
   Keep lint from complaining about returned values
*/
export void exit ();

public Display *MyDisplay;
public Window MyRootWindow;
public Screen *MyRootScreen;
public Visual *MyVisual;
public Colormap MyColormap;
public int MyDepth;
public int MonoChrome;

public long White, Black;
public GC MyWhiteGC, MyBlackGC;

/*
   Open the display and fill in the necessary variables
*/
public void SetupSimpleXApplication ()
	{ if (!(MyDisplay = XOpenDisplay (DefaultDisplayName)))
	     { fprintf (stderr, "could not open X display\n");
	       exit (4);
	     };
	  SetupRSimpleXApplication ();
	};

/*
   Fill in the necessary variables provided MyDisplay is set
*/
public void SetupRSimpleXApplication ()
	{ XGCValues Gcv;
	  MyRootWindow = XDefaultRootWindow (MyDisplay);
	  MyRootScreen = XDefaultScreenOfDisplay (MyDisplay);
	  MyVisual = XDefaultVisualOfScreen (MyRootScreen);
	  MyColormap = XDefaultColormapOfScreen (MyRootScreen);
	  MyDepth = XDefaultDepthOfScreen (MyRootScreen);
	  MonoChrome = XCellsOfScreen (MyRootScreen) == 2;

	  White = XWhitePixelOfScreen (MyRootScreen);
	  Black = XBlackPixelOfScreen (MyRootScreen);
	  Gcv.foreground = White;
	  Gcv.background = Black;
	  Gcv.function = GXcopy;
	  MyWhiteGC = XCreateGC (MyDisplay, MyRootWindow,
			GCFunction | GCForeground | GCBackground, &Gcv);

	  Gcv.foreground = Black;
	  Gcv.background = White;
	  Gcv.function = GXcopy;
	  MyBlackGC = XCreateGC (MyDisplay, MyRootWindow,
			GCFunction | GCForeground | GCBackground, &Gcv);
	};
