/*
   File: eag_stddefs.h
   Implements the standard eag library

   CVSID: "$Id: eag_stddefs.h,v 1.2 2002/11/12 11:02:48 marcs Exp $"
*/
#ifndef IncEagStddefs
#define IncEagStddefs

/* libebs includes */
#include <ebs_global.h>

/* local includes */
#include <eag_ds.h>

export affix_node make_nil_affix ();
export affix_node make_string_affix ();
export affix_node make_tuple_affix ();
export affix_node make_nonlat_affix ();
export affix_node make_int_affix ();

export void rec_nil_value ();
export void rec_string_value ();
export void rec_tuple_value ();
export void rec_int_value ();
export void rec_nonlat_value ();

export void recbup_string_value ();
export void recbup_int_value ();

export void pred_equal ();
export void pred_notequal ();
export void pred_inttostring ();
export void pred_minus ();
export void pred_mul ();
export void pred_div ();
export void pred_power ();
export void pred_uppercase ();
export void pred_notinreservedwordlist ();
export void pred_stringtoint ();
export void pred_dumpaffix ();
export void semipred_endofsentence ();
export void semipred_column ();
export void semipred_row ();

export string eag_stddefs_name_from_nodenr ();
export void init_eag_stddefs ();
#endif /* IncEagStddefs */
