/*
   File: ebs_bst.c
   Defines basic operations for standard types

   CVSID: "$Id: ebs_bst.c,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/

/* global includes */
#include <stdio.h>

/* local includes */
#include <ebs_error.h>
#include <ebs_memalloc.h>
#include <ebs_textstorage.h>
#include <ebs_bst.h>

/* saving standard types */
private int save_check_sum;
public void init_save (FILE *f)
	{ save_check_sum = 0;
	  /* version saving??? */
	};

public void finish_save (FILE *f)
	{ fputc (0xff - save_check_sum, f);
	};

public void save_char (FILE *f, char x)
	{ save_check_sum = (save_check_sum + x) & 0xff;
	  fputc (x, f);
	};

public void save_int (FILE *f, int x)
	{ if ((x < 0) || (x > 254))
	     { save_char (f, 0xff);
	       save_char (f, (char) ((x >> 24) & 0xff));
	       save_char (f, (char) ((x >> 16) & 0xff));
	       save_char (f, (char) ((x >> 8) & 0xff));
	     };
	  save_char (f, (char) (x & 0xff));
	};

public void save_string (FILE *f, string x)
	{ int len = strlen (x);
	  int ix;
	  save_int (f, len);
	  for (ix = 0; ix < len; ix++) save_char (f, x[ix]);
	};

/* loading standard types */
private int load_check_sum;
public void init_load (FILE *f)
	{ load_check_sum = 0;
	  /* version loading & checking??? */
	};

public int load_char (FILE *f, char *x)
	{ int ch = fgetc (f);
	  if (ch == EOF) return (0);
	  load_check_sum = (load_check_sum + ch) & 0xff;
	  *x = (char) ch;
	  return (1);
	};

public int finish_load (FILE *f)
	{ char ch;
	  if (!load_char (f, &ch)) return (0);
	  if (((int) load_check_sum & 0xff) != 0xff) return (0);
	  return (fgetc (f) == EOF);
	};

public int load_int (FILE *f, int *x)
	{ char bb3 = 0;
	  char bb2 = 0;
	  char bb1 = 0;
	  char bb0;
	  if (!load_char (f, &bb0)) return (0);
	  if (((int) bb0 & 0xff) == 0xff)
	     { if (!load_char (f, &bb3)) return (0);
	       if (!load_char (f, &bb2)) return (0);
	       if (!load_char (f, &bb1)) return (0);
	       if (!load_char (f, &bb0)) return (0);
	     };
	  *x = ((bb3 & 0xff) << 24) | ((bb2 & 0xff) << 16) |
	       ((bb1 & 0xff) << 8)  | (bb0 & 0xff);
	  return (1);
	};

#define MAX_SIZE 16384
public int load_string (FILE *f, string *x)
	{ int ix, size;
	  char ch;
	  char buffer[MAX_SIZE];
	  char *ptr;
	  if (!load_int (f, &size)) return (0);
	  if (size < MAX_SIZE - 1) ptr = buffer;
	  else ptr = ckmalloc (size + 1);
	  for (ix = 0; ix < size; ix++)
	     { if (!load_char (f, &ch)) return (0);
	       ptr[ix] = ch;
	     };
	  ptr[size] = '\0';
	  *x = addto_names (ptr);
	  return (1);
	};
