/*
   File: ebs_bst.h
   Defines some global definitions

   CVSID: "$Id: ebs_bst.h,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/
#ifndef IncBst
#define IncBst
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ebs_global.h>

/* Define the string type */
typedef char *string;
#define string_nil ((string) NULL)
#define streq(s1,s2) (!strcmp(s1,s2))
#define strlt(s1,s2) (strcmp(s1,s2) < 0)

#define MAXSTRNAME 1024
#define MAXFNAME 1024

/* Define support for saving */
export void init_save (FILE *f);
export void finish_save (FILE *f);
export void save_char (FILE *f, char x);
export void save_int (FILE *f, int x);
export void save_string (FILE *f, string x);

/* Define support for loading */
export void init_load (FILE *f);
export int finish_load (FILE *f);
export int load_char (FILE *f, char *x);
export int load_int (FILE *f, int *x);
export int load_string (FILE *f, string *x);

#endif /* IncBst */
