/*
   File: ebs_cst.h
   Define composite standard types and operations

   CVSID: "$Id: ebs_cst.h,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/
#ifndef IncEbsCst
#define IncEbsCst

/* local includes */
#include <ebs_global.h>
#include <ebs_bst.h>

/* Introduce list definitions */
typedef struct int_list_rec *int_list;		/* int lists */
typedef struct string_list_rec *string_list;	/* string lists */

/* Introduce nil pointers for lists */
#define int_list_nil ((int_list) NULL)
#define string_list_nil ((string_list) NULL)

/* Introduce structure of int_list */
struct int_list_rec
	{ int size;
	  int room;
	  int *array;
	};

/* Introduce structure of string_list */
struct string_list_rec
	{ int size;
	  int room;
	  string *array;
	};

/* int list manipulation */
export void room_int_list (int_list il, int room);
export int_list new_int_list ();
export void app_int_list (int_list il, int i);
export int_list rdup_int_list (int_list il);
export void rfre_int_list (int_list old);
export int less_int_list (int_list il1, int_list il2);
export int equal_int_list (int_list il1, int_list il2);
export void save_int_list (FILE *f, int_list il);
export int load_int_list (FILE *f, int_list *il);

/* string list manipulation */
export void room_string_list (string_list sl, int room);
export string_list new_string_list ();
export void app_string_list (string_list sl, string s);
export string_list rdup_string_list (string_list sl);
export void rfre_string_list (string_list sl);
export int less_string_list (string_list sl1, string_list sl2);
export int equal_string_list (string_list sl1, string_list sl2);
export void save_string_list (FILE *f, string_list sl);
export int load_string_list (FILE *f, string_list *sl);

/* specific extra operations */
export string concatenate_strings (string_list sl);

#endif /* IncEbsCst */
