/*
   File: ebs_error.h
   Defines routines for diagnostic messages

   CVSID: "$Id: ebs_error.h,v 1.2 2002/11/12 10:58:36 marcs Exp $"
*/
#ifndef IncEbsError
#define IncEbsError
#include <ebs_global.h>

export int debug;
export int verbose;
export int full_verbose;
export void init_error ();

export void panic (char *format, ...);
export void error (char *format, ...);
export void warning (char *format, ...);
export void hint (char *format, ...);
export void wlog (char *format, ...);
export void eprint_log (char *format, ...);

export void internal_error (char *routine);
export void bad_tag (int tag, char *routine);

#endif /* IncEbsError */
