/*
   File: memalloc.c
   Defines a checked malloc and calloc

   CVSID: "$Id: ebs_memalloc.c,v 1.2 2002/11/12 10:58:37 marcs Exp $"
*/

/* include config.h if autoconfigured */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* general includes */
#include <stdio.h>
#include <string.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else
#include <stdlib.h>
#endif

/* local includes */
#include <ebs_global.h>
#include <ebs_error.h>
#include <ebs_memalloc.h>

public void *ckmalloc (int size)
	{ void *new = (void *) malloc ((unsigned) size);
	  if (new) return (new);
	  panic ("could not malloc %d bytes\n", size);
	  return ((void *) NULL);
	};

public void *ckcalloc (int nr, int size)
	{ void *new;
	  if (nr == 0) return ((void *) NULL);
	  new = (void *) calloc ((unsigned) nr, (unsigned) size);
	  if (new) return (new);
	  panic ("could not calloc %d chunks of %d bytes\n", nr, size);
	  return ((void *) NULL);
	};

public void *ckrealloc (void *ptr, int size)
	{ void *new = (void *) realloc ((char *) ptr, (unsigned) size);
	  if (new) return (new);
	  panic ("could not realloc %d bytes\n", size);
	  return ((void *) NULL);
	};

public void *ckrecalloc (void *ptr, int nr, int size)
	{ void *new = (void *) realloc ((char *) ptr, (unsigned) (nr * size));
	  if (new) return (new);
	  panic ("could not realloc %d chunks of %d bytes\n", nr, size);
	  return ((void *) NULL);
	};

public char *newstring (char *src)
	{ char *new = (char *) ckmalloc (strlen (src) + 1);
	  strcpy (new, src);
	  return (new);
	};

