/*
   File: edt_focus.h
   Keeps track of the focus

   CVS ID: "$Id: edt_focus.h,v 1.2 2002/11/12 13:22:55 marcs Exp $"
*/
#ifndef IncEdtFocus
#define IncEdtFocus

/* libebs includes */
#include <ebs_global.h>
#include <ebs_bst.h>
#include <ebs_cst.h>
#include <ebs_value.h>

/* libeag includes */
#include <eag_ds.h>

/* local includes */
#include <edt_edit_ds.h>

typedef struct focus_rec
	{ int begin_x;
	  int begin_y;
	  int end_x;
	  int end_y;
	  etree_node node;
	  struct focus_rec *parent;
	} *focus;
#define focus_nil ((focus) 0)
export focus root_focus;
export focus current_focus;

export void set_focus_from_pos (int x, int y);
export void set_focus_to_father ();
export void reset_root_focus ();
export void init_focus ();

#endif /* IncEdtFocus */
