case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting doc/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#
# $Id: Makefile.SH,v 1.12 2001/06/16 08:10:45 hurtta Exp $
#
#  Makefile for the documentation of the ELM mail system
#
#         (C) Copyright 1988-1992, USENET Community Trust
#
#
# Variables
#	Variables established by Configure
CHMOD		=	$chmod
CP		=	$cp
SED		=       $sed
DEST		=	$bin
ECHO		=	$echo
FORMATTER	=	$roff
FORMATTER_OPTS	=	$roffopts
LIB		=	$lib
LN		=	$ln
MAKE		=	$make
MAN		=	$mansrc
MANEXT		=	$manext
CATMAN		=	$catmansrc
CATMANEXT	=	$catmanext
RM		= 	$rm -f
TBL       	=	$tbl
MANROFF		=	$manroff
MANROFF_OPTS	=	$manroffopts
MV		=	$mv
TEST		=	$test
SUFFIX		=	$suffix
PACKED		=	$packed
PACKER		=	$packer
!GROK!THIS!

case "$install_prefix" in
	/*)
	echo "MANROOT       =  $install_prefix/man" >> Makefile
	;;
	*)
	echo "MANROOT       =  " >> Makefile
	;;
esac

cat >>Makefile <<'!NO!SUBS!'

#	Other variables
SHELL		=	/bin/sh

# List of installed man pages (except for wnemail.1 - handled differently)
MAN_LIST	=	$(MAN)/answer$(MANEXT)		\
			$(MAN)/checkalias$(MANEXT)	\
			$(MAN)/elm$(MANEXT)		\
			$(MAN)/elmalias$(MANEXT)	\
			$(MAN)/fastmail$(MANEXT)	\
			$(MAN)/frm$(MANEXT)		\
			$(MAN)/listalias$(MANEXT)	\
			$(MAN)/messages$(MANEXT)	\
			$(MAN)/newalias$(MANEXT)	\
			$(MAN)/newmail$(MANEXT)	\
			$(MAN)/printmail$(MANEXT)	\
			$(MAN)/readmsg$(MANEXT)		\
			$(MAN)/elmcharset$(MANEXT)	\
			$(MAN)/elmterminal$(MANEXT)	\
			$(MAN)/elmunidata$(MANEXT)

# List of installed catman pages (except for wnemail.1 - handled differently)
CATMAN_LIST	=	$(CATMAN)/answer$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/checkalias$(CATMANEXT)$(SUFFIX)\
			$(CATMAN)/elm$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/elmalias$(CATMANEXT)$(SUFFIX)\
			$(CATMAN)/fastmail$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/frm$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/listalias$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/messages$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/newalias$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/newmail$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/printmail$(CATMANEXT)$(SUFFIX)	\
			$(CATMAN)/readmsg$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmcharset$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmterminal$(CATMANEXT)$(SUFFIX) \
			$(CATMAN)/elmunidata$(CATMANEXT)$(SUFFIX) 

# List of formatted pages for catman
FORMATTED_PAGES_LIST =	catman/answer$(CATMANEXT)$(SUFFIX)	\
			catman/checkalias$(CATMANEXT)$(SUFFIX)\
			catman/elm$(CATMANEXT)$(SUFFIX)	\
			catman/elmalias$(CATMANEXT)$(SUFFIX)\
			catman/fastmail$(CATMANEXT)$(SUFFIX)	\
			catman/frm$(CATMANEXT)$(SUFFIX)	\
			catman/listalias$(CATMANEXT)$(SUFFIX)	\
			catman/messages$(CATMANEXT)$(SUFFIX)	\
			catman/newalias$(CATMANEXT)$(SUFFIX)	\
			catman/newmail$(CATMANEXT)$(SUFFIX)	\
			catman/printmail$(CATMANEXT)$(SUFFIX)	\
			catman/readmsg$(CATMANEXT)$(SUFFIX)     \
			catman/elmcharset$(CATMANEXT)$(SUFFIX)	\
			catman/elmterminal$(CATMANEXT)$(SUFFIX) \
			catman/elmunidata$(CATMANEXT)$(SUFFIX)

# List of files installed in LIB directory
LIB_LIST	=	$(LIB)/elm-help.0	\
			$(LIB)/elm-help.1	\
			$(LIB)/elm-help.2	\
			$(LIB)/elm-help.3	\
			$(LIB)/elmrc-info

# List of formatted guides
FORMATTED_LIST	=	Alias.fmtd	\
			Config.fmtd 	\
			Cover.fmtd	\
			Form.fmtd	\
			Ref.fmtd	\
			Users.fmtd

#			Filter.fmtd	

# Targets
all: 
	@if $(TEST) '$(CATMAN)' != none; then $(MAKE) formatted_pages ;  else true ; fi

#	The following are no-ops
lint:
clean:	

elm.1.subs: elm.1
	$(SED) 's"#LIB#"$(LIB)"g;' < elm.1 > elm.1.subs
answer.1.subs: answer.1
	$(SED) 's"#LIB#"$(LIB)"g;' < answer.1 > answer.1.subs
chkalias.1.subs: chkalias.1
	$(SED) 's"#LIB#"$(LIB)"g;' < chkalias.1 > chkalias.1.subs
elmalias.1.subs: elmalias.1
	$(SED) 's"#LIB#"$(LIB)"g;' < elmalias.1 > elmalias.1.subs
elmcharset.1.subs: elmcharset.1
	$(SED) 's"#LIB#"$(LIB)"g;' < elmcharset.1 > elmcharset.1.subs
elmterminal.1.subs: elmterminal.1
	$(SED) 's"#LIB#"$(LIB)"g;' < elmterminal.1 > elmterminal.1.subs
elmunidata.1.subs: elmunidata.1
	$(SED) 's"#LIB#"$(LIB)"g;' < elmunidata.1 > elmunidata.1.subs
fastmail.1.subs: fastmail.1
	$(SED) 's"#LIB#"$(LIB)"g;' < fastmail.1 > fastmail.1.subs
frm.1.subs: frm.1
	$(SED) 's"#LIB#"$(LIB)"g;' < frm.1 > frm.1.subs
listalias.1.subs: listalias.1
	$(SED) 's"#LIB#"$(LIB)"g;' < listalias.1 > listalias.1.subs
messages.1.subs: messages.1
	$(SED) 's"#LIB#"$(LIB)"g;' < messages.1 > messages.1.subs
newalias.1.subs: newalias.1
	$(SED) 's"#LIB#"$(LIB)"g;' < newalias.1 > newalias.1.subs
printmail.1.subs: printmail.1
	$(SED) 's"#LIB#"$(LIB)"g;' < printmail.1 > printmail.1.subs
readmsg.1.subs: readmsg.1
	$(SED) 's"#LIB#"$(LIB)"g;' < readmsg.1 > readmsg.1.subs
newmail.1.subs: newmail.1
	$(SED) 's"#LIB#"$(LIB)"g;' < newmail.1 > newmail.1.subs




formatted_pages: catman $(FORMATTED_PAGES_LIST)

catman:
	mkdir catman

install: $(LIB_LIST)
	@if $(TEST) '$(MAN)' != none; then $(MAKE) install_man ; else true ;  fi
	@if $(TEST) '$(CATMAN)' != none; then $(MAKE) install_catman ; else true ;  fi

install_man: $(MANROOT) $(MAN) $(MAN_LIST) $(MAN)/wnewmail$(MANEXT)

$(MAN):
	mkdir $(MAN)

install_catman: $(MANROOT) $(CATMAN) $(CATMAN_LIST) $(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX)

$(CATMAN):
	mkdir $(CATMAN)

uninstall:
	$(RM) $(LIB_LIST) 
	@if $(TEST) '$(MAN)' != none; then  \
		$(RM) $(MAN_LIST) $(MAN)/wnewmail$(MANEXT) ; \
	else \
		true ; \
	fi
	@if $(TEST) '$(CATMAN)' != none; then \
		$(RM) $(CATMAN_LIST) $(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX) ; \
	else \
		true ; \
	fi

#	Dependencies and rules for installing man pages and lib files
$(MAN)/answer$(MANEXT):	answer.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/checkalias$(MANEXT):	chkalias.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/elm$(MANEXT):		elm.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/elmalias$(MANEXT):	elmalias.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/elmcharset$(MANEXT):	elmcharset.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/elmterminal$(MANEXT):	elmterminal.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/elmunidata$(MANEXT):	elmunidata.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/fastmail$(MANEXT):	fastmail.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/frm$(MANEXT):		frm.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/listalias$(MANEXT):	listalias.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/messages$(MANEXT):	messages.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/newalias$(MANEXT):	newalias.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/newmail$(MANEXT):	newmail.1.subs
				$(RM) $@
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/printmail$(MANEXT):	printmail.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/readmsg$(MANEXT):	readmsg.1.subs
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(MAN)/wnewmail$(MANEXT):	$(MAN)/newmail$(MANEXT)
				$(RM) $@
				$(LN) $? $@

$(LIB)/elm-help.0:		elm-help.0
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(LIB)/elm-help.1:		elm-help.1
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(LIB)/elm-help.2:		elm-help.2
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(LIB)/elm-help.3:		elm-help.3
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(LIB)/elmrc-info:		elmrc-info
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

#	Dependencies and rules for installing catman
$(CATMAN)/answer$(CATMANEXT)$(SUFFIX):	catman/answer$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/checkalias$(CATMANEXT)$(SUFFIX): catman/checkalias$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/elm$(CATMANEXT)$(SUFFIX): catman/elm$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/elmalias$(CATMANEXT)$(SUFFIX): catman/elmalias$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/elmcharset$(CATMANEXT)$(SUFFIX): catman/elmcharset$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/elmunidata$(CATMANEXT)$(SUFFIX): catman/elmunidata$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@


$(CATMAN)/elmterminal$(CATMANEXT)$(SUFFIX): catman/elmterminal$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/fastmail$(CATMANEXT)$(SUFFIX): catman/fastmail$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/frm$(CATMANEXT)$(SUFFIX): catman/frm$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/listalias$(CATMANEXT)$(SUFFIX): catman/listalias$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/messages$(CATMANEXT)$(SUFFIX): catman/messages$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/newalias$(CATMANEXT)$(SUFFIX): catman/newalias$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/newmail$(CATMANEXT)$(SUFFIX): catman/newmail$(CATMANEXT)$(SUFFIX)
				$(RM) $@
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/printmail$(CATMANEXT)$(SUFFIX): catman/printmail$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/readmsg$(CATMANEXT)$(SUFFIX): catman/readmsg$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@

$(CATMAN)/wnewmail$(CATMANEXT)$(SUFFIX): $(CATMAN)/newmail$(CATMANEXT)$(SUFFIX)
				$(RM) $@
				$(LN) $? $@


#	Dependencies and rules for making catman pages
catman/answer$(CATMANEXT)$(SUFFIX):		answer.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/answer$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/answer$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/checkalias$(CATMANEXT)$(SUFFIX):		chkalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/checkalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/checkalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elm$(CATMANEXT)$(SUFFIX):		elm.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elm$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elm$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmalias$(CATMANEXT)$(SUFFIX):		elmalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmcharset$(CATMANEXT)$(SUFFIX):		elmcharset.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmcharset$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmcharset$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/elmunidata$(CATMANEXT)$(SUFFIX):		elmunidata.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmunidata$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmunidata$(CATMANEXT) ; \
	else \
		true ; \
	fi


catman/elmterminal$(CATMANEXT)$(SUFFIX):	elmterminal.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/elmterminal$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/elmterminal$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/fastmail$(CATMANEXT)$(SUFFIX):		fastmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/fastmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/fastmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/frm$(CATMANEXT)$(SUFFIX):		frm.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/frm$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/frm$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/listalias$(CATMANEXT)$(SUFFIX):		listalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/listalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/listalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/messages$(CATMANEXT)$(SUFFIX):		messages.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/messages$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/messages$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/newalias$(CATMANEXT)$(SUFFIX):		newalias.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/newalias$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/newalias$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/newmail$(CATMANEXT)$(SUFFIX):		newmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/newmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/newmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/printmail$(CATMANEXT)$(SUFFIX):		printmail.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/printmail$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/printmail$(CATMANEXT) ; \
	else \
		true ; \
	fi

catman/readmsg$(CATMANEXT)$(SUFFIX):		readmsg.1.subs
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/readmsg$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/readmsg$(CATMANEXT) ; \
	else \
		true ; \
	fi


#	Dependencies and rules for formatting guides
documentation:	$(FORMATTED_LIST)

Alias.fmtd:	Alias.guide
		$(TBL) $? | $(FORMATTER) $(FORMATTER_OPTS) tmac.n - > $@

Config.fmtd:	Config.guid
		$(TBL) $? | $(FORMATTER) $(FORMATTER_OPTS) tmac.n - > $@

Cover.fmtd:	Elm.cover
		$(FORMATTER) $(FORMATTER_OPTS) tmac.n $? > $@

Filter.fmtd:	Filter.guid
		$(TBL) $? | $(FORMATTER) $(FORMATTER_OPTS) tmac.n - > $@

Form.fmtd:	Form.guide
		$(FORMATTER) $(FORMATTER_OPTS) tmac.n $? > $@

Ref.fmtd:	Ref.guide
		$(FORMATTER) $(FORMATTER_OPTS) tmac.n $? > $@

Users.fmtd:	Users.guide
		$(TBL) $? | $(FORMATTER) $(FORMATTER_OPTS) tmac.n - > $@

!NO!SUBS!

case "$install_prefix" in
	/*)
	cat >>Makefile <<'!NO!SUBS!'
$(MANROOT):
	mkdir $(MANROOT)
!NO!SUBS!
esac

