/* $Id: melib.h,v 1.25 2001/05/05 19:01:45 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.25 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

/* syscall.c */

/* options to the system_call() and start_run() procedure */
#define SY_USER_SHELL	(1<<0)		/* use user shell instead of /bin/sh */
#define SY_ENV_SHELL	(1<<1)		/* put SHELL=[shell] into environ    */
#define SY_ENAB_SIGHUP	(1<<2)		/* pgm to exec can handle signals    */
#define SY_ENAB_SIGINT	(1<<3)		/*  ...and it can handle SIGINT too  */
#define SY_DUMPSTATE	(1<<4)		/* create folder state dump file     */
#define SY_ENV_METAMAIL	(1<<5)		/* put MM_CHARSET to environ         */
#define SY_NOTTY	(1<<6)		/* no tty                    */
#define SY_CLRWAIT	(1<<7)		/* clr and wait 'any key' in end     */
#define SY_RUN_STATE_ENV (1<<8)         /* struct run_state have ext_env     */
#define SY_RUN_STATE_INIT (1<<9)        /* struct run_state have ext_init    */
#define SY_RUN_STATE_OPIPE (1<<10)      /* create {run_state}.pfd 
					 * pipe for output of command        */
#define SY_RUN_STATE_EPIPE (1<<11)      /* create {run_state}.pfd 
					 * pipe for error output of command  */

extern int set_child_signals P_((int));      /* Prototype */
extern int set_child_env P_((int));         /* Prototype */

#ifdef BACKGROUD_PROCESSES
extern void init_backgroud_handling P_((void));
#endif

#ifdef BACKGROUD_PROCESSES      
#ifdef ANSI_C
struct process_list;               /* Needed for prototype */
#endif

extern void sigchld_handler P_((void));
#endif

struct run_state {
  int pid;
  int save_errno;
  int raw;
  int options;
#ifdef BACKGROUD_PROCESSES      
  struct process_list *listptr;
#endif
  char ** ext_env;
  void (*ext_init) P_((struct run_state *rs));
  void * ext_init_data;
  FILE *pfd;
};

typedef void end_handler P_((FILE *fd, char * title, struct run_state *rs,
			     int ret, int exit_stat));

#ifdef BACKGROUD_PROCESSES      
extern int maybe_background P_((struct run_state *rs, int *exit_code,
				FILE *fd, char *title, end_handler *func));
#endif

extern int start_run        P_((struct run_state *rs, int options,
				char * argv[], int infd, int outfd));
extern int run_already_done P_((struct run_state *rs, int *exit_code));
extern int wait_end         P_((struct run_state *rs, int *exit_code));
extern char ** join_argv    P_((char * argv1[], char * argv2[]));

/** Definitions for state operations **/

#ifdef ANSI_C
struct in_state;                              /* Needed for prototype */
struct out_state;                             /* Needed for prototype */
#endif

/* can't be 'char' as argumnet because problems of default
 * promotion rules of arguments -- therefore 'int' is used
 * in functios: state_putc
 *
 * Notice also that we assumen here that char agument (as int)
 * is 'unsigned char'
 *
 *  - K E H
 */


/* state magics */
#define   STATE_in_file      0xFA01
#define   STATE_in_string    0xFA02

#define   STATE_out_file     0xFB01
#define   STATE_out_string   0xFB02
#define   STATE_out_buffer   0xFB03
#define   STATE_out_dir      0xFB04


typedef struct {
    FILE *fpin;
} in_state_file;

typedef struct {
    char *inbuf;
    char *inreadp;
} in_state_string;

typedef struct in_state {
    unsigned short magic;
    
    union {
	in_state_file    file;
	in_state_string  string;
    } u;
} in_state_t;

typedef struct {
    FILE *fpout;
} out_state_file;

typedef struct {
    char *outbuf;
    char *outwritep;
    int outbufsize;
} out_state_string;

typedef struct {
    struct folder_browser * dir;
    WRITE_STATE             write_state_ptr;
} out_state_dir;

typedef struct out_state {
    unsigned short magic;

    unsigned int displaying   : 1;
    unsigned int EOLN_is_CRLF : 1;       /* 0 == \n   is EOLN
					    1 == \r\n is EOLN */

    charset_t    * display_charset;      /* output charset -- vector
					  * of possible sets 
					  */
    char *prefix;

    charset_t       filter;
    struct string * filter_line;       /* input charset */

    union {
	out_state_file          file;
	out_state_string        string;
	struct stringbuffer   * buffer;
	out_state_dir           dir;
    } u;
} out_state_t;

#define state_add_prefix(x) if((x)->prefix)state_puts((x)->prefix,x)

extern void in_state_clear   P_((in_state_t *, int));
extern void in_state_destroy P_((in_state_t *));

extern void set_in_state_buffer P_((char *,in_state_t *));   /* STATE_in_string */
extern void set_in_state_file   P_((FILE *,in_state_t *));   /* STATE_in_file */

extern int  in_state_seekable P_((in_state_t *)); 
extern int  in_state_fseek P_((in_state_t *, long)); /* STATE_in_file */
extern long in_state_ftell P_((in_state_t *));       /* STATE_in_file */
extern FILE * in_state_FILE P_((in_state_t *)); /* STATE_in_file */

extern char *state_gets P_((char *, int, in_state_t *));
extern int   state_getl P_((char *, int, in_state_t *));
extern int   state_getc P_((in_state_t *s));
extern int   state_ungetc P_((int,in_state_t *));

extern void out_state_clear   P_((out_state_t *, int));
extern void out_state_destroy P_((out_state_t *));

/* STATE_out_string */
extern void set_out_state_buffer P_((char *,int,out_state_t *));

/* STATE_out_file */
extern void set_out_state_file   P_((FILE *,out_state_t *));  

/* STATE_out_buffer */
extern void set_out_state_sbuffer   P_((struct stringbuffer *,out_state_t *));  
/* STATE_out_dir */
extern void set_out_state_dir   P_((struct folder_browser *,
				    WRITE_STATE,
				    out_state_t *));  

extern int state_put  P_((char *, int, out_state_t *));

/* convert one line -- *len is assumed to point end of line */
extern void state_convert_EOLN P_((char *buffer, int *len, int buffer_size,
				   out_state_t *st));
				   
extern int state_puts P_((char *, out_state_t *));
extern void state_nlputs P_((char *, out_state_t *));

extern int state_putc P_((int,  out_state_t *));
extern int state_printf P_((out_state_t *s,
			    const char * format, const char *msg, ...));

extern int  out_state_seekable P_((out_state_t *)); 
extern int  out_state_fseek P_((out_state_t *, long)); /* STATE_out_file */
extern long out_state_ftell P_((out_state_t *));       /* STATE_out_file */

/* Returns NULL if no available ... */
extern FILE *out_state_FILE P_((out_state_t *));  

/* STATE_out_string */
extern void out_state_ref_buffer P_((out_state_t *, char **, int*));

#ifdef USE_PGP

/* pgp_decode.c */

extern char pgp_passphrase[PGP_NUM][STRING];
extern int pgp_expires;

extern enum pgp_version have_pgp        P_((enum pgp_version v));
extern enum pgp_version decode_pgp_version P_((char * c));
extern int pgp_void_passphrase          P_((void));
extern int pgp_goodPassphrase           P_((enum pgp_version v));
extern int pgp_decrypt_init		P_((FILE **fpin, FILE **fpout, 
					    int opt, enum pgp_version v,
					    struct run_state *rs));
extern void pgp_decode  		P_((mime_t *,
					    in_state_t *s_in, 
					    out_state_t *s_out,
					    charset_t defcharset));

extern void pgp_SG_decoder P_((mime_t *body, mime_t *sign,
			       in_state_t   *state_in,
			       out_state_t  *state_out,
			       char *micalg, 
			       charset_t defcharset));
extern void pgp_EC_decoder P_((mime_t *init, mime_t *data,
			       in_state_t   *state_in,
			       out_state_t  *state_out,
			       charset_t     defcharset));

#endif

/* parse_util.c */

extern char * parse_dequote P_((CONST char * quoted));
typedef void decoder_hack_func P_((char *ptr, int len));
typedef decoder_hack_func *decoder_hack;
extern char * parse_decomment P_((CONST char *quoted,
				  decoder_hack decode_mime));
extern void null_decoder_hack P_((char *ptr, int len));

typedef void encoder_hack_func P_((char *buf,int size,
				    CONST char *source,int flag));
typedef encoder_hack_func *encoder_hack;
extern void null_encoder_hack P_((char *buf,int size,
				  CONST char *source,int flag));

#define   RHL_MARK_FOLDING      1
#define   RHL_CHECK_HEADER      2

extern int read_header_line             P_((FILE *,char *,int,int));
extern int state_read_hdr_line          P_((in_state_t *,char *, int, int));

typedef int header_filter    P_((header_list_ptr, int));
extern int NULL_header_filter    P_((header_list_ptr, int));

extern void state_write_headers P_((out_state_t      * s,
				    header_list_ptr    hdr,
				    header_filter    * filter,
				    int                flag,
				    int                demime,
				    charset_t          defcharset));

void state_write_header P_((out_state_t * s,
			   header_list_ptr next,
			   int                demime,
			   charset_t          defcharset));
			  
extern header_list_ptr state_read_headers P_((in_state_t *, int));
extern header_list_ptr file_read_headers  P_((FILE *, int));

extern long skip_envelope P_((struct header_rec *hdr, FILE *fp));

/* mime.c */

extern void mime_panic          P_((char *,int,char *, char *));
extern int check_encoding       P_((char *));
extern int charset_ok           P_((char *));

/* mime_decode.c */

extern int rfc822_header_filter     P_((header_list_ptr, int));
extern void rfc822_header_converter P_((header_list_ptr, int, char *, int));
extern void base64_decode	P_((in_state_t *, out_state_t *, int, int));
extern void quoted_printable_decode  P_((in_state_t *, out_state_t *,
					 int, int));
extern void null_decode		P_((mime_t *, in_state_t *, out_state_t *,
				    charset_t));
extern void mime_decode		P_((mime_t *, in_state_t *, out_state_t *,
				    charset_t));
extern void rfc1522_decode P_((char *, int));
extern void rfc1522_decode_structured   P_((int, char *, int));
extern int rfc1522_decode_encoded_atom P_((char *trg,int trg_len,
					   CONST char * src));

extern int is_rfc1522 P_((char *));

extern int set_filter	P_((mime_t *, out_state_t *)); 
extern FILE *arrange_decoded P_((mime_t *ptr,in_state_t  *state_in,
				 out_state_t *state_out,
				 in_state_t *newstate2,
				 char **name));

extern FILE * arrange_binary P_((mime_t *ptr,
				 in_state_t  *state_in,
				 out_state_t *state_out,
				 in_state_t *newstate2,
				 char **name));


typedef void CT_decoder	        P_((mime_t *, in_state_t *, out_state_t *,
				    charset_t));
typedef CT_decoder *CT_decoder_t;
extern CT_decoder_t select_CT_decoder	P_((mime_t *));

extern int mime_notplain P_((mime_t *p));


/* mime_parse.c */

extern mime_t *mime_t_alloc             P_((void));
extern void mime_t_clear                P_((mime_t *mt));
extern void mime_t_copy                 P_((mime_t *, mime_t *));
extern void mime_t_zero                 P_((mime_t *));
extern void mime_destroy		P_((mime_t *));
extern void mime_get_disposition        P_((char *, mime_t *));
extern void mime_get_content		P_((char *, mime_t *));
extern int class_charset                P_((char *charset_value));
extern int mime_get_charset             P_((charset_t *ret, 
					    const char *buffer,
					    charset_t * display_charset));
extern char * mime_parse_content_opts	P_((char *));
extern void mime_warnings		P_((struct header_rec *));
extern mime_t *rfc822_parse		P_((FILE *fp, int len, 
					    charset_t defcharset));
extern mime_t * multipart_parse         P_((FILE *fp, int length, 
					    char *boundary, int opts,
					    charset_t defcharset));
extern void mime_get_boundary           P_((char *, char *, int));

extern void attach_parse		P_((struct header_rec *,FILE *));
extern mime_t *mime_read_header         P_((FILE *fp, int opts, 
					    charset_t defcharset));
extern mime_t *parse_mime_headers       P_((header_list_ptr headers,
					    long part_offset,
					    long body_offset,
					    int opts,
					    charset_t hdr_charset));

extern void parse_mime_headers1 P_((mime_t *ptr,
				    header_list_ptr headers,
				    long part_offset,
				    long body_offset,
				    int opts,
				    charset_t hdr_charset));

extern int is_text_type P_((char *primary_type, char *subtype,int enc));
extern int is_pre_mime_content_type P_((mime_t *ptr, char *content_type));
extern int mime_check_type P_((char *str));


/* --------------- */

/* pgp_decode uses this .... */
extern void PressAnyKeyToContinue P_((void));

/* mime_decode.c uses this ... */
extern void getkey P_((int send));
extern void encode P_((char *line));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
