static char rcsid[] = "$Id: dynarray.c,v 1.4 2000/10/10 15:16:23 hurtta Exp $";

/*****************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *
 * Initially written by: Michael Elkins <elkins@aero.org>, 1995/06/01
 *****************************************************************************/

/** routines for handling of dynamic arrays **/

#include "headers.h"

void ** DynamicArray (p, record_size, max, n)
     void **p;
     int record_size;
     int *max;
     int n;
{
    int newmax, j;
    void **c;

    newmax = *max + n;
    
    if (!p)
	c = safe_malloc(record_size * (n+1));
    else
	c = safe_realloc(p, record_size * (newmax+1));
    
    if (!c)
	return(0);
    
    /* We reserver in above (newmax+1) elements --
     * element c[newmax] must be always NULL so DestroyDynamicArray
     * works.
     */
    for (j = *max ; j <= newmax ; j++)
	c[j] = 0;
    
    *max = newmax;
    
    return(c);
}

void DestroyDynamicArray (p)
     void **p;
{
    void **b;
    
    if (!p)
	return;
    b = p;
    while (*b)
	free(*b++);
    free(p);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
