static char rcsid[] = "@(#)$Id: mail_gets.c,v 1.6 2001/04/28 07:09:03 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1992 USENET Community Trust
 *****************************************************************************/

/** get a line from the mail file, but be tolerant of nulls

  The length of the line is returned

**/

#include "headers.h"

int mail_gets(buffer, size, mailfile)
     char *buffer;
     int size;
     FILE *mailfile;
{
    int line_bytes = 0, ch;
    char *c = buffer;

    size--; /* allow room for zero terminator on end, just in case */

    while (!feof(mailfile) && !ferror(mailfile) && line_bytes < size) {
	ch = getc(mailfile); /* Macro, faster than  fgetc() ! */

	if (ch == EOF) {

	    if (line_bytes > 0 && *c != '\n') {
	        ++line_bytes;
	    	*c++ = '\n';
	    }
	    break;
	}

	*c++ = ch;
	++line_bytes;

	if (ch == '\n')
	    break;
    }
    *c = 0;	/* mail_gets is also used on places where zero
		 * terminated strings are assumed 
		 */
    return line_bytes;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
