static char rcsid[] = "@(#)$Id: rc_handle.c,v 1.6 2001/06/06 18:09:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ****************************************************************************
 *
 * Some of code comes from ../src/read_rc.c and ../src/save_opts.c. These
 * are following copyright:
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "headers.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "shared_imp.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"config");

int valid_rc_type(T)
     struct rc_type *T;
{
    int i;

    if (&rc_DT_SYN == T ||
	&rc_DT_STR == T ||
	&rc_DT_NUM == T ||
	&rc_DT_BOL == T ||
	&rc_DT_CHR == T ||
	&rc_DT_WEE == T ||
	&rc_DT_ALT == T ||
	&rc_DT_SRT == T ||
	&rc_DT_MLT == T ||
	&rc_DT_ASR == T ||
	&rc_DT_PRM == T ||
	&rc_DT_FUNC == T ||
	&rc_DT_LONG  == T 
#ifdef USE_PGP
	|| &rc_DT_PGPVER  == T 
#endif
	) {
	return 1;
    }

#ifdef USE_DLOPEN
    for (i = 0; i < shared_RC_type_count; i++)
	if (shared_RC_types[i].T == T)
	    return 1;
#endif

  	DPRINT(Debug,1,(&Debug, 			
			"valid_rc_type=0: type=%p (magic)\n",
			T));	      
    
    return 0;
}

#ifdef ANSI_C
static rc_parse_line dt_SYN_parse_line;
#endif
static int dt_SYN_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
{     
    if (negate) {
	char buffer[SLEN];
	buffer[0] = '!';
	strfcpy(buffer+1, r->val.str, sizeof buffer -1);
	
	if ( do_set(lcl,buffer,value,filename))
            return 1;

    } else { 
	if ( do_set(lcl, r->val.str, value, filename))
	    return 1;
    }

    return 0;
}

#ifdef ANSI_C
static rc_parse_cline BAD_parse_cline;
#endif
static int BAD_parse_cline(r,lcl,value,lineno,filename)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
{     
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadContinuationInElmrc,
		      "Key \"%s\" does not accept continuation lines in line %d in \"%s\" file"),
	      r->name,lineno,filename);
    return 0;    
}

#if ANSI_C
static rc_print_value NO_print_value;
#endif
static void NO_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    /* Empty */
}

#if ANSI_C
static rc_get_value NO_get_value;
#endif
static char * NO_get_value(r)
     struct rc_save_info_rec *r;
{
    return "*bad*";
}

struct rc_type rc_DT_SYN = { dt_SYN_parse_line, BAD_parse_cline,
			     NO_print_value, NO_get_value };

#ifdef ANSI_C
static rc_parse_line dt_STR_parse_line;
#endif
static int dt_STR_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    if (strlen(value) >= r->size_val) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLongValueInElmrc,
			  "Value of \"%s\" in line %d in \"%s\" file is too long"),
		  r->name,lineno,filename);
	return 0;
    }
	
    strfcpy(r->val.str, value, r->size_val);

    if (r->flags & FL_NOSPC) {
	char *s;
	for (s = r->val.str; *s; ++s)
	    if (*s == '_') *s=' ';
    }
    return 1;
}

/* Returns pointer to static area */
#if ANSI_C
static rc_get_value dt_STR_get_value;
#endif
static char * dt_STR_get_value(r)
     struct rc_save_info_rec *r;
{    
    if (r->flags & FL_NOSPC) {

	static char buffer[SLEN];

	char *t, *s;
	for (t = r->val.str, s = buffer; 
	     *t && s - buffer < sizeof buffer -1; 
	     ++t, ++s)
	    if ((*s = *t) == ' ') 
		*s='_';
	*s = '\0';

	return buffer;
    } else
	return r->val.str;
}


#if ANSI_C
static rc_print_value dt_STR_print_value;
#endif
static void dt_STR_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    char * s = dt_STR_get_value(r);
    
    if (comment)
	fprintf(F, "### ");
    fprintf(F, "%s = %s\n", r->name, s);
    
    DPRINT(Debug,9,(&Debug, 
		    " option \"%s\", value=\"%s\"\n",
		    r->name,s ));
}


struct rc_type rc_DT_STR = { dt_STR_parse_line, BAD_parse_cline,
			     dt_STR_print_value, dt_STR_get_value };

#ifdef ANSI_C
static rc_parse_line dt_NUM_parse_line;
#endif
static int dt_NUM_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    char *p;
    long l = strtol(value,&p,10);

    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    if (r->e_ptr && (e_val || *p || l < 0)) {
	*(r->val.num) = e_val;
    } else 
	*(r->val.num) = l;

    return 1;
}

#if ANSI_C
static rc_print_value dt_NUM_print_value;
#endif
static void dt_NUM_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    if (comment)
	fprintf(F, "### ");

    if (r->e_ptr && 
	*r->val.num >= 0 && 
	*r->val.num < r->e_ptr->nlen) {

	char * s = r->e_ptr->list[*r->val.num];
	fprintf(F, "%s = %s\n", r->name, s);

       	DPRINT(Debug,9,(&Debug, 			
			" option \"%s\", value=\"%s\"\n",
			r->name,s ));

    } else {
	fprintf(F, "%s = %d\n", r->name, 
		*r->val.num);
    
	DPRINT(Debug,9,(&Debug, 
			" option \"%s\", value=%d\n",
			r->name,*r->val.num ));
    }
}

/* Returns static pointer */
#if ANSI_C
static rc_get_value dt_NUM_get_value;
#endif
static char * dt_NUM_get_value(r)
     struct rc_save_info_rec *r;
{
    static char * buffer = NULL;
    
    if (r->e_ptr && 
	*r->val.num >= 0 && 
	*r->val.num < r->e_ptr->nlen) 
	return r->e_ptr->list[*r->val.num];

    if (buffer)
	free(buffer);
    buffer = elm_message(FRM("%d"), *r->val.num);

    return buffer;
}


struct rc_type rc_DT_NUM = { dt_NUM_parse_line, BAD_parse_cline,
			     dt_NUM_print_value, dt_NUM_get_value };

#ifdef ANSI_C
static rc_parse_line dt_BOL_parse_line;
#endif
static int dt_BOL_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	if (r->flags & FL_OR)
	    *(r->val.bol) |= !is_it_on(value);
	else if (r->flags & FL_AND)
	    *(r->val.bol) &= !is_it_on(value);
	else
	    *(r->val.bol) = !is_it_on(value);    
    } else {
	if (r->flags & FL_OR)
	    *(r->val.bol) |= is_it_on(value);
	else if (r->flags & FL_AND)
	    *(r->val.bol) &= is_it_on(value);
	else
	    *(r->val.bol) = is_it_on(value);    
    }
    return 1;
}

#if ANSI_C
static rc_print_value dt_BOL_print_value;
#endif
static void dt_BOL_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    char * s;
    if (comment)
	fprintf(F, "### ");

    s = *r->val.bol ? "ON" : "OFF";

    fprintf(F, "%s = %s\n", r->name, s);
    
    DPRINT(Debug,9,(&Debug, 
		    " option \"%s\", value=%s\n",
		    r->name,s ));
}

#if ANSI_C
static rc_get_value dt_BOL_get_value;
#endif
static char * dt_BOL_get_value(r)
     struct rc_save_info_rec *r;
{
    return *r->val.bol ? "ON" : "OFF";
}

struct rc_type rc_DT_BOL = { dt_BOL_parse_line, BAD_parse_cline,
			     dt_BOL_print_value, dt_BOL_get_value };

#ifdef ANSI_C
static rc_parse_line dt_CHR_parse_line;
#endif
static int dt_CHR_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    *(r->val.chr) = value[0];
    return 1;
}

#if ANSI_C
static rc_print_value dt_CHR_print_value;
#endif
static void dt_CHR_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    char * s;
    if (comment)
	fprintf(F, "### ");

    fprintf(F, "%s = %c\n", r->name, *r->val.chr);

    DPRINT(Debug,9,(&Debug, 		    
		    " option \"%s\", value=%c\n",
		    r->name, *r->val.chr));
}

#if ANSI_C
static rc_get_value dt_CHR_get_value;
#endif
static char * dt_CHR_get_value(r)
     struct rc_save_info_rec *r;
{
    static char buffer[2];

    buffer[0] = *r->val.chr;
    buffer[1] = '\0';

    return buffer;
}

struct rc_type rc_DT_CHR = { dt_CHR_parse_line, BAD_parse_cline,
			     dt_CHR_print_value, dt_CHR_get_value };

#ifdef ANSI_C
static rc_parse_line dt_WEE_parse_line;
#endif
static int dt_WEE_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }
    
    weedout(value);
    return 1;
}

#ifdef ANSI_C
static rc_parse_cline dt_WEE_parse_cline;
#endif
static int dt_WEE_parse_cline(r,lcl,value,lineno,filename)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
{
    weedout(value);
    return 1;
}

#if ANSI_C
static rc_print_value dt_WEE_print_value;
#endif
static void dt_WEE_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    int len, i;
    
    if (comment)
	fprintf(F, "### ");
    fprintf(F, "%s =", r->name);
    len = strlen(r->name) + 6;
		    
    i = 0;
    while (i < weedcount
	   && istrcmp(weedlist[i], "*end-of-defaults*"))
	i++;
    while (i < weedcount
	   && !istrcmp(weedlist[i], "*end-of-defaults*"))
	i++;
    if (i == 1) {
	/* end-of-defaults in the first position means
	** that there are no defaults, i.e.
	** a clear-weed-list has been done.
	*/
	fprintf(F, " \"*clear-weed-list*\"");
	len += 20;
    }
		    
    while (i <= weedcount) {
	char *w;
			
	w = (i < weedcount) ? weedlist[i]
	    : "*end-of-user-headers*";
	if (strlen(w) + len > 72) {
	    if (!comment)
		fprintf(F, "\n\t");
	    else
		fprintf(F, "\n###\t");
	    len = 8;
	}
	else {
	    fprintf(F, " ");
	    ++len;
	}
	fprintf(F, "\"%s\"", w);
	len += strlen(w) + 3;
	i++;
    }
    fprintf(F, "\n");
}

struct rc_type rc_DT_WEE = {  dt_WEE_parse_line, dt_WEE_parse_cline,
			      dt_WEE_print_value, NO_get_value };

#ifdef ANSI_C
static rc_parse_line dt_ALT_parse_line;
#endif
static int dt_ALT_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    alternatives(value);
    return 1;
}

#ifdef ANSI_C
static rc_parse_cline dt_ALT_parse_cline;
#endif
static int dt_ALT_parse_cline(r,lcl,value,lineno,filename)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
{
    alternatives(value);
    return 1;
}

#if ANSI_C
static rc_print_value dt_ALT_print_value;
#endif
static void dt_ALT_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    struct addr_rec *alts = *(r ->val.alts);
    int len=0;
    
    if (comment)
	fprintf(F, "### ");
    fprintf(F, "%s =", r->name);
    len = strlen(r->name) + 6;
    for ( ;alts; alts = alts->next) {
	if (strlen(alts->address) + len > 72) {
	    if (!comment)
		fprintf(F, "\n\t");
	    else
		fprintf(F, "\n###\t");
	    len = 8;
	}
	else {
	    fprintf(F, " ");
	    ++len;
	}
	fprintf(F, "%s", alts->address);
	len += strlen(alts->address);
    }
    fprintf(F,"\n");


}

struct rc_type rc_DT_ALT = { dt_ALT_parse_line, dt_ALT_parse_cline,
			     dt_ALT_print_value, NO_get_value };


static struct { 
    char *kw; 
    int sv; 
} SRT_srtval[]={
    {"sent", SENT_DATE},
    {"thread", THREAD},
    {"received", RECEIVED_DATE},
    {"recieved", RECEIVED_DATE},
    {"rec", RECEIVED_DATE},
    {"from", SENDER},
    {"sender", SENDER},
    {"size", SIZE},
    {"lines", SIZE},
    {"subject", SUBJECT},
    {"mailbox", MAILBOX_ORDER},
    {"folder", MAILBOX_ORDER},
    {"status", STATUS},
    {NULL, 0} 
};

#ifdef ANSI_C
static rc_parse_line dt_SRT_parse_line;
#endif
static int dt_SRT_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    char buffer[SLEN];
    char *s = buffer;
    int f,y;
    
    f = 1;
    strfcpy(buffer, shift_lower(value), sizeof buffer);

    if (strncmp(s, "rev-", 4) == 0 ||
	strncmp(s, "reverse-", 8) == 0) {
	f = -f;
	s = index(s, '-') + 1;
    }
    
    if (negate)
	f = -f;

    for (y= 0; SRT_srtval[y].kw; y++) {
	if (equal(s, SRT_srtval[y].kw))
	    break;
    }
    if (SRT_srtval[y].kw) {
	*(r->val.sort) = f > 0 ? SRT_srtval[y].sv : -SRT_srtval[y].sv;
    } else {
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmBadSortKeyInElmrc,
			  "I can't understand sort key \"%s\" in line %d in \"%s\" file"),
		  value, lineno, filename);
	return 0;
    }
    return 1;
}

#if ANSI_C
static rc_get_value dt_SRT_get_value;
#endif
static char * dt_SRT_get_value(r)
     struct rc_save_info_rec *r;
{
    int y;

    for (y= 0; SRT_srtval[y].kw; y++) {
	if (SRT_srtval[y].sv == *(r->val.sort)) 
	    return SRT_srtval[y].kw;
	else if (SRT_srtval[y].sv == - *(r->val.sort)) {

	    static char * buffer = NULL;
	    
	    buffer = strmcpy(buffer,"reverse-");
	    buffer = strmcat(buffer, SRT_srtval[y].kw);

	    return buffer;
	}
    }
    return "*bad*";
}

#if ANSI_C
static rc_print_value dt_SRT_print_value;
#endif
static void dt_SRT_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    if (comment)
	fprintf(F, "### ");

    fprintf(F, "%s = %s\n", r->name, 
	    dt_SRT_get_value(r));
}

struct rc_type rc_DT_SRT = { dt_SRT_parse_line, BAD_parse_cline,
			     dt_SRT_print_value, dt_SRT_get_value };

#ifdef ANSI_C
static rc_parse_line dt_MLT_parse_line;
#endif
static int dt_MLT_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    int ok = 1;
    char **s;
    
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }
    
    for (s = r->val.weed; *s; ++s) {
	if (!do_set(lcl, *s, value, filename))
	    ok = 0;
    }

    return ok;
}

struct rc_type rc_DT_MLT = { dt_MLT_parse_line, BAD_parse_cline,
			     NO_print_value, NO_get_value };

static struct { 
    char *kw; 
    int sv; 
} ASR_srtval[]={
    {"alias", ALIAS_SORT},
    {"name", NAME_SORT},
    {"text", TEXT_SORT},
    {NULL, 0} 
};

#ifdef ANSI_C
static rc_parse_line dt_ASR_parse_line;
#endif
static int dt_ASR_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    char buffer[SLEN];
    char *s = buffer;
    int f, y;

    f = 1;
    strfcpy(buffer, shift_lower(value), sizeof buffer);

    if (strncmp(s, "rev-", 4) == 0 ||
	strncmp(s, "reverse-", 8) == 0) {
	f = -f;
	s = index(s, '-') + 1;
    }

    if (negate)
	f = -f;

    for (y= 0; ASR_srtval[y].kw; y++) {
	if (equal(s, ASR_srtval[y].kw))
	    break;
    }
    if (ASR_srtval[y].kw) {
	*(r->val.sort)  = f > 0 ? ASR_srtval[y].sv : -ASR_srtval[y].sv;
    } else {
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmBadAliasSortInElmrc,
			  "I can't understand alias sort key \"%s\" in line %d in \"%s\" file"),
		  value, lineno,filename);
	return 0;
    }
    
    return 1;
}

#if ANSI_C
static rc_get_value dt_ASR_get_value;
#endif
static char * dt_ASR_get_value(r)
     struct rc_save_info_rec *r;
{
    int y;

    for (y= 0; ASR_srtval[y].kw; y++) {
	if (ASR_srtval[y].sv == *(r->val.sort)) 
	    return ASR_srtval[y].kw;
	else if (ASR_srtval[y].sv == - *(r->val.sort)) {

	    static char * buffer = NULL;
	    
	    buffer = strmcpy(buffer,"reverse-");
	    buffer = strmcat(buffer, ASR_srtval[y].kw);

	    return buffer;
	}
    }
    return "*bad*";
}


#if ANSI_C
static rc_print_value dt_ASR_print_value;
#endif
static void dt_ASR_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    if (comment)
	fprintf(F, "### ");
    
    fprintf(F, "%s = %s\n", r->name, dt_ASR_get_value(r));
}

struct rc_type rc_DT_ASR = { dt_ASR_parse_line, BAD_parse_cline,
			     dt_ASR_print_value, dt_ASR_get_value };

#ifdef ANSI_C
static rc_parse_line dt_PRM_parse_line;
#endif
static int dt_PRM_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    char *s = value;
    int m = 0;
    char *modecharp = "rwxrwxrwx";
    int modebit = 0400;
    char c;

    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    while ((c = *s++) != '\0') {
	if (c == *modecharp)
	    m |= modebit;
	else if (c != '-') {

	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmBadModeInElmrc,
			      "I can't understand file permissions \"%s\" in line %d in \"%s\" file"),
		      value, lineno,filename);
	    return 0;
	}
	modecharp++;
	modebit >>= 1;
    }
    if (*modecharp != '\0') {	
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadModeInElmrc,
			  "I can't understand file permissions \"%s\" in line %d in \"%s\" file"),
		  value, lineno,filename);
	return 0;
    }
    *(r->val.num) = m;

    return 1;
}

#if ANSI_C
static rc_print_value dt_PRM_print_value;
#endif
static void dt_PRM_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    char *s = mode_to_str(*(r->val.num));

    if (comment)
	fprintf(F, "### ");
    
    fprintf(F, "%s = %s\n", r->name, s);
}

#if ANSI_C
static rc_get_value dt_PRM_get_value;
#endif
static char * dt_PRM_get_value(r)
     struct rc_save_info_rec *r;
{
    return mode_to_str(*(r->val.num));
}

struct rc_type rc_DT_PRM = { dt_PRM_parse_line, BAD_parse_cline,
			     dt_PRM_print_value, dt_PRM_get_value };

#ifdef ANSI_C
static rc_parse_line dt_FUNC_parse_line;
#endif
static int dt_FUNC_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{     
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    if (!r->func_val(&value,1)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadValueInElmrc,
			  "Value of \"%s\" in line %d in \"%s\" file is bad"),
		  value,lineno,filename);
	return 0;
    }
    
    return 1;
}

#if ANSI_C
static rc_print_value dt_FUNC_print_value;
#endif
static void dt_FUNC_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    char *s = NULL;

    r->func_val(&s,0);
    if (s) {
	if (comment)
	    fprintf(F, "### ");
	
	fprintf(F, "%s = %s\n", r->name, s);
    }
}

#if ANSI_C
static rc_get_value dt_FUNC_get_value;
#endif
static char * dt_FUNC_get_value(r)
     struct rc_save_info_rec *r;
{
    char *s = NULL;

    r->func_val(&s,0);

    return s;
}


struct rc_type rc_DT_FUNC = { dt_FUNC_parse_line, BAD_parse_cline,
			      dt_FUNC_print_value, dt_FUNC_get_value };

#ifdef ANSI_C
static rc_parse_line dt_LONG_parse_line;
#endif
static int dt_LONG_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{   
    char *p;
    long l;
    
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }
    
    l = strtol(value,&p,10);
    *(r->val.l_num) = l;

    return 1;
}

#if ANSI_C
static rc_print_value dt_LONG_print_value;
#endif
static void dt_LONG_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    if (comment)
	fprintf(F, "### ");
    
    fprintf(F, "%s = %ld\n", r->name, *r->val.l_num);
}

#if ANSI_C
static rc_get_value dt_LONG_get_value;
#endif
static char * dt_LONG_get_value(r)
     struct rc_save_info_rec *r;
{
    static char * buffer = NULL;
    
    if (buffer)
	free(buffer);
    buffer = elm_message(FRM("%ld"), *r->val.l_num);

    return buffer;
}


struct rc_type rc_DT_LONG = { dt_LONG_parse_line, BAD_parse_cline,
			      dt_LONG_print_value, dt_LONG_get_value };

#ifdef USE_PGP

#ifdef ANSI_C
static rc_parse_line dt_PGPVER_parse_line;
#endif
static int dt_PGPVER_parse_line(r,lcl,value,lineno,filename, e_val, negate)
     struct rc_save_info_rec *r;
     int lcl;
     char *value; 
     int lineno; 
     char *filename;
     int e_val;
     int negate;
{   
    if (negate) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadNegate,
			  "!%s is not supported in line %d in \"%s\" file"),
		  r->name,lineno,filename);
	return 0;
    }

    * (r->val.pgpver) = (enum pgp_version) e_val;

    return 1;
}

#if ANSI_C
static rc_print_value dt_PGPVER_print_value;
#endif
static void dt_PGPVER_print_value(F,r,comment)
     FILE *F;
     struct rc_save_info_rec *r;
     int comment;
{
    if (r->e_ptr && 
	*(r->val.pgpver) >= 0 &&
	*(r->val.pgpver) <= r->e_ptr->nlen) {
	char * s = r->e_ptr->list[*(r->val.pgpver)];
	             
	if (comment)
	    fprintf(F, "### ");

	fprintf(F, "%s = %s\n", r->name, s);
    }
}

#if ANSI_C
static rc_get_value dt_PGPVER_get_value;
#endif
static char * dt_PGPVER_get_value(r)
     struct rc_save_info_rec *r;
{
    if (r->e_ptr && 
	*(r->val.pgpver) >= 0 &&
	*(r->val.pgpver) <= r->e_ptr->nlen) {
	return r->e_ptr->list[*(r->val.pgpver)];
    }
    return "*bad*";
}

struct rc_type rc_DT_PGPVER = { dt_PGPVER_parse_line, BAD_parse_cline,
				dt_PGPVER_print_value, dt_PGPVER_get_value };
#endif


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

