static char rcsid[] = "@(#)$Id: read_rc.c,v 1.83 2001/06/16 13:33:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.83 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************
 *
 * Most of code copied from ../src/read_rc.c. It have following copyright:
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#define SAVE_OPTS
#include "headers.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_elm.h"
#include "s_me.h"
#include <errno.h>

#include "patchlevel.h"

#ifndef ANSI_C
extern int errno;
#endif

DEBUG_VAR(Debug,__FILE__,"config");

#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

#ifndef I_UNISTD 
char *getlogin();
unsigned short getgid(), getuid(); 
struct passwd *getpwuid();
#endif

# ifdef DOUNAME
#  include <sys/utsname.h>
# endif

#define ASSIGNMENT      0
#define WEEDOUT		1
#define ALTERNATIVES	2

#define SYSTEM_RC	0
#define LOCAL_RC	1

static int lineno = 0;
static int errors = 0;

static void do_expand_env P_((char *, char *, char *, unsigned));
static void do_rc P_((FILE *file,int lcl, char *filaname));

#ifndef ok_rc_char
#define ok_rc_char(c)   (isalnum(c) || c == '-' || c == '_')
#endif

char system_text_file[SLEN]     = SYSTEM_TEXT_FILE;
char system_data_file[SLEN]     = SYSTEM_DATA_FILE;
char system_rc_file[SLEN]       = SYSTEM_RC_FILE;
char system_mime_types[SLEN]    = SYSTEM_MIME_TYPES;
char system_terminal_info[SLEN] = SYSTEM_TERMINAL_INFO;
char system_mail_services[SLEN] = SYSTEM_MAIL_SERVICES;
char hostdomfile[SLEN]          = HOSTDOMFILE;
char system_mime_charsets[SLEN] = SYSTEM_MIME_CHARSETS;
char map_txtdir[SLEN] = {0};     /* init_defaults */
char raw_map_txtdir[SLEN] =      "{lib}/elm.map.txt";
char map_bindir[SLEN] = {0};     /* init_defaults */
char raw_map_bindir[SLEN] =      "{lib}/elm.map.bin";
char unidata_path[SLEN] = {0};  /* init_defaults */
char raw_unidata_path[SLEN] =  "unidata.bin";     /* init_defaults */



char user_rc_file[SLEN]   = ELMRCFILE;              /* user_init fixes */
char user_text_file[SLEN] = USER_ALIAS_TEXT;        /* user_init fixes */
char user_data_file[SLEN] = USER_ALIAS_DATA;        /* user_init fixes */
char user_mime_types[SLEN] = USER_MIME_TYPES;       /* user_init fixes */
char user_mailheaders[SLEN] = MAILHEADERS;          /* user_init fixes */
char user_mime_charsets[SLEN] = USER_MIME_CHARSETS; /* user_init fixes */
char user_terminal_info[SLEN] = USER_TERMINAL_INFO; /* user_init fixes */
char user_mail_services[SLEN] = USER_MAIL_SERVICES; /* user_init fixes */

char defaultfile[SLEN] = {0};	                /* name of default folder */
char raw_defaultfile[SLEN] = "$MAIL";           /* init_defaults fixes */
char calendar_file[SLEN] = {0};	/* name of file for clndr  */
char raw_calendar_file[SLEN] = {0};	/* unexpanded name of file for clndr  */
int clear_pages = 0;		/* flag: act like "page" (more -c)? */
int title_messages = 1;		/* flag: title message display?     */

nl_catd  elm_msg_cat = 0;	/* message catalog	    */

char username[SLEN] = {0};	/* return address name!    */
char home[SLEN] = {0};		/* home directory of user  */
int userid;			/* uid for current user	      */
int groupid;			/* groupid for current user   */

int mailgroupid;		/* groupid for current user   */
int have_saved_ids = 0;         /* sysconf _SC_SAVED_IDS      */

/* ------------- Variables in elmrc ------------------------------- */

int  add_irt_phrase = 0;        /* In-reply-to: Add phare to in-reply-to ?
			           True = Do not follow RFC 2822 
				*/
int allow_charset_switching=0;   /* flag: allow changing charset of */
				 /* terminal if terminal supports   */
int alias_sortby = NAME_SORT;	           /* how to sort aliases...   */
char alternative_editor[SLEN] = "EDITOR";  /* alternative editor...    */
struct addr_rec *alternative_addresses;	/* how else do we get mail? */
int always_del = 0;		/* flag: always delete marked msgs? */
int always_keep = 1;		/* flag: always keep unread msgs?   */
int always_store = 0;		/* flag: always store read msgs?    */
int arrow_cursor = 0;		/* flag: use "->" cursor regardless?*/
int question_me = 1;		/* flag: ask questions as we leave? */
int prompt_for_cc = 1;		/* flag: ask user for "cc:" value?  */
#ifdef USE_PGP
int pgp_askpgpsig=0; /* Should pgp ask userid to sign messages with? */
int pgp_sign_type=0;   /* 0 = application/pgp
			  1 = text/plain
			  2 = text/x-pgp
			  */
enum pgp_version send_pgp_version = pgp_none; /* preferred pgp version*/
#endif
char attribution[SLEN] = {0};	/* attribution string for replies   */
int auto_copy = 0;		/* flag: automatically copy source? */
#ifdef BACKGROUD_PROCESSES       
int background_wait_time = 2;    /* If > 0 background mailer after  */
				 /* this number of seconds          */
#endif
/* int bounceback = 0;	*/	/* flag: bounce copy off remote?    */
int browser_wildcards = 1;      /* flag: do wildcard match?         */
int builtin_lines= -3;		/* int: if < 0 use builtin if message*/
                                /* shorter than LINES+builtin_lines */
                                /* else use pager. If > 0 use builtin*/
                                /* if message has fewer than # of lines*/
char raw_text_charset[SLEN] = "DISPLAY";    /* name of character set     */
charset_t text_charset      = NULL;   	    /* pointer of character set  */
char raw_default_nomime_charset[SLEN] = "SYSTEM"; /* name of character set  */
charset_t default_nomime_charset = NULL;      /* pointer to character set   */

char config_options[SLEN] = {0};/* which options are in o)ptions    */
int confirm_append = 0;		/* flag: confirm append to folder?  */
int confirm_create = 0;		/* flag: confirm create new folder? */
int confirm_files = 0;		/* flag: confirm files for append?  */
int confirm_folders = 0;	/* flag: confirm folders for create?*/
int convert_comment = 1;        /* flag: convert comment to fullname ?  */
int auto_copy_sent = 1;		/* flag: automatically copy sent mail? */
char display_locale[SLEN] = "NONE";  /* LC_CTYPE locale (character set) */

charset_t wanted_display_charset = NULL;
char raw_display_charset[SLEN]   = "SYSTEM";	
                               /* the wanted display charset set */
#ifdef USE_DSN
int DSN_success = 0;            /* flag: Ask successfull DSNes      */
#endif
char e_editor[SLEN] = {0};	/* "~e" editor...                   */
char editor[SLEN] = {0};	/* editor for outgoing mail*/
int env_from_source = 0;        /* 0 == forward-from,
                                   1 == from,
                                   2 == return-path
				*/
char raw_editor[SLEN] = {0};	/* unexpanded editor for outgoing mail*/
char escape_char = TILDE_ESCAPE;/* '~' or something else..          */
int force_name = 0;		/* flag: save by name forced?	    */
int allow_forms = NO;		/* flag: are AT&T Mail forms okay?  */
char full_username[SLEN] = {0};	/* Full username - gecos            */
int phrase_display_mode = 0;    /* 0 == plain, 1 = quoted */
char hostdomain[SLEN] = {0};	/* name of domain we're in          */
char hostfullname[SLEN] = {0};	/* name of FQDN we're in            */
char hostname[SLEN] = {0};	/* name of machine we're on         */
#ifdef DISP_HOST
int  menu_display_host = TRUE;  /* flag: Display host on mailbox menu* */
#else
int  menu_display_host = FALSE;  /* flag: Display host on mailbox menu? */
#endif
int keep_empty_files = 0;	/* flag: leave empty folder files?  */
#ifdef USE_PGP
int pgp_keeppassfor = 300;      /* 5 minutes                        */
#endif
/* int hp_terminal = 0;	*/	/* flag: are we on HP term?	    */
int local_fast_lookup = 0;      /* flag: directory listing not needed 
				   for lookup */
char raw_local_fs_charset[SLEN] = "SYSTEM"; /* filesystem charset */
charset_t local_fs_charset      = NULL;     /* filesystem charset */

char local_signature[SLEN] = {0};   /* local msg signature file     */
char raw_local_signature[SLEN] = {0};	/* unexpanded local msg     */
                                /*               signature file     */
#ifdef SYSCALL_LOCKING
int lockfolders  = 1;           /* Lock folder when open */
int lock_in_copy = 1;           /* Lock folder when copied to it    */
#else
int lockfolders  = 0;           /* Lock folder when open */
int lock_in_copy = 0;           /* Lock folder when copied to it    */
#endif
char folders[SLEN] = {0};	/* folder home directory            */
char raw_folders[SLEN] = {0};	/* unexpanded folder home directory */
char extra_mailbox_dir[SLEN]     = {0};
char raw_extra_mailbox_dir[SLEN] = {0};
int mail_permissions = 0600;	/* int: permissions for mailbox files */
int mini_menu = 1;		/* flag: menu specified?	    */
char raw_metamail_path[SLEN] = METAMAIL_PATH;
char metamail_path[SLEN] = "metamail"; /* Metamail path or "none"   */
                                /* if no metamail                   */
int metoo = 0;			/* flag: copy me on mail to alias?  */
int mime_body_keywords = TRUE;  /* flag: parse body looking for encode */
				/* keywords */
int mimeforward = FALSE;        /* flag: Forward as Message/rfc822  */
int move_when_paged = 0;	/* flag: move when '+' or '-' used? */
int names_only = 1;		/* flag: display user names only?   */
int allow_no_encoding = 0;      /* 1: Allow 8bit without -B8BITMIME */
                                /* 2: Allow binary without -BBINARYMIME and */
                                /*    and 8bit without -B8BITMIME   */
int allow_no_hdrencoding = 0;   /* TRUE, if header encoding is      */
				/* not required                     */
int noheader = 1;		/* flag: copy + header to file?     */
int noheaderfwd = 0;		/* flag: copy + header to file(fwd)? */
int pagealternative=1;          /* Page if alternative have one know*/
                                /* subtype ?                        */
int page_known_charsets=1;      /* Page if charset is not unknown?  */
int pagemultipart=0;            /* Page unknown mime subparts?      */
int pagesigned=0;               /* Page unknown signed protocols?   */
char pager[SLEN] = {0};		/* what pager to use                */
char raw_pager[SLEN] = {0};	/* unexpanded what pager to use     */
#ifdef USE_PGP
char pgp2_path[SLEN]   = "none"; /* Pgp path or "none" if no pgp     */
char raw_pgp2_path[SLEN] = PGP2_PATH;
char pgp5_dir[SLEN] = "none";   /* pgp5 binary directory or "none" if no pgp5 */
char raw_pgp5_dir[SLEN] = PGP5_DIR;
char gpg_path[SLEN]  = "none";
char raw_gpg_path[SLEN] = GPG_PATH;
#endif
int point_to_new = 1;		/* flag: start pointing at new msg? */
char allowed_precedences[SLEN] = {0};	/* list of precedences user */
                                /* may specify                      */
char prefixchars[SLEN] = "> ";	/* prefix char(s) for msgs          */
char printout[SLEN] = {0};	/* how to print messages            */
char raw_printout[SLEN] = DEFAULT_PRINTOUT;	
                                /* unexpanded how to print messages */
int prompt_after_pager = 1;	/* flag: prompt after pager exits   */
int quote_forward = 0;		/* flag: fwd'd msgs quoted like replies */
int readdatapercentinc = 5;	/* data percent increment during new mbox read */
int readmsginc = 100;		/* increment of msg cnt when reading*/
                                /* new mbox                         */
char recvd_mail[SLEN] = {0};	/* folder for storing received mail */
char raw_recvdmail[SLEN] = {0};	/* unexpanded recvd_mail name       */
char remote_signature[SLEN] = {0};  /* remote msg signature file    */
char raw_remote_signature[SLEN] = {0};	/* unexpanded remote msg    */
                                /* signature file                   */
int req_mime_bodyencoding = 1;  /*                                  */
int req_mime_hdrencoding = 0;   /*                                  */
int resolve_mode = 1;		/* flag: delete saved mail?	    */
int save_by_name = 1;		/* flag: save mail by login name?   */
char sent_mail[SLEN] = {0};	/* name of file to save copies to   */
int send_mime_plain  = 1;       /* flag: send plain text as MIME?   */
char raw_sentmail[SLEN] = {0};	/* unexpanded name of file to save to*/
char shell[SLEN] = {0};		/* current system shell             */
char raw_shell[SLEN] = {0};	/* unexpanded current system shell  */
#ifdef USE_PGP
int pgp_noarmor=1;      /* Should Elm display text before PGP armor */
#endif
int showto = 0;                 /*                                  */
int show_header_errors = 1;     /* flag: should some header reported? */
int sig_dashes = 1;		/* flag: include dashes above sigs? */
int sleepmsg = 2;		/* time to sleep for messages being */
                                /* overwritten on screen            */
/* int hp_softkeys = 0;	*/	/* flag: are there softkeys?        */
int sortby = REVERSE SENT_DATE;	/* how to sort incoming mail...     */
long elm_timeout = 600L;	/* timeout (secs) on main prompt    */
int sort_thread_max_time = 30;  /* Number of days which can considered 
				    be same thread */
char temp_dir[SLEN] = {0};      /* name of temp directory           */
char raw_temp_dir[SLEN] = {0};  /* unexpanded name of temp directory*/
#ifdef USE_PGP
int pgp_keeppass=0;             /* should Elm keep the passphrase in*/
                                /* memory?                          */
#endif
int user_level = 0;		/* flag: how good is the user?      */
int use_tite = 1;		/* flag: use termcap/terminfo ti/te?*/
int utf7_encode_optional = 1;   /* flag: Should utf7 optional direct 
				   characters to be encoded?        */
char v_editor[SLEN] = {0};	/* "~v" editor...                   */
int elm_filter = 1;		/* flag: weed out header lines?	    */
char *weedlist[MAX_IN_WEEDLIST] = {0}; /*                           */
int  weedcount;                 /*                                  */

#ifdef REMOTE_MBX
char raw_imap_charset[SLEN] = "SYSTEM";  /* IMAP foldername charset */
int imap_fast_lookup = 0;           /* flag: skip some directory listing */
charset_t imap_charset = NULL;           /* IMAP foldername charset */
int IMAP_connection_cache = 1; /* flag: call cache_connection() ? */
int IMAP_name_convention = 1; /* flag: Should imap intearnational folder
				 convention be used? */
int IMAP_use_examine   = 1;  /* flag: Should EXAMINE command to be used?    */
int IMAP_show_greeting = 1;  /* flag: Should untagged OK messages be shown? */
int IMAP_show_warning  = 1;  /* flag: Should untagged NO messages be shown? */
int IMAP_show_error    = 1;  /* flag: Should untagged BAD messages be shown? */
int POP_show_greeting  = 1;  /* flag: Should POP server greeting be shown?  */
#endif

/* ---------------------------------------------------------------- */

static void do_expand_env P_((char  *descr, char *dest, char *src,
			      unsigned	destlen));
static void do_expand_env(descr, dest, src, destlen)
     char	*descr, *dest, *src;
     unsigned	destlen;
{
    if (expand_env(dest, src, destlen) != 0) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotInitErrorExpanding,
			  "Cannot initialize \"%s\" - error expanding \"%s\"."),
		  descr, src);
	errors++;
	dest[0] = '\0';
    }
}

static void do_expand_meta P_((char  *descr, char *dest, char *src,
			      unsigned	destlen));
static void do_expand_meta(descr, dest, src, destlen)
    char	*descr, *dest, *src;
    unsigned	destlen;
{
    if (expand_meta(dest, src, destlen) != 0) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotInitErrorExpanding,
			  "Cannot initialize \"%s\" - error expanding \"%s\"."),
		  descr, src);
	errors++;
	dest[0] = '\0';
    }
}

/* sets locale and elm_msg_cat */
static int locale_init_called = 0;
static int locale_error = 0;

void locale_init () {

#ifdef I_LOCALE
  char *res;

  if (setlocale(LC_ALL, "") == NULL) {
      lib_error(FRM("Elm: Unsupported locale (check $LANG)\n"));
    if (setlocale(LC_CTYPE,"") != NULL) {
	lib_error(FRM("Elm: ... but succeed setting of LC_CTYPE\n"));
    } else {
	lib_error(FRM("Elm: ... check also $LC_CTYPE\n"));
    }
    locale_error = 1;
  }
#endif

  elm_msg_cat       = catopen("elm2.4me+", 0);

#ifdef  I_LOCALE
  res = setlocale(LC_CTYPE,NULL);
  if (!res) {
      lib_error(FRM("Elm: Unable to get current locale (LC_CTYPE)\n"));
      locale_error = 1;
  } else
    strfcpy(display_locale,res, sizeof display_locale);
#endif
  
  locale_init_called++;
}

enum matches { match_exact = 0, match_charset, 
	       match_lang_country, match_lang, MATCH_COUNT };

struct locale_map_item  * system_locale_map = NULL;
struct locale_map_item  * user_locale_map   = NULL;

static void map_system_charset P_((CONST char * lc_ctype));
static void map_system_charset(lc_ctype)
     CONST char * lc_ctype;
{  
    CONST char *lang = NULL;
    CONST char *lang_country = NULL;
    CONST char *charset = NULL;
    charset_t d_matches[MATCH_COUNT];
    int i,j;

    char * default_system_charset = DEFAULT_SYSTEM_CHARSET;
    char * c1;

    char lbuf[3], cbuf[6];

    if (!getenv("NOMETAMAIL") && (c1 = getenv("MM_CHARSET")) &&
	c1[0]) {

	default_system_charset  = c1;
	DPRINT(Debug,9,(&Debug, 
			"map_system_charset: using $MM_CHARSET (%s) as default system charset\n",
			default_system_charset));
    }

    for (i = 0; i < MATCH_COUNT; i++)
	d_matches[i] = NULL;

    if (isascii(lc_ctype[0]) && isalpha(lc_ctype[0]) &&
	isascii(lc_ctype[1]) && isalpha(lc_ctype[1]) &&
	('.' == lc_ctype[2] || '_' == lc_ctype[2] || '\0' == lc_ctype[2])) {
	strncpy(lbuf,lc_ctype,3);
	lbuf[2] = '\0';
	lang = lbuf;
	
	if ('_' == lc_ctype[2]) {
	    if (isascii(lc_ctype[3]) && isalpha(lc_ctype[3]) &&
		isascii(lc_ctype[4]) && isalpha(lc_ctype[4]) &&
		('.' == lc_ctype[5] || '\0' == lc_ctype[5])) {

		strncpy(cbuf,lc_ctype,6);
		cbuf[5] = '\0';
		lang_country = cbuf;
		
		if ('.' == lc_ctype[5])
		    charset = lc_ctype+6;
	    }
	} else if ('.' == lc_ctype[2])
	    charset = lc_ctype+3;      
    }
    
    if (lang) {
	DPRINT(Debug,10,(&Debug,
			 "map_system_charset: %s -> lang: %s\n", 
			 lc_ctype,lang));
    } 
    if (lang_country) {
	DPRINT(Debug,10,(&Debug,
			 "map_system_charset: %s -> lang_country: %s\n", 
			 lc_ctype,lang_country));
    }
    if (charset) {
	DPRINT(Debug,10,(&Debug,
			 "map_system_charset: %s -> charset: %s\n", 
			 lc_ctype,charset));
    }

    for (i = 0; i < 3; i++) {
	if ( i < 2) {
	    int k;
	    struct locale_map_item * F = user_locale_map;
	    if (1 == i)
		F = system_locale_map;

	    if (!F)
		continue;

	    for (k = 0; F[k].charset; k++) {
		if (F[k].match) {
		    if (istrcmp (F[k].match, lc_ctype) == 0) {
			d_matches[match_exact] = F[k].charset;
			
			DPRINT(Debug,3,(&Debug,
					"map_system_charset: user defined \"%s\" as %s\n", 
					lc_ctype, 
					d_matches[match_exact]->MIME_name ?
					d_matches[match_exact]->MIME_name :
					"<no MIME name>"));
		    }
		    if (charset && strncmp(F[k].match,"*.",2) == 0  &&
			istrcmp (F[k].match+2, charset) == 0) {
			
			d_matches[match_charset] = F[k].charset;
			
			DPRINT(Debug,3,(&Debug,
					"map_system_charset: user defined \"%s\" (*.%s) as %s\n", 
					lc_ctype, charset,
					d_matches[match_charset]->MIME_name ?
					d_matches[match_charset]->MIME_name :
					"<no MIME name>"));	      
		    }
		    if (lang_country && istrcmp (F[k].match, lang_country) == 0) {
			d_matches[match_lang_country] = F[k].charset;

			DPRINT(Debug,3,(&Debug,
					"map_system_charset: user defined \"%s\" (%s) as %s\n", 
					lc_ctype, lang_country, 
					d_matches[match_lang_country]->MIME_name ?
					d_matches[match_lang_country]->MIME_name :
					"<no MIME name>")); 
			
		    }
		    
		    if (lang_country && istrcmp (F[k].match, lang) == 0) {
			d_matches[match_lang] = F[k].charset;
			
			DPRINT(Debug,3,(&Debug,
					"map_system_charset: user defined \"%s\" (%s) as %s\n", 
					lc_ctype, lang, 
					d_matches[match_lang]->MIME_name ?
					d_matches[match_lang]->MIME_name :
					"<no MIME name>"));
		    }
		}
	    }

	    for (j = 0; j < MATCH_COUNT; j++)
		if (d_matches[j]) {
		    system_charset = d_matches[j];
		  
		    DPRINT(Debug,3,(&Debug,
				    "map_display_charset: using match %d: user defined \"%s\" as %s\n", 
				    j,lc_ctype, 
				    system_charset->MIME_name ?
				    system_charset->MIME_name :
				    "<no MIME name>"));

		    return;
		}
	} else {
	    int val;
	    char buffer[STRING];
	  
	    if (0 == strcmp(lc_ctype,"C"))
		system_charset = MIME_name_to_charset("US-ASCII",1); 
	    else if (0 == istrcmp(lc_ctype,"ASCII") ||
		     0 == istrcmp(lc_ctype,"US-ASCII"))
		system_charset = MIME_name_to_charset("US_ASCII",1);
	    else if (0 == strincmp(lc_ctype,"ISO-8859-",9) &&
		     0 < (val = atoi(lc_ctype+9))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (0 == strincmp(lc_ctype,"ISO_8859-",9) &&
		       0 < (val = atoi(lc_ctype+9))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (0 == strincmp(lc_ctype,"ISO8859-",8) &&
		       0 < (val = atoi(lc_ctype+8))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (charset && (0 == istrcmp(charset,"ASCII") ||
				   0 == istrcmp(charset,"US-ASCII")))
		system_charset = MIME_name_to_charset("US-ASCII",1);
	    else if (charset &&
		     0 == strincmp(charset,"ISO-8859-",9) &&
		     0 < (val = atoi(charset+9))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (charset &&
		       0 == strincmp(charset,"ISO_8859-",9) &&
		       0 < (val = atoi(charset+9))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (charset &&
		       0 == strincmp(charset,"ISO8859-",8) &&
		       0 < (val = atoi(charset+8))) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%d"),
			     val);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else if (charset &&
		       0 == strincmp(charset,"ISO8859",7) &&
		       isascii(charset[7]) && isdigit(charset[7]) && 
		       '\0' == charset[8]) {
		elm_sfprintf(buffer, sizeof buffer,
			     FRM("ISO-8859-%c"),
			     charset[7]);
		system_charset = MIME_name_to_charset(buffer,1);
	    } else {
		system_charset = MIME_name_to_charset(default_system_charset,
						      1);
	      
		lib_error(FRM("Elm: Unable to map %.20s locale (LC_CTYPE) to MIME charset"),
			  lc_ctype);
		lib_error(FRM("     Using default (%.20s). Check %.100s or\n      %.100s"),
			  default_system_charset,system_mime_charsets,
			  user_mime_charsets);
		locale_error = 1;
	    }

	    DPRINT(Debug,3,(&Debug,
			    "map_display_charset: default \"%s\" as \"%s\"\n", 
			    lc_ctype, system_charset->MIME_name));
	}
    }
}

void user_init() 
{
    char *cp;
    int r;
    
    /** initialize the whole ball of wax.
     **/
    struct passwd *pass, *getpwnam();
    
    if (!locale_init_called)
	locale_init ();
    
    /* save original user and group ids */
    userid  = getuid();
    groupid = getgid();	
    
    /* GNU library seems give _SC_SAVED_IDS as enumerated
       value instead of #define so we can not test if
       it is defined (as macro)
    */
#if defined(_SC_SAVED_IDS) || defined(_POSIX_VERSION)
    r = sysconf(_SC_SAVED_IDS);
    if (r < 0) {
	int err = errno;
	DPRINT(Debug,1,(&Debug,
			"sysconf(_SC_SAVED_IDS) failed: (errno=%d) %s\n",
			err,error_description(err)));	
	    
	have_saved_ids = 0;
    } else {
	have_saved_ids = r > 0;
	DPRINT(Debug,1,(&Debug,
			"*** have_saved_ids=%d\n",have_saved_ids));
    }
#else
    have_saved_ids = 0;
#endif
    mailgroupid = getegid();
    
    /* Get username (logname), home (login directory), and full_username
     * (part of GCOS) field from the password entry for this user id.
     * Full_username will get overridden by fullname in elmrc, if defined.
     *
     * For those sites that have various user names with the same user
     * ID, use the passwd entry corresponding to the user name as long 
     * as it matches the user ID.  Otherwise fall back on the entry 
     * associated with the user ID alone.
     */

    if((cp = getenv("LOGNAME")) == NULL)
	cp = getenv("USER");
    if(cp != NULL && (pass = getpwnam(cp)) != NULL &&
       pass->pw_uid == userid) {
	;  /* Null body */
    } else if((pass = getpwuid(userid)) == NULL) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmYouHaveNoPasswordEntry,
			  "You have no password entry!"));
	exit(1);
    }
    strfcpy(username, pass->pw_name, sizeof username);
    strfcpy(home, pass->pw_dir, sizeof home);
    strfcpy(shell, pass->pw_shell, sizeof shell);
	/* Null shell in /etc/passwd means /bin/sh */
    if ('\0' == shell[0]) 
	strfcpy(shell, "/bin/sh", sizeof shell);
    
    if((cp = get_full_name(username)) != NULL)
	strfcpy(full_username, cp, sizeof full_username);
    else
	strfcpy(full_username, username, sizeof full_username);	
    /* fall back on logname */

    elm_sfprintf(user_rc_file, sizeof user_rc_file,
		 FRM("%s/%s"), home, ELMRCFILE);
    elm_sfprintf(user_text_file, sizeof user_text_file,
		 FRM("%s/%s"), home, USER_ALIAS_TEXT);
    elm_sfprintf(user_data_file, sizeof user_data_file,
		 FRM("%s/%s"), home, USER_ALIAS_DATA);
    elm_sfprintf(user_mime_types, sizeof user_mime_types,
		 FRM("%s/%s"), home, USER_MIME_TYPES);
    elm_sfprintf(user_mailheaders, sizeof user_mailheaders,
		 FRM("%s/%s"), home, MAILHEADERS);
    elm_sfprintf(user_mime_charsets, sizeof user_mime_charsets,
		 FRM("%s/%s"), home, USER_MIME_CHARSETS);
    elm_sfprintf(user_terminal_info, sizeof user_terminal_info,
		 FRM("%s/%s"), home, USER_TERMINAL_INFO);
    elm_sfprintf(user_mail_services, sizeof user_mail_services,
		 FRM("%s/%s"), home, USER_MAIL_SERVICES);

#if DEBUG    
    /* Open debug files and print spooled debug output */
    debug_user_init();
#endif
}

#ifdef I_NETDB
/* Seems that h_errno is macro on AIX */
#ifndef h_errno
extern int h_errno;
#endif
#endif

static void default_weedlist P_((void));

static int figure_domain P_((void));
static int figure_domain() 
{
#ifdef I_NETDB
    if (hostname[0]) {
	struct hostent *he = gethostbyname(hostname);
	if (!he) {
	    DPRINT(Debug,3,(&Debug,
			    "figure_domain: %s: h_errno=%d\n",
			    hostname,h_errno));
	    switch(h_errno) {
	    case TRY_AGAIN:
		lib_error(CATGETS(elm_msg_cat, MeSet,MeTemporary,
				  "Address for %s is not yet found..."),
			  hostname);
	    }
	} else {
	    int ok = 0;
	    int idx;
	    char *p;
	    if (NULL != (p = 
			 strchr(he->h_name ,'.'))) {
		if (!hostdomain[0])
		    strfcpy(hostdomain,p,sizeof hostdomain);
		if (!hostfullname[0]) 
		    strfcpy(hostfullname, he->h_name, sizeof hostfullname);
		ok = 1;
	    } 
	    for (idx = 0; !ok && he->h_aliases[idx]; idx++) 
		if (NULL != (p = 
			     strchr(he->h_aliases[idx],'.'))) {
		    if (!hostdomain[0])
			strfcpy(hostdomain,p,sizeof hostdomain);
		    if (!hostfullname[0]) 
			strfcpy(hostfullname, he->h_aliases[idx], 
				sizeof hostfullname);
		    ok = 1;
		} 
	    if (ok) {
		DPRINT(Debug,3,(&Debug,
				"hostname=\"%s\" -> hostdomain=\"%s\", hostfullname=\"%s\"\n",
				hostname,hostdomain,hostfullname));
	    }
	    return ok;
	}
    }
#endif    
    return 0;
}

static void generate_hostfullname P_((void));
static void generate_hostfullname() 
{
    int hostlen, domlen;

    /*
     * now the tough part:
     *	we need to make three variables out of this stuff:
     *	hostname = just the hostname, as in bangpaths,
     *		this is whatever the user gave us so far,
     *		we wont change this one
     *	hostdomain = this is the domain considered local to this
     *		machine, and should be what we got above.
     *	hostfullname = this is the full FQDN of this machine,
     *		and is a strange combination of the first two.
     *	if tail(hostname) == hostdomain
     *		then hostfullname = hostname
     *			ie: node.ld.domain.type, ld.domain.type -> node.ld.domain.type
     *	else if hostname == hostdomain + 1
     *		then hostfullname = hostname
     *			ie: domain.type, .domain.type -> domain.type
     *	
     *	else hostfullname = hostname + hostdomain
     *			ie: host, .domain.type -> host.domain.type
     * lost yet?
     */
    
    DPRINT(Debug,3,(&Debug,
		    "hostname=\"%s\",hostdomain=\"%s\" ",
		    hostname,hostfullname));
    
    hostlen = strlen(hostname);
    domlen = strlen(hostdomain);
    if (hostlen >= domlen) {
	if (istrcmp(&hostname[hostlen - domlen], hostdomain) == 0)
	    strfcpy(hostfullname, hostname, sizeof hostfullname);
	else {
	    strfcpy(hostfullname, hostname, sizeof hostfullname);
	    strfcat(hostfullname, hostdomain, sizeof hostfullname);
	}
    } else {
	if (istrcmp(hostname, hostdomain + 1) == 0)
	    strfcpy(hostfullname, hostname, sizeof hostfullname);
	else {
	    strfcpy(hostfullname, hostname, sizeof hostfullname);
	    strfcat(hostfullname, hostdomain, sizeof hostfullname);
	}
    }
    
    DPRINT(Debug,3,(&Debug,
		    "-> hostfullname=\"%s\"\n",
		    hostfullname));
}

struct terminal_map_item * system_terminal_map = NULL;
struct terminal_map_item * user_terminal_map = NULL;

int init_defaults() {
    char     *cp;
    FILE * file;
#ifdef DOUNAME
    struct utsname u_name;
#endif

    /* Establish some defaults in case elmrc is incomplete or not there.
     * Defaults for other elmrc options were established in their
     * declaration - in elm.h.  And defaults for sent_mail and recvd_mail
     * are established after the elmrc is read in since these default
     * are based on the folders directory name, which may be given
     * in the emrc.
   */
    

    default_weedlist();
    errors = 0;

    /*
     * Get the host name as per configured behavior.
     */

#ifdef GETHOSTNAME
    if (-1 == gethostname(hostname, sizeof(hostname))) {
	int err = errno;
	DPRINT(Debug,1,(&Debug,
			"gethostname failed: (errno=%d) %s\n",
			err,error_description(err)));	
    } else {
	DPRINT(Debug,3,(&Debug,
			"gethostname: Setting hostname to %s\n",
			hostname));
    }
#endif   
   
#ifdef DOUNAME
    if (-1 == uname(&u_name)) {
	int err = errno;
	DPRINT(Debug,1,(&Debug,
			"uname failed: (errno=%d) %s\n",
			err,error_description(err)));	
	
    } else if (!hostname[0]) {
	strfcpy(hostname, u_name.nodename, sizeof hostname);
	DPRINT(Debug,3,(&Debug,
			"uname: Setting hostname to %s\n",
			hostname));
    }
#endif

    
    /*
     * now get the domain name, used to build the full name
     */
    if (!figure_domain()) {
	gethostdomain(hostdomain, sizeof(hostdomain));
	
	if (hostname[0] && hostdomain[0]) {
	    generate_hostfullname();
	}
    }
    
    /* Determine the default mail file name.
     * 
     * First look for an environment variable MAIL, then
     * use then mailhome if it is not found
     */
    if ((cp = getenv("MAIL")) == NULL) {
	elm_sfprintf(defaultfile, sizeof defaultfile,
		     FRM("%s%s"), mailhome, username);
	elm_sfprintf(raw_defaultfile, sizeof raw_defaultfile,
		     FRM("%s%s"), mailhome, username);
	
    } else {
	strfcpy(raw_defaultfile, "$MAIL", sizeof raw_defaultfile);
	strfcpy(defaultfile, cp, sizeof defaultfile);
    }
    alternative_addresses = NULL; 	/* none yet! */
    
    raw_local_signature[0] = raw_remote_signature[0] =
	local_signature[0] = remote_signature[0] =
	raw_recvdmail[0] = raw_sentmail[0] = 
	allowed_precedences[0] = '\0';
    /* no defaults for those */
    
    if (NULL != (cp = getenv("SHELL")) && '\0' != cp[0]) {
	strfcpy(raw_shell, "$SHELL", sizeof raw_shell);
	do_expand_env("shell", shell, raw_shell, sizeof(shell));
    } else {
	/* Shell is set from /etc/passwd in initialize () */
	raw_shell[0] = '\0';
    }
    strfcpy(raw_pager, ((cp = getenv("PAGER")) == NULL)? default_pager : cp,
	    sizeof raw_pager);
    do_expand_env("pager", pager, raw_pager, sizeof(pager));
    
    strfcpy(raw_temp_dir, (cp = getenv("TMPDIR")) ? cp : default_temp,
	    sizeof raw_temp_dir);

    do_expand_env("temp_dir", temp_dir, raw_temp_dir, sizeof(temp_dir));
    if (temp_dir[0] == '\0' || 
	temp_dir[strlen (temp_dir)-1] != '/')
	strfcat(temp_dir, "/", sizeof temp_dir);
    
    if ((cp = getenv("EDITOR")) != NULL && '\0' != cp[0]) {
	strfcpy(raw_editor, "$EDITOR", sizeof raw_editor);
	strfcpy(editor, cp, sizeof editor);
    } else {
	strfcpy(raw_editor, default_editor, sizeof raw_editor);
	do_expand_env("editor", editor, raw_editor, sizeof(editor));
    }

    elm_sfprintf(raw_folders, sizeof raw_folders, FRM("~/%s"), 
		 default_folders);
    do_expand_env("folders", folders, raw_folders, sizeof(folders));

    do_expand_meta("map-text-dir", map_txtdir, raw_map_txtdir,
		   sizeof(map_txtdir));

    do_expand_meta("map-bin-dir", map_bindir, raw_map_bindir,
		   sizeof(map_bindir));
       
    elm_sfprintf(raw_calendar_file, sizeof raw_calendar_file,
		 FRM("~/%s"), dflt_calendar_file);
    do_expand_env("calendar_file", calendar_file, raw_calendar_file,
		  sizeof(calendar_file));

    strfcpy(e_editor, emacs_editor, sizeof e_editor);
    strfcpy(v_editor, default_editor, sizeof v_editor);
    
    elm_sfprintf(raw_folders, sizeof raw_folders,
		 FRM("%s/%s"), home, default_folders);
    strfcpy(folders, raw_folders, sizeof folders);
    
    elm_sfprintf(raw_calendar_file, sizeof raw_calendar_file,
		 FRM("%s/%s"), home, dflt_calendar_file);
    strfcpy(calendar_file, raw_calendar_file, sizeof calendar_file);
    
    /* try system-wide rc file */
    file = fopen(system_rc_file, "r");
    if ( file != NULL ) {
	do_rc(file, SYSTEM_RC,system_rc_file);
	fclose(file);
    } else if (!hostname[0] || !hostdomain[0] || !hostfullname[0]) {
	int err = errno;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedSystemRC,
			  "Failed to open RC file %s: %s"),
		  system_rc_file,error_description(err));    
	errors++;
    } 
    if (figure_domain()) {
	/* Do nothing */
    } else if (!hostname[0] || !hostdomain[0]) {
	if (hostfullname[0]) {
	    char * p = strchr(hostfullname,'.');
	    if (!hostname[0]) 
		strfcpy(hostname,hostfullname,sizeof hostname);
	    if (!hostdomain[0]) {
		if (p)
		    strfcpy(hostdomain,p,sizeof hostdomain);
		else 	      
		    strfcpy(hostdomain,".localdomain",sizeof hostdomain);
	    }
	} else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmDefineHostname,
			      "Give \"hostname\", \"hostfullname\" and \"hostdomain\" on RC file: %s"),
		      system_rc_file);
	    if (!hostname[0]) 
		strfcpy(hostname,"localhost",sizeof hostname);
	    if (!hostdomain[0]) 
		strfcpy(hostdomain,".localdomain",sizeof hostdomain);
	    if (!hostfullname[0])
		strfcpy(hostfullname,hostname,sizeof hostfullname);
	    errors++;       
	}
    } else if (!hostfullname[0]) {
	if ('.' != hostdomain[0]) {
	    char buffer[SLEN];
	    strfcpy(buffer,hostdomain,sizeof buffer);
	    strfcpy(hostdomain,".",sizeof hostdomain);
	    strfcat(hostdomain,buffer,sizeof hostdomain);
	    DPRINT(Debug,3,(&Debug,
			    "hostdomain=\"%s\" -> hostdomain=\"%s\"\n",
			    buffer,hostdomain));
	}
	generate_hostfullname();
    }

    /* load_locale_map may refer to map-text-dir ... */
    do_expand_meta("map-text-dir", map_txtdir, raw_map_txtdir,
		   sizeof(map_txtdir));

    /* Also map-bin-dir may be referenced on future ... */
    do_expand_meta("map-bin-dir", map_bindir, raw_map_bindir,
		   sizeof(map_bindir));

    system_locale_map = load_locale_map(system_mime_charsets,&errors);
    system_terminal_map = load_terminal_map(system_terminal_info,&errors);

    parse_service_entries(system_mail_services,1 /* SYSTEM */,&errors);

    DPRINT(Debug,3,(&Debug, 
		    "init_defaults=%d (errors)\n",errors));

    return errors;
}

enum charset_keyword { cskw_none = 0, cskw_SYSTEM, cskw_DISPLAY, cskw_TEXT };

static enum charset_keyword special_charset_keyword P_((const char *value));
static enum charset_keyword special_charset_keyword(value)
     CONST char *value;
{
    if (0 == strcmp(value,"SYSTEM"))
	return cskw_SYSTEM;
    else if (0 == strcmp(value,"DISPLAY"))
	return cskw_DISPLAY;
    else if (0 == strcmp(value,"TEXT"))
	return cskw_TEXT;
    else
	return cskw_none;
}

void post_process_charset_options()
{
    switch (special_charset_keyword(raw_text_charset)) {
    case cskw_SYSTEM:   text_charset = system_charset;  break;
    case cskw_DISPLAY:  text_charset = display_charset; break;
    case cskw_TEXT:     
	text_charset = display_charset;
	strfcpy(raw_text_charset,"DISPLAY",sizeof raw_text_charset);
	break;
    }

    switch (special_charset_keyword(raw_display_charset)) {
    case cskw_SYSTEM:   wanted_display_charset = system_charset;  break;
    case cskw_DISPLAY:  wanted_display_charset = display_charset; break;
    case cskw_TEXT:     wanted_display_charset = text_charset;    break;
    }

    if (!wanted_display_charset ||
	0 == (charset_properties(wanted_display_charset) & CS_mapping)) {
	if (0 != charset_properties(system_charset)) 
	    wanted_display_charset = system_charset;
	else
	    wanted_display_charset = ASCII_SET;

	DPRINT(Debug,2,(&Debug,
			"Setting (wanted) display-charset to %s instead.\n",
			wanted_display_charset->MIME_name ?
			wanted_display_charset->MIME_name :
			"<no MIME name"));
    }
    if (!text_charset || !text_charset->MIME_name) {
	text_charset = ASCII_SET;
	DPRINT(Debug,2,(&Debug,
			"Setting text-charset to %s instead.\n",
			text_charset->MIME_name ?
			text_charset->MIME_name :
			"<no MIME name"));
    }

    switch (special_charset_keyword(raw_local_fs_charset)) {
    case cskw_SYSTEM:   local_fs_charset = system_charset;  break;
    case cskw_DISPLAY:  local_fs_charset = display_charset; break;
    case cskw_TEXT:     local_fs_charset = text_charset;    break;
    }

    switch (special_charset_keyword(raw_default_nomime_charset)) {
    case cskw_SYSTEM:   default_nomime_charset = system_charset;  break;
    case cskw_DISPLAY:  default_nomime_charset = display_charset; break;
    case cskw_TEXT:     default_nomime_charset = text_charset;    break;
    }

#ifdef REMOTE_MBX
    switch (special_charset_keyword(raw_imap_charset)) {
    case cskw_SYSTEM:   imap_charset = system_charset;  break;
    case cskw_DISPLAY:  imap_charset = display_charset; break;
    case cskw_TEXT:     imap_charset = text_charset;    break;
    }
#endif
	
}

int read_rc_file()
{
    /** this routine does all the actual work of reading in the
	.rc file... **/

    FILE *file;
	
    errors = 0;
    
    /* Look for the elmrc file */
    if ((file = fopen(user_rc_file, "r")) == NULL) {
	DPRINT(Debug,2,(&Debug,
			"Warning:User has no \"%s\" file\n\n",
			user_rc_file));
    }
    
    if (file != NULL) {
	do_rc(file, LOCAL_RC, ELMRCFILE);
	fclose(file);
    }

    user_locale_map   = load_locale_map(user_mime_charsets,&errors);
    user_terminal_map = load_terminal_map(user_terminal_info,&errors);
    
    parse_service_entries(user_mail_services,0 /* USER */,&errors);
    
    post_init_check();
    
    DPRINT(Debug,3,(&Debug, 
		    "read_rc_file=%d (errors)\n",errors));

    return errors;
}

void post_init_check() {

    do_expand_env("folders", folders, raw_folders, sizeof(folders));

    do_expand_env("extra-mailbox-dir", extra_mailbox_dir,
		  raw_extra_mailbox_dir, sizeof(extra_mailbox_dir));
    
    if (raw_extra_mailbox_dir[0] &&
	0 == strcmp(extra_mailbox_dir,folders)) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmExtraNoFolders,
			  "\"extra-mailbox-dir\" should not be \"folders\" or \"maildir\" directory."));	    
	raw_extra_mailbox_dir[0] = '\0';
    }

    do_expand_env("temp_dir", temp_dir, raw_temp_dir, sizeof(temp_dir));
    if ('\0' == temp_dir[0])
	strfcpy(temp_dir,"/tmp/", sizeof temp_dir);
    else if (temp_dir[strlen (temp_dir)-1] != '/')
	strfcat(temp_dir, "/", sizeof temp_dir);
    
    do_expand_env("incoming-mailbox", 
		  defaultfile, raw_defaultfile, 
		  sizeof(defaultfile));
    
    if (raw_shell[0] != '\0') {
	/* shell is taken from /etc/passwd in initialize() */
	do_expand_env("shell", shell, raw_shell, sizeof(shell));
    }
    do_expand_env("editor", editor, raw_editor, sizeof(editor));
    
    do_expand_env("calendar_file", calendar_file, raw_calendar_file,
		  sizeof(calendar_file));
    
    if (strcmp(raw_printout,"none") == 0 || 
	raw_printout[0] == '\0') {
	strfcpy(raw_printout,"none", sizeof raw_printout);
	strfcpy(printout,"none", sizeof printout);
    } else {
	do_expand_env("printout", printout, raw_printout, sizeof(printout));
    }
    
    do_expand_env("pager", pager, raw_pager, sizeof(pager));
    if (equal(pager, "builtin+") || equal(pager, "internal+"))
	clear_pages++;
    
    do_expand_env("local_signature", local_signature,
		  raw_local_signature, sizeof(local_signature));
    do_expand_env("remote_signature", remote_signature,
		  raw_remote_signature, sizeof(remote_signature));
    
    if (equal(local_signature, remote_signature) &&
	(equal(shift_lower(local_signature), "on") ||
	 equal(shift_lower(local_signature), "off"))) {
	errors++;
	
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSignatureObsolete,
			  "\"signature\" used in obsolete way in .elm/elmrc file. Ignored!\n\
\t(Signature should specify the filename to use rather than on/off.)"));

	raw_local_signature[0] = raw_remote_signature[0] =
	    local_signature[0] = remote_signature[0] = '\0';
    }
    
    /* if (hp_softkeys) hp_terminal=TRUE; */	/* must be set also! */
    
    allow_forms = (allow_forms?MAYBE:NO);
    
    if ((elm_timeout != 0) && (elm_timeout < 10)) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTimeoutLTTen,
			  "Warning: timeout is set to less than 10 seconds. Ignored."));
	elm_timeout = 0;
    }
    
    if (readdatapercentinc < 1) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReadDataIncrement,
			  "Warning: readdatapercentinc is set to less than 1.  Ignored."));
	readdatapercentinc = 1;
    }

    if (readmsginc < 1) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReadMessageIncrement,
			  "Warning: readmsginc is set to less than 1.  Ignored."));
	readmsginc = 1;
    }

    if (sleepmsg < 0) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSleepMessageInvalid,
			  "Warning: sleepmsg is set to less than 0.  Setting to 0."));
	sleepmsg = 0;
    }
    
#ifdef BACKGROUD_PROCESSES       
    if (background_wait_time  < 0) {
	errors++;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBackgroundLLT,
			  "Warning: background_wait_time is set less than 0. Setting to 0."));
	background_wait_time = 0;
    }
#endif
    
    
    /* If recvd_mail or sent_mail havent't yet been established in
     * the elmrc, establish them from their defaults.
     * Then if they begin with a metacharacter, replace it with the
     * folders directory name.
     */
    if(*raw_recvdmail == '\0') {
	strfcpy(raw_recvdmail, default_recvdmail,
		sizeof raw_recvdmail);
    }
    
    do_expand_meta("recvd_mail", recvd_mail, raw_recvdmail,
		   sizeof(recvd_mail));
    
    if(*raw_sentmail == '\0') {
	strfcpy(raw_sentmail, default_sentmail, sizeof raw_sentmail);
	strfcpy(sent_mail, default_sentmail, sizeof sent_mail);
    }
    
    do_expand_meta("sent_mail", sent_mail, raw_sentmail, 
		   sizeof(sent_mail));
    
    if (strcmp(raw_unidata_path,"none") == 0 || 
	raw_unidata_path[0] == '\0') {
	
	strfcpy(raw_unidata_path,"none",sizeof raw_unidata_path);
	strfcpy(unidata_path,"none",sizeof unidata_path);
	
    } else if (NULL == strpbrk(raw_unidata_path,"/$\\;{}()")) {
	if (0 != access(map_bindir,ACCESS_EXISTS)) {
	    int err = errno;
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmNoBinMapDir,
			      "Unidata: no map-bin-dir exist: %s: %s"),
		      map_bindir,error_description(err));
	    
	    /* No error counter incrementging because 
	       map-bin-dir can be modified only on system 
	       elm.rc
	    */
	}
	elm_sfprintf(unidata_path,sizeof unidata_path,
		     FRM("%s/%s"),
		     map_bindir,raw_unidata_path);
	
    } else
	do_expand_meta("unidata", unidata_path, raw_unidata_path,
		       sizeof(unidata_path));
    
    map_system_charset(display_locale);
    
    /* Current display charset is locale charset */
    display_charset = system_charset;
    
    if (!special_charset_keyword(raw_text_charset)) {
	char buffer[LONG_STRING];
	if (!get_charset_map_info(buffer,raw_text_charset, 
				  sizeof buffer))
	    do_expand_env("text-charset", buffer, 
			  raw_text_charset, 
			  sizeof(buffer));
	text_charset = MIME_name_to_charset(buffer,1);
	if (!(CS_mapping & charset_properties(text_charset))) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmUnknownTextCharset,
			      "text-charset %s is unknown, conversion to text-charset does not work"),
		      text_charset->MIME_name);
	    strfcpy(raw_text_charset,"DISPLAY",sizeof raw_text_charset);
	    text_charset = display_charset;
	} 
    } 
    
    if (!special_charset_keyword(raw_display_charset)) {
	char buffer[LONG_STRING];
	if (!get_charset_map_info(buffer,raw_display_charset, 
				  sizeof buffer))
	    do_expand_env("display-charset", buffer, 
			  raw_display_charset, 
			  sizeof(buffer));
	wanted_display_charset = MIME_name_to_charset(buffer,1);
	if (!(CS_mapping & charset_properties(wanted_display_charset))) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnknownDisplayCharset,
			      "display-charset %s is unsupported, charset switching does not work"),
		      wanted_display_charset->MIME_name ? 
		      wanted_display_charset->MIME_name :
		      "<no MIME name>");
	    strfcpy(raw_display_charset,"SYSTEM",
		    sizeof raw_display_charset);
	    wanted_display_charset = system_charset;		
	}
    }

    if (!special_charset_keyword(raw_local_fs_charset)) {
	char buffer[LONG_STRING];
	if (!get_charset_map_info(buffer,raw_local_fs_charset,
				  sizeof buffer))
	    do_expand_env("local-fs-charset", buffer, 
			  raw_local_fs_charset, 
			  sizeof(buffer));
	local_fs_charset = MIME_name_to_charset(buffer,1);
	if (!(CS_mapping & charset_properties(local_fs_charset))) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnknownFSCharset,
			      "local-fs-charset %s is unsupported, file access does not work"),
		      local_fs_charset->MIME_name ? 
		      local_fs_charset->MIME_name :
		      "<no MIME name>");
	    strfcpy(raw_local_fs_charset,"SYSTEM",
		    sizeof raw_local_fs_charset);
	    local_fs_charset = system_charset;		
	}
    }
    
    if (!special_charset_keyword(raw_default_nomime_charset)) {
	char buffer[LONG_STRING];
	if (!get_charset_map_info(buffer,raw_default_nomime_charset,
				  sizeof buffer))
	    do_expand_env("default-nomime-charset", buffer, 
			  raw_default_nomime_charset, 
			  sizeof(buffer));
	default_nomime_charset = MIME_name_to_charset(buffer,1);
	if (!(CS_mapping & charset_properties(default_nomime_charset))) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnknownDef1Charset,
			      "default-nomime-charset %s is unsupported"),
		      default_nomime_charset->MIME_name ? 
		      default_nomime_charset->MIME_name :
		      "<no MIME name>");
		strfcpy(raw_default_nomime_charset,"SYSTEM",
			sizeof raw_default_nomime_charset);
		default_nomime_charset = system_charset;		
	}
    }
    
#ifdef REMOTE_MBX
    if (!special_charset_keyword(raw_imap_charset)) {
	char buffer[LONG_STRING];
	if (!get_charset_map_info(buffer,raw_imap_charset,
				  sizeof buffer))
	    do_expand_env("imap-charset", buffer, 
			  raw_imap_charset, 
			  sizeof(buffer));
	imap_charset = MIME_name_to_charset(buffer,1);
	if (!(CS_mapping & charset_properties(imap_charset))) {
	    errors++;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnknownIMAPCharset,
			      "imap-charset %s is unsupported"),
		      imap_charset->MIME_name ? 
		      imap_charset->MIME_name :
		      "<no MIME name>");
	    strfcpy(raw_imap_charset,"SYSTEM",
		    sizeof raw_imap_charset);
	    imap_charset = system_charset;		
	}
    }
#endif
    
    post_process_charset_options();
    
    if (!(CS_mapping & charset_properties(system_charset))) {
	/* Don't increment errors variable because this comes
	 * from locale (via mime.charsets) and not from elmrc
	 */
	
	if (system_charset->MIME_name)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnsupportedLocale,
			      "WARNING: Locale %s (charset %s) is unsupported, will cause problems!"), 
		      display_locale,system_charset->MIME_name);
	else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmUnsupportedLocale2,
			      "WARNING: Locale %s is unsupported, will cause problems!"), 
		      display_locale);
	locale_error = 1;
    } 
    
    if (locale_error == 1) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmLocaleProblem,
			  "Problem with locale (system character set)! Elm ME+ will behave erratically."));
	/* Long wait that message will be noticed ... */
#if POLL_METHOD	  
	wait_for_timeout(10);
#else
	sleep(10);
#endif	    
	locale_error++;
    }
    
    if (
	(
	 (wanted_display_charset != system_charset &&	     
	  0 != (CS_mapping & charset_properties(wanted_display_charset)) &&
	  (!wanted_display_charset->MIME_name ||
	   0 != istrcmp(wanted_display_charset->MIME_name,"US-ASCII")) 
#ifndef ASCII_CTYPE
	  && (!wanted_display_charset->MIME_name ||
	      0 != istrcmp(wanted_display_charset->MIME_name,"ISO-8859-1"))
#endif
	  )
	 || allow_charset_switching
	 ) &&
	0 != strcmp(unidata_path,"none")) {
	
	/* We are going to need unidata information --
	   therefore check availivility ! */
	
	if (!default_unidata()) {
	    
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmNoUnicodeData,
			      "No Unicode data available: unidata: %s"),
		      raw_unidata_path);
	    
	    errors++;
	    
	    lib_error(CATGETS(elm_msg_cat, ElmSet,ElmUnidataSetting,
			      "Setting unidata=none, displaycharset=SYSTEM, allow-charset-switching=OFF"));
	    
	    strfcpy(raw_unidata_path,"none",sizeof raw_unidata_path);
	    strfcpy(unidata_path,"none",sizeof unidata_path);
	    
	    strfcpy(raw_display_charset,"SYSTEM", 
		    sizeof raw_display_charset);
	    wanted_display_charset = system_charset;		

	    allow_charset_switching = 0;
	}
	
    }
    
    if (strcmp(raw_metamail_path,"none") == 0 || 
	raw_metamail_path[0] == '\0') {
	strfcpy(raw_metamail_path,"none", sizeof raw_metamail_path);
	strfcpy(metamail_path,"none", sizeof metamail_path);
    } else if(strcmp(raw_metamail_path,"metamail") == 0) {
	if (getenv("NOMETAMAIL"))
	    strfcpy(metamail_path,"none", sizeof metamail_path);
	else
	    strfcpy(metamail_path,"metamail", sizeof metamail_path);
    } else {
	do_expand_env("metamail", metamail_path, raw_metamail_path, 
		      sizeof(metamail_path));
    }

#ifdef USE_PGP
    if (strcmp(raw_pgp2_path,"none") == 0 || 
	raw_pgp2_path[0] == '\0') {
	strfcpy(raw_pgp2_path,"none", sizeof raw_pgp2_path);
	strfcpy(pgp2_path,"none", sizeof pgp2_path);
    } else {
	do_expand_env("pgp2", pgp2_path, raw_pgp2_path, 
		      sizeof(pgp2_path));
    }
    if (strcmp(raw_pgp5_dir,"none") == 0 || 
	raw_pgp5_dir[0] == '\0') {
	strfcpy(raw_pgp5_dir,"none", sizeof raw_pgp5_dir);
	strfcpy(pgp5_dir,"none", sizeof pgp5_dir);
    } else {
	do_expand_env("pgp5", pgp5_dir, raw_pgp5_dir, 
		      sizeof(pgp5_dir));
    }
    if (strcmp(raw_gpg_path,"none") == 0 || 
	raw_gpg_path[0] == '\0') {
	strfcpy(raw_gpg_path,"none", sizeof raw_gpg_path);
	strfcpy(gpg_path,"none", sizeof gpg_path);
    } else {
	do_expand_env("gpg", gpg_path, raw_gpg_path, 
		      sizeof(gpg_path));
    }
    if (pgp_none == send_pgp_version) {
	if ('/' == gpg_path[0]) send_pgp_version = gpg;
	if ('/' == pgp5_dir[0]) send_pgp_version = pgp5;
	if ('/' == pgp2_path[0]) send_pgp_version = pgp2;
    }
#endif
    
#ifdef USE_DLOPEN
    post_init_shared_options(&errors);
#endif
}

static struct rc_save_info_rec * eval_option P_((struct rc_save_info_rec * 
						 rc_options,
						 int          rc_option_count,
						 int lcl,
						 char *word1, 
						 char *word2,
						 char *filename));

void do_rc(file, lcl, filename)
     FILE *file;
     int lcl;
     char *filename;
{
    struct rc_save_info_rec * prev_type = NULL;
    char current_tag[SLEN];

    int ignored = 0;

    int x;
    
    char buffer[LONG_STRING];

    if (!file) 
	return;
    lineno=0;

    current_tag[0] = '\0';

    while (0 < (x = 
		mail_gets(buffer, sizeof buffer, file))) {
	char   * tag         = NULL;
	char   keyword[SLEN], *c;
	char   * rest        = NULL;
	int i;

	lineno++;

	/* remove return */
	if ('\n' == buffer[x -1])
            buffer[x - 1] = '\0';
	else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTooLongLine,
			      "%30s: %d: Too long line: %.30s..."),
		      filename,lineno,buffer);
	    errors ++;
	    break;
	}
	
	if (buffer[0] == '#'        /* comment       */
	    || x < 2)     /* empty line    */
	    continue;
	
	i = 0;
	for (c = buffer; c - buffer < x && i < sizeof keyword; c++) {
	    if ('_' == *c)
		keyword[i++] = '-';
	    else if (!tag && ':' == *c) {
                /* Mark tag from buffer */
		*c = '\0';
		tag = buffer;
		i = 0;
	    } else if (!isascii(*c))
		break;
	    else if (!ok_rc_char(*c))
		break;
	    else {
		keyword[i++] = tolower((unsigned char)*c);
	    }
	}

	keyword[i] = '\0';
	
	while (whitespace(*c)) 
	    c++;

	if ('=' == *c)
	    c++;
	while (whitespace(*c)) 
	    c++;
	rest = c;
	
	if (tag && !keyword[0]) {
	    strfcpy(current_tag, tag, sizeof current_tag);

	    if (rest[0] && '#' != rest[0]) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmIgnoredLine,
				  "Rest of line ignored after \"%s:\" on line %d on file %s"),
			  tag, lineno,filename);
		errors++;
	    }

	} else if (!keyword[0]) {
	    if (prev_type != NULL) {
		
		if (!valid_rc_type(prev_type->dt_type))
		    panic("RC PANIC",__FILE__,__LINE__,"do_rc",
			  "Bad prev_type",0);

		if (!prev_type->dt_type -> 
		    parse_cline(prev_type,
				lcl,
				rest,
				lineno,
				filename))
		    errors++;
	    }
	} else if (tag || current_tag[0]) {
	    struct rc_save_info_rec * rc_options      = NULL;
	    int                     rc_option_count   = 0;

	    if (!tag) 
		tag = current_tag;
	    else
		ignored = 0;


#ifdef USE_DLOPEN
	    if (give_options(tag,&rc_options,&rc_option_count)) {

		prev_type =  eval_option(rc_options,rc_option_count,
					 lcl,keyword,rest,filename);
		ignored = 0;
		
		if (!prev_type) {
		    errors++;
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadKeyTagInElmrc,
				      "I can't understand keyword \"%s\" (section %s) in line %d in \"%s\" file"),
			      keyword, tag,lineno,filename);
		}

	    } else if (!ignored) {
		ignored = 1;

		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmIgnoredSection,
				  "Keywords on section \"%s\" ignored starting from line %d on file %s"),
			  tag, lineno,filename);

	    }
#else
	    if (!ignored) {
		ignored = 1;
		
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSharedIgnoredSection,
				  "Shared libraries not supported. Section \"%s\" ignored starting from line %d on file %s"),
			  tag, lineno,filename);
		errors++;		
	    }
#endif

	} else {
	    prev_type = do_set(lcl, keyword, rest, filename);
	    if (!prev_type) {
		errors++;
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadKeyInElmrc,
				  "I can't understand keyword \"%s\" in line %d in \"%s\" file"),
			  keyword, lineno,filename);
	    }
	}
	
#if 0
	if (x == 0) {
	} else
	    prev_type = x;
#endif

    }
}

/*
 * set the named parameter according to save_info structure.
 * This routine may call itself (DT_SYN or DT_MLT).
 * Also tags params that were set in "local" (personal) RC file
 * so we know to save them back out in "o)ptions" screen.
 * Uses an internal table to decode sort-by params...should be coupled
 * with sort_name(), etc...but...
 */

/* read_rc.c. -- return NULL on failure 
                 otherwise pointer to option
 */


static struct rc_save_info_rec * eval_option (rc_options,rc_option_count,lcl,
					      word1,word2,filename)
     struct rc_save_info_rec * rc_options;
     int                       rc_option_count;
     int lcl;
     char *word1; 
     char *word2;
     char *filename;
{
    int negate = 0;

    int x, y = 0;
    int e_val = 0;
    
    if ('!' == *word1) {
	negate++;
	word1++;
    }

    for (x=0; x < rc_option_count; ++x) {
	y = strcmp(word1, rc_options[x].name);
	if (y <= 0)
	    break;
    }

    if (y != 0)
	return NULL;

    if (rc_options[x].flags & FL_SYS && lcl == LOCAL_RC)
	return NULL;

    if (lcl == LOCAL_RC)
	rc_options[x].flags |= FL_LOCAL;

    if (rc_options[x].e_ptr) {
	int ci = -1, i;
	e_val = 0;    /* First value is 'unknown' */

	for (i = 0; i < rc_options[x].e_ptr->nlen; i++)
	    if (0 == strcmp(rc_options[x].e_ptr->list[i],word2)) {
		e_val = i;
		break;
	    } else if (0 == istrcmp(rc_options[x].e_ptr->list[i],word2))
		ci = i;
	if (!e_val && ci >= 0)
	    e_val = ci;
	
	if (i == rc_options[x].e_ptr->nlen) {
	    char *p;	    
	    if (
		(rc_options[x].dt_type != DT_NUM || 
		 strtol(word2,&p,10) < 0) || *p != '\0'
		) { 
	      
		errors++;
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadEKeyInElmrc,
				  "I can't understand %s key \"%s\" in line %d in \"%s\" file"),
			  word1,word2, lineno,filename);
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadEKeyValues,
				  "Possible values are:"));
		for (i = 0; i < rc_options[x].e_ptr->nlen; i++)
		    lib_error(FRM(" - %s"),
			      rc_options[x].e_ptr->list[i]);
	    }
	}

    } else
	e_val = 0;

    if (!valid_rc_type(rc_options[x].dt_type))
	panic("RC PANIC",__FILE__,__LINE__,"do_set",
	      "Bad config item type",0);

    if (!rc_options[x].dt_type->parse_line(& (rc_options[x]),
					  lcl,
					  word2,
					  lineno,
					  filename,
					  e_val,
					  negate))
	errors++;

    return & (rc_options[x]);
}

struct rc_save_info_rec * do_set(lcl, word1, word2, filename)
     int lcl;
     char *word1, *word2;
     char *filename;
{
    return eval_option(save_info,NUMBER_OF_SAVEABLE_OPTIONS,
		       lcl,word1,word2,filename);
}
	
void weedout(string)
     char *string;
{
	/** This routine is called with a list of headers to weed out.   **/

	char *strptr, *header, *p;
	int Len;
	int finished;

	finished = FALSE;
	strptr = string;
	while (!finished && (header = strtokq(strptr, "\t ,", TRUE)) != NULL) {
	  strptr = NULL;

	  if (!*header)
	    continue;

	  for (p = header; *p; ++p) {
	    if (*p == '_')
	      *p = ' ';
	  }

	  if (! istrcmp(header, "*end-of-user-headers*"))
	    break;

	  if (! istrcmp(header, "*end-of-defaults*"))
	    finished = TRUE;

	  if (! istrcmp(header, "*clear-weed-list*")) {
	    while (weedcount)
	      free(weedlist[--weedcount]);
	    header = "*end-of-defaults*";
	  }

	  if (matches_weedlist(header))
	      continue;

	  if (weedcount > MAX_IN_WEEDLIST) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTooManyWeedHeaders,
			      "Too many weed headers!  Leaving..."));
	    exit(1);
	  }
	  Len = strlen(header) + 1;
	  if ((p = malloc(Len)) == NULL) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTooManyWeedPmalloc,
			      "Too many weed headers!  Out of memory!  Leaving..."));
	    exit(1);
	  }
	  strfcpy(p, header, Len);
	  weedlist[weedcount++] = p;
	}
}

void alternatives(string)
     char *string;
{
	/** This routine is called with a list of alternative addresses
	    that you may receive mail from (forwarded) **/

	char *strptr, *address;
	struct addr_rec *current_record, *previous_record;

	previous_record = alternative_addresses;	/* start 'er up! */
	/* move to the END of the alternative addresses list */

	if (previous_record != NULL)
	  while (previous_record->next != NULL)
	    previous_record = previous_record->next;

	strptr = (char *) string;

	while ((address = strtok(strptr, "\t ,\"'")) != NULL) {
	  if (previous_record == NULL) {
	    previous_record = (struct addr_rec *) pmalloc(sizeof 
		*alternative_addresses);

	    strfcpy(previous_record->address, address,
		    sizeof previous_record->address);
	    previous_record->next = NULL;
	    alternative_addresses = previous_record;
	  }
	  else {
	    current_record = (struct addr_rec *) pmalloc(sizeof 
		*alternative_addresses);
	  
	    strfcpy(current_record->address, address,
		    sizeof current_record->address);
	    current_record->next = NULL;
	    previous_record->next = current_record;
	    previous_record = current_record;
	  }
	  strptr = (char *) NULL;
	}
}

static void default_weedlist()
{
	/** Install the default headers to weed out!  Many gracious 
	    thanks to John Lebovitz for this dynamic method of 
	    allocation!
	**/

	static char *default_list[] = { ">From", "In-Reply-To:",
		       "References:", "Newsgroups:", "Received:",
		       "Apparently-To:", "Message-Id:", "Content-Type:",
		       "Content-Length", "MIME-Version",
		       "Content-Transfer-Encoding",
		       "From", "X-Mailer:", "Status:",
		       "X-ELM-",
		       "X-UIDL", /* Generated by some POP deamons */ 
		       "Return-Path",
		       "*end-of-defaults*", NULL
		     };

	for (weedcount = 0; default_list[weedcount] != (char *) 0;weedcount++){
	  int Len = strlen(default_list[weedcount]) + 1;
	  if ((weedlist[weedcount] = 
	      malloc(Len)) == NULL) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoMemDefaultWeed,
			      "Not enough memory for default weedlist. Leaving."));
	     (*safe_malloc_fail_handler)("default_weedlist", Len);
	     return;
	  }
	  strfcpy(weedlist[weedcount], default_list[weedcount], Len);
	}
}

int matches_weedlist(buffer)
     char *buffer;
{
	/** returns true iff the first 'n' characters of 'buffer' 
	    match an entry of the weedlist **/
	
	register int i;

	for (i=0;i < weedcount; i++)
	  if (strincmp(buffer, weedlist[i], strlen(weedlist[i])) == 0) 
	    return(1);

	return(0);
}

extern int is_it_on(word)
     char *word;
{
    /** Returns TRUE if the specified word is either 'ON', 'YES'
	or 'TRUE', and FALSE otherwise.   We explicitly translate
	to lowercase here to ensure that we have the fastest
	routine possible 
    **/

    char mybuffer[NLEN];
    int i, j;

    for (i=0, j=0; word[i] != '\0'; i++)
#ifdef ASCII_CTYPE
	if (isascii(word[i]))
#endif
	    mybuffer[j++] = tolower((unsigned char)word[i]);
    mybuffer[j] = '\0';

    return(  (strncmp(mybuffer, "on",   2) == 0) ||
	     (strncmp(mybuffer, "yes",  3) == 0) ||
	     (strncmp(mybuffer, "true", 4) == 0)
	     );
}

char * mode_to_str(mode)
     int mode;
{
	static char modestr[9+1];	/* "rwxrwxrwx\0" */
	char *s = &modestr[0];
	char *modecharp = "rwxrwxrwx";
	int modebit = 0400;

	while (modebit != 0) {
	    if (mode & modebit)
	        *s++ = *modecharp;
	    else
		*s++ = '-';
	    modecharp++;
	    modebit >>= 1;
	}
	*s = '\0';
	return(modestr);
}

int null_option_func(value,enter)
     char **value; 
     int enter;
{
    return 0;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
