static char rcsid[] = "@(#)$Id: sb_mem.c,v 1.3 2000/06/14 15:40:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "s_me.h"
#include "sb_imp.h"

static int sb_init_mem P_((struct stringbuffer *buffer));
static int sb_init_mem(buffer)
     struct stringbuffer *buffer;
{
    buffer->p->a.mem.string_count = 0;
    buffer->p->a.mem.strings      = NULL;
    return 1;
}

static void sb_free_mem P_((struct stringbuffer *buffer));
static void sb_free_mem(buffer)
     struct stringbuffer *buffer;
{
    int i;

    for (i = 0; i < buffer->p->a.mem.string_count; i++)
	if (buffer->p->a.mem.strings[i])
	    free_string(&(buffer->p->a.mem.strings[i]));
    if (buffer->p->a.mem.strings)
	free(buffer->p->a.mem.strings);
    buffer->p->a.mem.strings      = NULL;
    buffer->p->a.mem.string_count = 0;
}

static void sb_add_line_to_mem P_((struct stringbuffer *buffer,
				   const struct string *string));
static void sb_add_line_to_mem(buffer,string)
     struct stringbuffer *buffer;
     CONST struct string *string;
{
    int ptr = buffer->p->a.mem.string_count;
    
    buffer->p->a.mem.strings = safe_realloc(buffer->p->a.mem.strings,
					    (buffer->p->a.mem.string_count+1) *
					    sizeof (struct string *));
    buffer->p->a.mem.strings[ptr] = dup_string(string);
    buffer->p->a.mem.string_count++;
}

static int sb_linecount_mem P_((const struct stringbuffer *ptr));
static int sb_linecount_mem(ptr)
     CONST struct stringbuffer *ptr;
{
    return ptr->p->a.mem.string_count;
}

static struct string *sb_get_line_from_mem P_((const struct 
					       stringbuffer *buffer,
					       int ptr));
static struct string *sb_get_line_from_mem(buffer,ptr)
     CONST struct stringbuffer *buffer;
     int ptr;
{
    if (ptr < 0 || ptr >= buffer->p->a.mem.string_count)
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"sb_get_line_from_mem",
	      "Bad index",0);
    return dup_string(buffer->p->a.mem.strings[ptr]);

}

struct sb_type   sb_in_mem = {
    sb_init_mem,
    sb_free_mem,
    sb_add_line_to_mem,
    sb_linecount_mem,
    sb_get_line_from_mem
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

