static char rcsid[] = "@(#)$Id: shared.c,v 1.26 2001/06/17 14:01:15 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.26 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

/*
 * This file is compiled only if dlopen() is available, so
 * that file does not need to be guarded with #ifdef 
 */

#include "headers.h"

DEBUG_VAR(Debug,__FILE__,"dl");

#include "../shared_libs/include/shared.h"
#include "shared_imp.h"
#include "mbx_imp.h"
#include "save_opts.h"
#include "rc_imp.h"
#include "s_me.h"

#include <errno.h>
extern int errno;

static enum CAPA_phase pri_to_phase P_((int pri));
static enum CAPA_phase pri_to_phase(pri)
     int pri;
{
    
    if (pri < 10)
	return capa_prelogin;
    if (pri < 20)
	return capa_do_login;
    return capa_logged;
}

struct shared_CT * shared_connection_types       = NULL;
int                shared_connection_type_count  = 0;

struct shared_FT * shared_folder_types           = NULL;
int shared_folder_type_count                     = 0;

struct shared_ST * shared_stream_types           = NULL;
int   shared_stream_type_count                   = 0;

static struct shared_POP_CAPA {
    char                * capa;
    int                   priority;
    int                   imp_idx;
    pop_capa_handler     *capa_handler;
} * shared_pop_capas                             = NULL;
static int shared_pop_capa_count                 = 0;

static struct shared_IMAP_CAPA {
    char                * capa;
    int                   priority;
    int                   imp_idx;
    imap_capa_handler     *capa_handler;
} * shared_imap_capas                             = NULL;
static int shared_imap_capa_count                 = 0;

struct shared_SEOT  * shared_SE_option_types      = NULL;
int                   shared_SE_option_type_count = 0;

struct shared_RCT * shared_RC_types             = NULL;
int                 shared_RC_type_count        = 0;


int use_sharedfunc P_((char **value, int enter));

static struct ImpInfo {
    int valid;
    char * tag;
    char * shname;
    int lists_updated;

    void * handle;

    struct rc_save_info_rec * rc_options;
    int                       rc_option_count;

    RC_post_init_f          * rc_post_init;
    wants_rand_bits_f       * wants_rand_bits;

} *        use_library_list = NULL;
static int use_library_list_count = 0; 

static char * give_shname P_((const char *tag));
 
static char * give_shname(tag)
     CONST char *tag;
{
    char * ret = elm_message(FRM("%s/%s%s%s"),
			     SHARED_DIR,
			     SHARED_LIBPREFIX,
			     tag,
			     SHARED_LIBSUFFIX);

    DPRINT(Debug,4,(&Debug,"use-library %s => %s\n",tag,ret));

    return ret;				 
}

static RC_post_init_f no_rc_post_init;
static void no_rc_post_init(errors)
     int *errors;
{
    /* Nothing */
}

static wants_rand_bits_f no_wants_rand_bits;
static void no_wants_rand_bits (buf,size,entropy_bits)
     const char *buf; 
     int size;
     int entropy_bits;
{
    /* Nothing */
}

static struct ImpInfo * give_impinfo P_((const char * tag));
static struct ImpInfo * give_impinfo(tag)
     CONST char * tag;
{
    int i;

    for (i = 0; i < use_library_list_count; i++) {
	if (0 == strcmp(use_library_list[i].tag,tag))
	    return &(use_library_list[i]);
    }

    use_library_list = safe_realloc(use_library_list, 
				  (i+1) * sizeof(use_library_list[0]));

    use_library_list[i].valid  = 0;
    use_library_list[i].tag    = safe_strdup(tag);
    use_library_list[i].shname = give_shname(tag);
    
    use_library_list[i].handle = NULL;
    use_library_list[i].lists_updated = 0;

    use_library_list[i].rc_options      = NULL;
    use_library_list[i].rc_option_count = 0;
    use_library_list[i].rc_post_init    = no_rc_post_init;

    use_library_list[i].wants_rand_bits = no_wants_rand_bits;

    use_library_list_count = i+1;
    return &(use_library_list[i]);
}

static void load_code P_((int idx));
static void load_code(idx)
     int idx;
{

    if (!use_library_list[idx].handle) {

	DPRINT(Debug,4,(&Debug,"use-library[%d] - loading %s\n",
			idx, use_library_list[idx].shname));

	use_library_list[idx].handle = 
	    dlopen(use_library_list[idx].shname,RTLD_NOW);

	if (!use_library_list[idx].handle) {
	    lib_error(CATGETS(elm_msg_cat, MeSet,
			      MeDLopenError,
			      "use-library: %s: %s: %s"),
		      use_library_list[idx].tag,
		      use_library_list[idx].shname,
		      dlerror());
	    use_library_list[idx].valid = 0;
	    return;
	}
    }

    if (!use_library_list[idx].lists_updated) {

	/* union hack to avoid warnings about casting
         * between pointer-to-object and pointer-to-function
	 */

	union F1 {
	    void *                 ptr;
	    provides_shared_CT_f * f1;
	} f1;

	union F2 {
	    void *                 ptr;
	    provides_shared_FT_f * f2;
	} f2;

	union F3 {
	    void *                 ptr;
	    provides_shared_ST_f * f3;
	} f3;

	union F4 {
	    void *                       ptr;
	    provides_shared_POP_CAPA_f * f4;
	} f4;

	union F5 {
	    void *                       ptr;
	    provides_shared_IMAP_CAPA_f * f5;
	} f5;

	union F6 {
	    void *                       ptr;
	    provides_shared_SEOT_f     * f6;
	} f6;

	union F7 {
	    void *                       ptr;
	    provides_shared_RCT_f      * f7;
	} f7;

	union F8 {
	    void *                       ptr;
	    provides_RC_options_f      * f8;
	} f8;

	union F9 {
	    void *                       ptr;
	    RC_post_init_f             * f9;
	} f9;

	union F10 {
	    void *                       ptr;
	    wants_rand_bits_f          * f10;
	} f10;

	f1.ptr = dlsym(use_library_list[idx].handle,  "provides_shared_CT");
        f2.ptr = dlsym(use_library_list[idx].handle,  "provides_shared_FT");
	f3.ptr = dlsym(use_library_list[idx].handle,  "provides_shared_ST");
	f4.ptr = dlsym(use_library_list[idx].handle, 
		       "provides_shared_POP_CAPA");
	f5.ptr = dlsym(use_library_list[idx].handle,
		       "provides_shared_IMAP_CAPA");
        f6.ptr = dlsym(use_library_list[idx].handle,  "provides_shared_SEOT");
	f7.ptr = dlsym(use_library_list[idx].handle,  "provides_shared_RCT");
	f8.ptr = dlsym(use_library_list[idx].handle,  "provides_RC_options");
	f9.ptr  = dlsym(use_library_list[idx].handle,  "RC_post_init");
	f10.ptr = dlsym(use_library_list[idx].handle,  "wants_rand_bits");

	if (!f1.f1) {
	    DPRINT(Debug,7,(&Debug," ... NO provides_shared_CT\n"));
	}
	if (!f2.f2) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_FT\n"));
	}
	if (!f3.f3) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_ST\n"));
	}
	if (!f4.f4) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_POP_CAPA\n"));
	}
	if (!f5.f5) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_IMAP_CAPA\n"));
	}
	if (!f6.f6) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_SEOT\n"));
	}
	if (!f7.f7) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_shared_RCT\n"));
	}
	if (!f8.f8) {
	    DPRINT(Debug,7,(&Debug, " ... NO provides_RC_options\n"));
	}
	if (!f9.f9) {
	   DPRINT(Debug,7,(&Debug, " ... NO RC_post_init\n"));
	}
	if (!f10.f10) {
	    DPRINT(Debug,7,(&Debug, " ... NO wants_rand_bits\n"));
	}

	if (f1.f1) {
	    int count,x;
	    size_t   s_res1;
	    struct provides_shared_CT * res1 = f1.f1(&count, &s_res1);

	    if (s_res1 != sizeof (*res1)) {
		DPRINT(Debug,1,(&Debug,"... provides_shared_CT mismatch\n"));
	    } else {
		shared_connection_types = 
		    safe_realloc(shared_connection_types,
				 sizeof (shared_connection_types[0]) *
				 (shared_connection_type_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_connection_types[shared_connection_type_count
					   +x].T = res1[x].T;
#if 0
		    shared_connection_types[shared_connection_type_count
					   +x].portnum = res1[x].portnum;
#endif
		    shared_connection_types[shared_connection_type_count
					   +x].imp_idx = idx;
		}
		shared_connection_type_count += count;
	    }
	}

	if (f2.f2) {
	    int count,x;
	    size_t   s_res2;
	    struct provides_shared_FT * res2 = f2.f2(&count, &s_res2);

	    if (s_res2 != sizeof (*res2)) {
		DPRINT(Debug,1,(&Debug,"... provides_shared_FT mismatch\n"));
	    } else {
		shared_folder_types = 
		    safe_realloc(shared_folder_types,
				 sizeof (shared_folder_types[0]) *
				 (shared_folder_type_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_folder_types[shared_folder_type_count
				       +x].T = res2[x].T;
#if 0
		    shared_folder_types[shared_folder_type_count
				       +x].portnum = res2[x].portnum;
#endif
		    shared_folder_types[shared_folder_type_count
				       +x].imp_idx = idx;
		}
		shared_folder_type_count += count;
	    }
	}

	if (f3.f3) {
	    int count,x;
	    size_t   s_res3;
	    struct provides_shared_ST * res3 = f3.f3(&count, &s_res3);

	    if (s_res3 != sizeof (*res3)) {
		DPRINT(Debug,1,(&Debug,"... provides_shared_ST mismatch\n"));
	    } else {
		shared_stream_types = 
		    safe_realloc(shared_stream_types,
				 sizeof (shared_stream_types[0]) *
				 (shared_stream_type_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_stream_types[shared_stream_type_count
				       +x].T = res3[x].T;
		    shared_stream_types[shared_stream_type_count
				       +x].imp_idx = idx;
		}
		shared_stream_type_count += count;
	    }
	}

	if (f4.f4) {
	    int count,x;
	    size_t   s_res4;
	    struct provides_shared_POP_CAPA * res4 = f4.f4(&count, &s_res4);

	    if (s_res4 != sizeof (*res4)) {
		DPRINT(Debug,1,(&Debug,
				"... provides_shared_POP_CAPA mismatch\n"));
	    } else {
		shared_pop_capas = 
		    safe_realloc(shared_pop_capas,
				 sizeof (shared_pop_capas[0]) *
				 (shared_pop_capa_count + count));
	    
		for (x = 0; x < count; x++) {
		    shared_pop_capas[shared_pop_capa_count
				    +x].capa = res4[x].capa;
		    shared_pop_capas[shared_pop_capa_count
				    +x].priority = res4[x].priority;
		    shared_pop_capas[shared_pop_capa_count
				    +x].capa_handler = res4[x].capa_handler;
		    shared_pop_capas[shared_pop_capa_count
				    +x].imp_idx = idx;
		    DPRINT(Debug,8,(&Debug,
				    "use-library[%d] %s provides POP %s\n", 
				    idx,use_library_list[idx].shname,
				    res4[x].capa));
		}
		shared_pop_capa_count += count;
	    }
	}
	    
	if (f5.f5) {
	    int count,x;
	    size_t   s_res5;
	    struct provides_shared_IMAP_CAPA * res5 = f5.f5(&count, &s_res5);
	    
	    if (s_res5 != sizeof (*res5)) {
		DPRINT(Debug,1,(&Debug,
				"... provides_shared_IMAP_CAPA mismatch\n"));
	    } else {
		shared_imap_capas = 
		    safe_realloc(shared_imap_capas,
				 sizeof (shared_imap_capas[0]) *
				 (shared_imap_capa_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_imap_capas[shared_imap_capa_count
				     +x].capa = res5[x].capa;
		    shared_imap_capas[shared_imap_capa_count
				     +x].priority = res5[x].priority;
		    shared_imap_capas[shared_imap_capa_count
				     +x].capa_handler = 
			res5[x].capa_handler;
		    shared_imap_capas[shared_imap_capa_count
				     +x].imp_idx = idx;
		    DPRINT(Debug,8,(&Debug,
				    "use-library[%d] %s provides IMAP %s\n", 
				    idx,use_library_list[idx].shname,
				    res5[x].capa));
		}
		shared_imap_capa_count += count;
	    }
	}	    

	if (f6.f6) {
	    int count,x;
	    size_t   s_res6;
	    struct provides_shared_SEOT * res6 = f6.f6(&count, &s_res6);

	    if (s_res6 != sizeof (*res6)) {
		DPRINT(Debug,1,(&Debug,"... provides_shared_SEOT mismatch\n"));
	    } else {
		shared_SE_option_types = 
		    safe_realloc(shared_SE_option_types,
				 sizeof (shared_SE_option_types[0]) *
				 (shared_SE_option_type_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_SE_option_types[shared_SE_option_type_count
					  +x].T = res6[x].T;
		    shared_SE_option_types[shared_SE_option_type_count
					  +x].imp_idx = idx;
		}
		shared_SE_option_type_count += count;
	    }
	}

	if (f7.f7) {
	    int count,x;
	    size_t   s_res7;
	    struct provides_shared_RCT * res7 = f7.f7(&count, &s_res7);

	    if (s_res7 != sizeof (*res7)) {
		DPRINT(Debug,1,(&Debug,"... provides_shared_RCT mismatch\n"));
	    } else {
		shared_RC_types = 
		    safe_realloc(shared_RC_types,
				 sizeof (shared_RC_types[0]) *
				 (shared_RC_type_count + count));
		
		for (x = 0; x < count; x++) {
		    shared_RC_types[shared_RC_type_count+x].T = res7[x].T;
		    shared_RC_types[shared_RC_type_count+x].imp_idx = idx;
		}
		shared_RC_type_count += count;
	    }
	}

	if (f8.f8) {
	    int count;
	    size_t   s_res8;
	    struct rc_save_info_rec * res8 = f8.f8(&count, &s_res8);

	    if (s_res8 != sizeof (*res8)) {
		DPRINT(Debug,1,(&Debug,"...  rc_save_info_rec mismatch\n"));
	    } else {
		use_library_list[idx].rc_options      = res8;
		use_library_list[idx].rc_option_count = count;
	    }
	}

	if (f9.f9)
	    use_library_list[idx].rc_post_init  = f9.f9;
	
	if (f10.f10)
	    use_library_list[idx].wants_rand_bits = f10.f10;

	use_library_list[idx].lists_updated = 1;
    }

    /* TODO: Other bookkeeping */

}

static void unload_code P_((int idx));
static void unload_code(idx)
     int idx;
{

    /* TODO: Other bookkeeping */

    if (use_library_list[idx].handle) {

	DPRINT(Debug,4,(&Debug,"use-library[%d] - unloading %s\n",
			idx,use_library_list[idx].shname));


	dlclose(use_library_list[idx].handle);
	use_library_list[idx].handle = NULL;
    }
}

static int tag_ok P_((CONST char *name));
static int tag_ok(name)
     CONST char *name;
{
    if ('\0' == *name)
	return 0;

    if (strspn(name,"abcdefghijklmnopqrstuvwxyz") < 3)
	return 0;

    return strlen(name) == 
	strspn(name,
	       "abcdefghijklmnopqrstuvwxyz0123456789-");
}

static int libraries_loaded = 0;


static int locate_and_load_library P_((const char *prefix));
static int locate_and_load_library(prefix)
     CONST char *prefix;
{
    int i;

    for (i = 0; i < use_library_list_count; i++) {
	if (0 == strcmp(use_library_list[i].tag,prefix)) {
	    
	    /* Do not update libraries_loaded
	       because this loads only onen library 
	    */
	    if (use_library_list[i].valid &&
		!libraries_loaded)
		load_code(i);

	    return i;
	}
    }
    return -1;
}

static void load_shared_libs P_((void));
static void load_shared_libs() 
{
    int i;

    if (libraries_loaded)
	return;

    for (i = 0; i < use_library_list_count; i++) {
	if (use_library_list[i].valid)
	    load_code(i);
    }
    libraries_loaded = 1;
}

int use_sharedfunc(value,enter)
     char **value; 
     int enter;
{
    int ret = 1;

    if (enter) {
	char * temp = safe_strdup(*value);
	char * p;

	int i;
	for (i = 0; i < use_library_list_count; i++) 
	    use_library_list[i].valid = 0;

	for (p = strtok(temp," "); p; p = strtok(NULL," ")) {
	    if (!tag_ok(p)) {
		lib_error(CATGETS(elm_msg_cat, MeSet,
				  MeInvalidUseLib,
				  "use-library: %s: Invalid name"),
			  p);
		ret = 0;
		
	    } else {
		struct ImpInfo * I = give_impinfo(p);

		/* We do not load code here with dlopen, because we
		   cant load code only when it is needed.
		*/
		if (0 == access(I->shname,ACCESS_EXISTS)) {
		    I->valid = 1;
		    libraries_loaded = 0;     /* Rescan... */
		} else {
		    int err = errno;

		    lib_error(CATGETS(elm_msg_cat, MeSet,
				      MeNonExistUseLib,
				      "use-library: %s: %s: %s"),
			      I->tag,I->shname,
			      error_description(err));
		    ret = 0;
		}
	    }
	}

	/* Unload possible loaded but no longer valid... */
	for (i = 0; i < use_library_list_count; i++) {
	    if (!use_library_list[i].valid) 
		unload_code(i);
	}

	free(temp);
    } else {
	int i;

	/* static pointer to buffer accross invocations */
        static char * return_buffer = NULL;

        return_buffer = strmcpy(return_buffer,"");    /* Reset result */

	for (i = 0; i < use_library_list_count; i++) {
	    if (use_library_list[i].valid) {

		if (return_buffer[0])
		    return_buffer = strmcat(return_buffer," ");
		
		return_buffer = strmcat(return_buffer,
					use_library_list[i].tag);
	    }
	}	    
	*value = return_buffer;		
    }

    return ret;
}

struct POP_capa_libs {
    char                 * capa;
    char                 * capa_args;
    int                    imp_idx;
    int                    priority;
    pop_capa_handler     * capa_handler;
};

void probe_pop_capa_lib(pop_capa_libs,pop_capa_libcount,capa,capa_args)
     struct POP_capa_libs * *pop_capa_libs;
     int                  * pop_capa_libcount;
     const char *capa;
     const char *capa_args;
{
    int i;

    load_shared_libs();

    for (i = 0; i < shared_pop_capa_count; i++) {
	/* rfc2449: CAPA response tags are case-insensitive. */
	if ( 0 == istrcmp(shared_pop_capas[i].capa, capa) &&
	     /* Also check that librrary is currently loaded ... */
	     NULL != use_library_list[shared_pop_capas[i].imp_idx].handle)
	    break;	
    }
    if (i >= shared_pop_capa_count)
	return;          /* Not found */

    *pop_capa_libs = safe_realloc(*pop_capa_libs,
				  (*pop_capa_libcount +1) *
				  sizeof ((*pop_capa_libs)[0]));

    (*pop_capa_libs)[*pop_capa_libcount].capa      = safe_strdup(capa);
    
    (*pop_capa_libs)[*pop_capa_libcount].capa_args = 
	capa_args ? safe_strdup(capa_args) : NULL;
    (*pop_capa_libs)[*pop_capa_libcount].imp_idx   = 
	shared_pop_capas[i].imp_idx;
    (*pop_capa_libs)[*pop_capa_libcount].priority  = 
	shared_pop_capas[i].priority;
    (*pop_capa_libs)[*pop_capa_libcount].capa_handler =
	shared_pop_capas[i].capa_handler;

    DPRINT(Debug,7,(&Debug,
		    "** Using %s library for POP capacity %s\n",
		    use_library_list[shared_pop_capas[*pop_capa_libcount].
				    imp_idx].tag,
		    (*pop_capa_libs)[*pop_capa_libcount].capa));

    (*pop_capa_libcount)++;		
}

static int pop_capa_compare P_((const void *A, const void *B));
static int pop_capa_compare(A,B)
     CONST void *A; 
     CONST void *B;
{
    CONST struct POP_capa_libs *A1 = A;
    CONST struct POP_capa_libs *B1 = B;

    if (A1->priority < B1->priority)
	return -1;
    if (A1->priority > B1->priority)
	return 1;
    return 0;
}

int handle_pop_capa_libs(folder,pop_capa_libs,pop_capa_libcount,phase,commands)
     struct folder_info *folder;
     struct POP_capa_libs * *pop_capa_libs;
     int                  * pop_capa_libcount;
     enum CAPA_phase      *  phase;
     struct pop_callbacks *commands;
{
    int ret = 1;
    struct remote_account * A;
    enum CAPA_phase  old_phase = *phase;

    if (!folder->p ||
	folder->folder_type != &pop_mbx) 
	panic("CONNECTION PANIC",__FILE__,__LINE__,"handle_pop_capa_libs",
	      "Not a POP connection",0);
        
    A = &(folder->p->a.pop_mbx.C);
    
    if (*pop_capa_libs) {
	int i;
	qsort(*pop_capa_libs,*pop_capa_libcount,
	      sizeof ((*pop_capa_libs)[0]),
	      pop_capa_compare);

	
	for (i = 0; i < *pop_capa_libcount; i++) {
	    struct SE_option       *config = NULL;
	    struct SE_option_type  *T      = NULL;
	    int j;

	    if (*phase != pri_to_phase((*pop_capa_libs)[i].priority))
		continue;

	    DPRINT(Debug,8,(&Debug,
			    "[%d] handling %s with %s library\n",
			    i,(*pop_capa_libs)[i].capa,
			    use_library_list[shared_pop_capas[i].
					    imp_idx].tag));

	    for (j = 0; j < shared_SE_option_type_count; j++) {
		if (shared_SE_option_types[j].imp_idx ==
		    shared_pop_capas[j].imp_idx) {
		    T = shared_SE_option_types[j].T;
		    DPRINT(Debug,8,(&Debug,
				    "  ... have service option type %p\n",
				    T));
		}
	    }

	    if (A->service_idx >= 0 && T) {
		if (A->service_idx >= service_count) 
		    panic("CONNECTION PANIC",__FILE__,__LINE__,
			  "handle_pop_capa_libs",
			  "Bad service index",0);
		
		for (j = 0; 
		     j < service_list[A->service_idx].option_count; 
		     j++) {
		    if (service_list[A->service_idx].
			option_list[j].type == T) {
			config = & (service_list[A->service_idx].
				    option_list[j]);
			DPRINT(Debug,8,(&Debug,
					"  ... have service config %p (%s)\n",
					config,
					config->prefix ? config->prefix : "NONE"));
		    }
		}		
	    }


	    if (!(*pop_capa_libs)[i].
		capa_handler(folder,
			     (*pop_capa_libs)[i].capa,
			     (*pop_capa_libs)[i].capa_args,
			     sizeof (*folder),
			     commands,
			     sizeof (*commands),
			     config,
			     sizeof (*config),
			     phase)) {
		ret = 0;
		goto fail;
	    }

	    if (*phase != old_phase) {
		DPRINT(Debug,8,(&Debug," ... done (phase changed)\n"));
		break;
	    }
	}

    fail:
	free(*pop_capa_libs);
	*pop_capa_libs     = NULL;
	*pop_capa_libcount = 0;
    }
    return ret;
}

struct IMAP_capa_libs {
    char                 *  capa;
    int                     imp_idx;
    int                     priority;
    imap_capa_handler     * capa_handler;
};

void probe_imap_capa_lib(imap_capa_libs,imap_capa_libcount,capa)
     struct IMAP_capa_libs * *imap_capa_libs;
     int                  * imap_capa_libcount;
     const char *capa;
{
    int i;

    load_shared_libs();
    
    for (i = 0; i < shared_imap_capa_count; i++) {
	/* rfc2460:  (Syntax) Except as noted otherwise, 
	   all alphabetic characters are caseinsensitive.
	*/
	if ( 0 == istrcmp(shared_imap_capas[i].capa, capa) &&
	     /* Also check that library is currently loaded ... */
	     NULL != use_library_list[shared_imap_capas[i].imp_idx].handle)
	    break;	
    }
    if (i >= shared_imap_capa_count)
	return;          /* Not found */
    
    *imap_capa_libs = safe_realloc(*imap_capa_libs,
				   (*imap_capa_libcount +1) *
				   sizeof ((*imap_capa_libs)[0]));

    (*imap_capa_libs)[*imap_capa_libcount].capa      = safe_strdup(capa);
    
    (*imap_capa_libs)[*imap_capa_libcount].imp_idx   = 
	shared_imap_capas[i].imp_idx;
    (*imap_capa_libs)[*imap_capa_libcount].priority  = 
	shared_imap_capas[i].priority;
    (*imap_capa_libs)[*imap_capa_libcount].capa_handler =
	shared_imap_capas[i].capa_handler;

    DPRINT(Debug,7,(&Debug,
		    "** Using %s library for IMAP capacity %s\n",
		    use_library_list[shared_imap_capas[*imap_capa_libcount].
				    imp_idx].tag,
		    (*imap_capa_libs)[*imap_capa_libcount].capa));

    (*imap_capa_libcount)++;		

}

static int imap_capa_compare P_((const void *A, const void *B));
static int imap_capa_compare(A,B)
     CONST void *A; 
     CONST void *B;
{
    CONST struct IMAP_capa_libs *A1 = A;
    CONST struct IMAP_capa_libs *B1 = B;

    if (A1->priority < B1->priority)
	return -1;
    if (A1->priority > B1->priority)
	return 1;
    return 0;
}
				
int handle_imap_capa_libs(con,imap_capa_libs,imap_capa_libcount,phase,commands)
     struct connection_cache *con;
     struct IMAP_capa_libs * *imap_capa_libs;
     int                    * imap_capa_libcount;
     enum CAPA_phase        * phase;
     struct imap_callbacks *commands;
{
    int ret = 1;

    struct remote_account * A;
    enum CAPA_phase old_phase = *phase;

    if (con->type != &IMAP_connection) 
	panic("CONNECTION PANIC",__FILE__,__LINE__,"handle_imap_capa_libs",
	      "Not a imap connection",0);
        
    A = &(con->C);


    if (*imap_capa_libs) {
	int i;
	qsort(*imap_capa_libs,*imap_capa_libcount,
	      sizeof ((*imap_capa_libs)[0]),
	      imap_capa_compare);
	
	for (i = 0; i < *imap_capa_libcount; i++) {
	    struct SE_option       *config = NULL;
	    struct SE_option_type  *T      = NULL;
	    int j;
	    
	    if (*phase != pri_to_phase((*imap_capa_libs)[i].priority))
		continue;
	    
	    DPRINT(Debug,8,(&Debug,
			    "[%d] handling %s with %s library\n",
			    i,(*imap_capa_libs)[i].capa,
			    use_library_list[shared_imap_capas[i].
					    imp_idx].tag));

	    for (j = 0; j < shared_SE_option_type_count; j++) {
		if (shared_SE_option_types[j].imp_idx ==
		    shared_pop_capas[j].imp_idx) {
		    T = shared_SE_option_types[j].T;
		    DPRINT(Debug,8,(&Debug,
				    "  ... have service option type %p\n",
				    T));
		}
	    }
	    
	    if (A->service_idx >= 0 && T) {
		if (A->service_idx >= service_count) 
		    panic("CONNECTION PANIC",__FILE__,__LINE__,
			  "handle_pop_capa_libs",
			  "Bad service index",0);
		
		for (j = 0; 
		     j < service_list[A->service_idx].option_count; 
		     j++) {
		    if (service_list[A->service_idx].
			option_list[j].type == T) {
			config = & (service_list[A->service_idx].
				    option_list[j]);
			DPRINT(Debug,8,(&Debug,
					"  ... have service config %p (%s)\n",
					config,
					config->prefix ? config->prefix : 
					"NONE"));
		    }
		}		
	    }

	    if (!(*imap_capa_libs)[i].
		capa_handler(con,
			     (*imap_capa_libs)[i].capa,
			     sizeof (*con),
			     commands,
			     sizeof (*commands),
			     config,
			     sizeof (*config),
			     phase)) {
		ret = 0;
		goto fail;
	    }
	    
	    if (old_phase != *phase) {
		DPRINT(Debug,8,(&Debug," ... done (phase changed)\n"));
		break;
	    }
	}

    fail:
	;
    }

    free_only_imap_capa_libs(imap_capa_libs,imap_capa_libcount);

    return ret;

}


void free_only_imap_capa_libs(imap_capa_libs,imap_capa_libcount)
     struct IMAP_capa_libs * *imap_capa_libs;
     int                  * imap_capa_libcount;
{
    if (*imap_capa_libs) {
	free(*imap_capa_libs);
	*imap_capa_libs     = NULL;
	*imap_capa_libcount = 0;
    }
}

struct SE_option_type * get_option_type(prefix)
     const char *prefix;
{
    int i;
    int idx1 = locate_and_load_library(prefix);

    for (i = 0; i < shared_SE_option_type_count; i++) {
	int idx = shared_SE_option_types[i].imp_idx;

	if (idx1 == idx) {
	    if (!use_library_list[idx].handle) {
		lib_error(CATGETS(elm_msg_cat, MeSet,
                                  MeInvalidOptionTag,
				  "Options %s:* ignored -- code not loaded"),
			  prefix);
		return NULL;
	    }
	    return shared_SE_option_types[i].T;
	}
    }
    lib_error(CATGETS(elm_msg_cat, MeSet,
		      MeInvalidOptionTag,
		      "Options %s:* ignored -- code not loaded"),
	      prefix);
    return NULL;
}


int give_options(tag,rc_options,rc_option_count)
     char *tag;
     struct rc_save_info_rec ** rc_options;
     int                      * rc_option_count;
{
    int idx1 = locate_and_load_library(tag);
    
    *rc_options           = NULL;
    *rc_option_count      = 0;

    if (idx1 < 0 ||
	!use_library_list[idx1].handle) 
	return 0;

    *rc_options       = use_library_list[idx1].rc_options;
    *rc_option_count  = use_library_list[idx1].rc_option_count;

    return 1;
}

static void seed_rand_bits1(const char *buf, int size,
			    int entropy_bits);

static void seed_rand_bits1(buf,size,entropy_bits)
     CONST char *buf; 
     int size;
     int entropy_bits;
{
    int i;

    DPRINT(Debug,10,(&Debug, 
		    "Seeding random generator %d bytes (%d entropy bits)\n",
		    size,entropy_bits));

    if (entropy_bits > size*8)
	panic("SHARED PANIC",__FILE__,__LINE__,"seed_rand_bits1",
	      "Impossible entropy",0);


    /* Only seed libraries which are loaded */

    for (i = 0; i < use_library_list_count; i++) {
	if (use_library_list[i].handle) {
	    /* We should perhaps mangle data so same bits are
	       not given to different modules
	    */
	    use_library_list[i].wants_rand_bits(buf,size,entropy_bits);	    
	}
    }
}

void seed_rand_bits(buf,size,entropy_bits)
     CONST char *buf; 
     int size;
     int entropy_bits;
{
    
    static char buffer[1024];
    static int  byte_count    = 0;
    static int  entropy_count  = 0;
    

    DPRINT(Debug,10,(&Debug, 
		    "Got random generator %d bytes (%d entropy bits)\n",
		    size,entropy_bits));

    if (entropy_bits > size*8)
	panic("SHARED PANIC",__FILE__,__LINE__,"seed_rand_bits",
	      "Impossible entropy",0);

    if (size > sizeof buffer)
	seed_rand_bits1(buf,size,entropy_bits);
    else {

	int i;

	if (size + byte_count > sizeof buffer) {
	    seed_rand_bits1(buffer,byte_count,entropy_count);
	    byte_count = 0;
	    entropy_count = 0;
	}

	/* We can just XOR bits ... */
	for (i = 0; i < size; i++) 
	    buffer[byte_count++] ^= buf[i];

	if (byte_count > sizeof buffer)
	    panic("SHARED PANIC",__FILE__,__LINE__,"seed_rand_bits",
		  "Overflow",0);
	entropy_count += entropy_bits;

	if (entropy_count > 16 && use_library_list_count) {
	    seed_rand_bits1(buffer,byte_count,entropy_count);
	    byte_count = 0;
	    entropy_count = 0;
	}
    }
}

void post_init_shared_options(errors)
     int *errors;
{
    int i;

    /* Only post_init libraries which are loaded
       (other do not have options)
    */

    for (i = 0; i < use_library_list_count; i++) {
	if (use_library_list[i].handle &&
	    use_library_list[i].rc_option_count > 0) {

	    use_library_list[i].rc_post_init(errors);
	}
    }

}


void print_local_shared_options(F)
     FILE *F;
{
    int i;

    /* We want print options of all shared libs */
    load_shared_libs();

    for (i = 0; i < use_library_list_count; i++) {
	if (use_library_list[i].handle &&
	    use_library_list[i].rc_option_count > 0) {
	    int x;
	    
	    fprintf(F,"\n");

	    elm_fprintf(F, 
			CATGETS(elm_msg_cat, MeSet, MeElmrcSection,
				"# Options for %s section (shared library)\n#\n\n"), 
			use_library_list[i].tag);
	    fprintf(F,"%s:\n",
		    use_library_list[i].tag);

	    for (x = 0; x < use_library_list[i].rc_option_count; x++) {
		int local_value;

		/** skip system-only options **/
		if (use_library_list[i].rc_options[x].flags & FL_SYS) {
		    DPRINT(Debug,8,(&Debug,
				    "shlib/option %d -- \"%s\" system-only, flags=%0x\n",
				    x,use_library_list[i].rc_options[x].name, 
				    save_info[x].flags ));
		    continue;
		}

		local_value = 
		    use_library_list[i].rc_options[x].flags & FL_LOCAL;
       
		if (!valid_rc_type(use_library_list[i].rc_options[x].dt_type))
		    panic("RC PANIC",__FILE__,__LINE__,
			  "print_local_shared_options",
			  "Bad config item type",0);

		use_library_list[i].
		    rc_options[x].dt_type->
		    print_value(F,
				& use_library_list[i].rc_options[x],
				!local_value);

	    }
	}	   	
    }
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
