static char rcsid[] = "@(#)$Id: stringbuffer.c,v 1.6 2001/06/03 12:19:22 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "s_me.h"
#include "sb_imp.h"

DEBUG_VAR(Debug,__FILE__,"charset");

#include <errno.h>
extern int errno;

static int valid_magic P_((struct sb_type *magic));

static int valid_magic(magic)
     struct sb_type *magic;
{
    if (&sb_in_mem    == magic ||
	&sb_in_file   == magic)
	return 1;
    return 0;
}


static struct stringbuffer *malloc_buffer P_((struct sb_type *tag));
static struct stringbuffer *malloc_buffer(tag)
     struct sb_type *tag;
{
    struct stringbuffer *ret = safe_malloc(sizeof (struct stringbuffer));

    if (!valid_magic(tag)) 
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"malloc_buffer",
	      "Bad magic number (buffer type)",0);

    /* defined in hdrs/defs.h */
    bzero((void *)ret,sizeof (struct stringbuffer));

    ret->buffer_type         = tag;
    ret->p                   = safe_malloc(sizeof (struct sb_private_data));

    /* defined in hdrs/defs.h */
    bzero((void *)ret->p,sizeof (struct sb_private_data));

    if (!ret->buffer_type->sb_init_it(ret)) {
	DPRINT(Debug,68,(&Debug,
			 "-- failed to init membuffer (type=%p)\n",
			 tag));
	ret->buffer_type->sb_free_it(ret);
	free(ret->p);
	ret->p           = NULL;
	ret->buffer_type = NULL;
	free(ret);
	return NULL;
    }

    return ret;
}

struct stringbuffer * create_membuffer()
{
    struct stringbuffer *ret = malloc_buffer(&sb_in_mem);
    
    if (!ret) {
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"create_membuffer",
	      "Initialization failure",0);	
    }

    DPRINT(Debug,68,(&Debug,
		     "create_membuffer=%p (type=%p)\n",
		     ret,ret->buffer_type));

    return ret;
}

struct stringbuffer * create_filebuffer()
{
    struct stringbuffer *ret = malloc_buffer(&sb_in_file);
    
    if (!ret) {
	int err = errno;
	lib_error(CATGETS(elm_msg_cat, MeSet, MeCantCreaTempFIleUsingMemory,
			  "Sorry, can't create temp file (error: %s) using memory"),
		  error_description(err));
	ret = malloc_buffer(&sb_in_mem);
	if (!ret) 
	    panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"create_membuffer",
		  "Initialization failure",0);	
    }

    DPRINT(Debug,68,(&Debug,
		     "create_membuffer=%p (type=%p)\n",
		     ret,ret->buffer_type));

    return ret;
}



void free_stringbuffer(ptr)
     struct stringbuffer **ptr;
{
    if (!valid_magic((*ptr)->buffer_type)) 
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"free_stringbuffer",
	      "Bad magic number (buffer type)",0);

    DPRINT(Debug,68,(&Debug,
		     "free_stringbuffer(*ptr=%p) (type=%p)\n",
		     (*ptr),(*ptr)->buffer_type));

    (*ptr)->buffer_type->sb_free_it(*ptr);

    free((*ptr)->p);
    (*ptr)->p           = NULL;
    (*ptr)->buffer_type = NULL;
    free(*ptr);
    *ptr = NULL;
}

void add_line_to_stringbuffer(buffer,string)
     struct stringbuffer *buffer;
     CONST struct string *string;
{
    if (!valid_magic(buffer->buffer_type)) 
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,
	      "add_line_to_stringbuffer",
	      "Bad magic number (buffer type)",0);

    DPRINT(Debug,68,(&Debug,
		     "add_line_to_stringbuffer(%p,%p) (type=%p, string type=('%s'; type=%p))\n",
		     buffer,string,
		     buffer->buffer_type,
		     string->string_type->MIME_name ? 
		     string->string_type->MIME_name : "<none>",
		     string->string_type->charset_type));
#if 0
    DPRINT(Debug,69,(&Debug," .... string=%S\n",string));
#endif

    buffer->buffer_type->sb_add_line_to_it(buffer,string);
}

int linecount_stringbuffer(ptr)
     CONST struct stringbuffer *ptr;
{
    int ret;
    if (!valid_magic(ptr->buffer_type)) 
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,"linecount_stringbuffer",
	      "Bad magic number (buffer type)",0);

    ret=ptr->buffer_type->sb_linecount_it(ptr);

    DPRINT(Debug,68,(&Debug,
		     "linecount_stringbuffer(%p)=%d (type=%p)\n",
		     ptr,ret,ptr->buffer_type));

    return ret;
}

struct string *get_line_from_stringbuffer(buffer,ptr)
     CONST struct stringbuffer *buffer;
     int ptr;
{
    struct string *ret;
    if (!valid_magic(buffer->buffer_type)) 
	panic("STRINGBUFFER PANIC",__FILE__,__LINE__,
	      "get_line_from_stringbuffer",
	      "Bad magic number (buffer type)",0);


    ret = buffer->buffer_type->sb_get_line_from_it(buffer,ptr);

    DPRINT(Debug,68,(&Debug,
		     "get_line_from_stringbuffer(%p,%d)=%p (type=%p; string type=('%s'; type=%p))\n",
		     buffer,ptr,ret,
		     buffer->buffer_type,
		     ret->string_type->MIME_name ? 
		     ret->string_type->MIME_name : "<none>",
		     ret->string_type->charset_type));
#if 0
    DPRINT(Debug,69,(&Debug," .... return=%S\n",ret));
#endif

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

