static char rcsid[] = "@(#)$Id: mime.c,v 1.9 2001/06/06 18:09:02 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");

#include <errno.h>

/* Notice that ENCODING_ILLEGAL is -1 
 */

char *mime_encode_names[] = {
    "none", /* Not used. */
    "7bit",
    "8bit",
    "binary",
    "quoted-printable",
    "base64",
    "X-???"         /* ENCODING_EXPERIMENTAL */
};

void mime_panic(f,ln,pr,ms) 
     char * f;
     int ln;
     char *pr;
     char *ms;
{
    panic("MIME PANIC",f,ln,pr,ms,0);
}


int check_encoding(Encoding)
     char *Encoding;
{
    char *c, *d, tmp[VERY_LONG_STRING];
    int result =  ENCODING_ILLEGAL;
    
    DPRINT(Debug,9,(&Debug, 
		    "check_encoding(): Encoding=\"%s\"\n", Encoding));
    
    /* Don't harm "str" */
    strfcpy (tmp, Encoding, sizeof(tmp));
    
    rfc822_reap_comments (tmp, NULL, 0);
    c = tmp;
    d = tmp + strlen(tmp);
    
    while (d > tmp && whitespace(*(d-1)))
	d--;
    *d = '\0';
    while (*c && whitespace(*c))
	c++;
    
    if ('\0' == *c)
	result = ENCODING_7BIT;
    else if (strincmp(c, "x-", 2) == 0) 
	result = ENCODING_EXPERIMENTAL;
    else {
	int i;
	for (i = ENCODING_7BIT; i < ENCODING_EXPERIMENTAL; i++) {
	    if (istrcmp(c, mime_encode_names[i]) == 0) {
		result = i;
		break;
	    }
	}
    }

    DPRINT(Debug,9,(&Debug, 
		    "check_encoding()=%s (%d)\n",
		    ENCODING(result),result));
    return(result);
}

int charset_ok(s)
     char *s;
{
    charset_t ptr = MIME_name_to_charset(s,0);
    if (!ptr)
	return FALSE;   /* Unknow charset so far */
    
    return charset_ok_p(ptr);
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

