static char rcsid[] = "@(#)$Id: parse_util.c,v 1.18 2001/06/09 10:23:55 hurtta Exp $";


/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.18 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"header");

static void header_panic P_((char *,int,char *, char *)); /* Prototype */
static void header_panic(f,ln,pr,ms) 
     char * f;
     int ln;
     char *pr;
     char *ms;
{
     panic("HEADER PANIC",f,ln,pr,ms,0);
}

int read_header_line (fp, buf, size,flag) 
     FILE *fp;
     char *buf;
     int size;
     int flag;
{
  in_state_t state;
  int result;

  in_state_clear(&state,STATE_in_file);

  set_in_state_file(fp,&state);

  result = state_read_hdr_line(&state,buf,size,flag);

  in_state_destroy(&state);

  return result;
}

int state_read_hdr_line (s, buf, size,flag) 
     in_state_t *s;
     char *buf;
     int size;
     int flag;
{
  /* Read and unfold header line -- stores maximum size-1 bytes to buffer
   * (plus \0). Also handle case when headers are eneded either CR LF or LF.
   * Returns number of bytes stored. Always _read_ end of header
   * (even when buffer fills). Returns 0 when reads empty line (only CR LF).
   * That indicates end of headers.
   *
   * If flag & 1 (RHL_MARK_FOLDING) then folding is marked with '\n' 
   * (instead of ' ' and buffer ended with '\n' before '\0'
   * If flag & 2 (RHL_CHECK_HEADER) then check that this was header line...
   */

    int len = 0,c;
    int col_seen = 0;
    long pos = -1;
    
    DPRINT(Debug,12,(&Debug,		    
		     "state_read_hdr_line: size=%d, flag=%d\n",size,flag));
    size--; /* Place for \0 */

    if ( (!in_state_seekable(s) ||
	  (pos = in_state_ftell(s)) < 0) && 
	 (flag & RHL_CHECK_HEADER)) {
	DPRINT(Debug,5,(&Debug,
			"state_read_hdr_line=0; not seekable or ftell failed!"));
	buf[0] = '\0';
	return 0;
    }

#define PUTC(c) { if (len < size) buf[len++] = (c); }
  
  while (EOF != (c = state_getc(s))) {
    if ('\r' == c) {                /* Is this CR LF sequence ? */
      if (EOF == (c = state_getc(s)))
	break;
      if (c != '\n') 
	PUTC('\r');
    }
    if (c == '\n') {                /* Readed CR LF or LF, check folding */
      if (!col_seen && len > 0 && (flag & RHL_CHECK_HEADER)) {
      bad_header_line:
	  DPRINT(Debug,12,(&Debug,
			   "state_read_hdr_line: Not ':' seen. Not a header line!\n"));
	if (0 != in_state_fseek(s,pos)) {
	    DPRINT(Debug,5,(&Debug,
			    "read_header_line: seek failed!\n"));
	}
	len = 0;
      }
      if (len == 0)
	break;                      /* End of headers ! */
      if (EOF == (c = state_getc(s)))
	break;
      if (c != ' ' && c != '\t') {   /* Not a continuation line */
	state_ungetc(c,s);
	break;
      }
      /* CRLF LWSP sequence should be replaced with ' ' */
      c = ' ';
      if (flag & RHL_MARK_FOLDING)
	c = '\n';
    }
    /* Space before ':' ? */
    if ((' ' == c || '\t' == c) && !col_seen && (flag & RHL_CHECK_HEADER)) {
      /* Skip to next ':' */
      while (' ' == c || '\t' == c)
	c = state_getc(s);
      if (':' != c) 
	goto bad_header_line;
    }
    if (':' == c)
      col_seen = 1;
    PUTC(c);
  }

  if (flag & RHL_MARK_FOLDING) {
    PUTC('\n');
  }

#undef PUTC
  buf[len] = 0;

  DPRINT(Debug,12,(&Debug,
		   "state_read_hdr_line: len=%d, buf=%s\n",len,buf));

  return len;
}

static unsigned char * us_str P_((char *str));
static unsigned char * us_str(str)
     char *str;
{
    return (unsigned char *)str;
}


long skip_envelope(hdr, fp)
     struct header_rec *hdr;
     FILE *fp;
{
  char buf[STRING];
  int tmp;
  int first_line = TRUE;

  long result = hdr->offset;

  if (0 !=  fseek(fp,hdr->offset,SEEK_SET)) {
    lib_error(CATGETS(elm_msg_cat, MeSet, MeFailedSeekEnvelope,
		      "Failed to seek beginning of mail envelope (%ld)"),
	      hdr->offset);
    DPRINT(Debug,7,(&Debug,
		    "skip_envelope=-1 (fseek error)\n"));

    return -1;
  }

  DPRINT(Debug,9,(&Debug,
		  "skip_envelope: scanning offset: %ld\n",
		  result));;

  while (0 < (tmp = mail_gets(buf,sizeof(buf),fp))) {
      DPRINT(Debug,15,(&Debug,		      
		      "skip_envelope: len=%d, got: %s\n",tmp,buf));
#ifdef MMDF
    if (0 == strcmp(buf,MSG_SEPARATOR))
      continue;
#endif
    if (0 == strncmp(buf,"From ",5)) {
      first_line = FALSE;
      continue;
    }
    if (!first_line && first_word_nc(buf, ">From"))
      continue;
    DPRINT(Debug,15,(&Debug,
		     "skip_envelope: got headers: %s\n",buf));
    break;
  }
  result = ftell(fp) - tmp;

  DPRINT(Debug,9,(&Debug,
		  "skip_envelope: beginning of headers=%ld\n",result));
  if (0 !=  fseek(fp,result,SEEK_SET)) {
      lib_error(CATGETS(elm_msg_cat, MeSet, MeFailedSeekHeaders,
			"Failed to seek beginning of mail headers (%ld)"),
		result);
      DPRINT(Debug,7,(&Debug,
		      "skip_envelope=-1 (fseek error)\n"));
    return -1;
  }

  DPRINT(Debug,9,(&Debug,
		  "skip_envelope=%ld\n",result));
  return result;
}

header_list_ptr file_read_headers(fp, flag) 
     FILE * fp;
     int flag;
{
  in_state_t state;
  header_list_ptr result;

  in_state_clear(&state,STATE_in_file);

  set_in_state_file(fp,&state);

  result = state_read_headers(&state, flag);

  in_state_destroy(&state);

  return result;
}

header_list_ptr state_read_headers(s, flag) 
     in_state_t * s;
     int flag;
{
    char buffer[32*1024+1];
    int size;

    header_list_ptr result = NULL, last = NULL;
    
    DPRINT(Debug,12,(&Debug,
		     "state_read_headers() --> START\n"));
    
    while ((size = state_read_hdr_line(s,buffer,sizeof buffer,
				       RHL_CHECK_HEADER|flag)) > 0) {
	char * k;
	if (1 == size && 0 == strcmp(buffer,"\n"))
	    break;
	k = strchr(buffer,':');
	if (!k)
	    break;
	*k = '\0';
	k++;

	while (whitespace(*k))
	    k++;

	update_header_list(&result,&last,buffer,k);
		
    }
    
    DPRINT(Debug,12,(&Debug,
		     "state_read_headers()=%p <-- END\n",result));
    return result;
}


int NULL_header_filter(hdr,flag)
     header_list_ptr hdr;
     int flag;
{
  if (hdr -> magic != HEADER_magic)
    header_panic(__FILE__,__LINE__,"NULL_header_filter","Bad magic number");

  flag++;      /* So that flag is used */
  return 1;
}

struct string * NULL_header_converter (hdr,demime,defcharset)
     header_list_ptr hdr;
     int demime; 
     charset_t defcharset;
{
    struct string * result = NULL;

    if (hdr -> magic != HEADER_magic)
	header_panic(__FILE__,__LINE__,
		     "NULL_header_converter","Bad magic number");

    
    result = new_string2(defcharset,us_str(hdr->body));

    return result;
}

void state_write_header(s,next,demime,defcharset)
     out_state_t   * s;
     header_list_ptr next;
     int             demime;
     charset_t          defcharset;
{
    struct string *buffer = NULL;
    int X,L1;

    buffer = give_decoded_header(next,demime,defcharset);
    
    state_add_prefix(s);
    state_puts(give_header_name(next->header_name),s);
    state_puts(": ",s);
    
    L1 = string_len(buffer);
    
    for (X = 0; X < L1; ) {
	int len = 0;
	uint16 ch = 0;
	struct string * data;
	int oldX = X;
	
	while (X + len < L1) {
	    ch = give_unicode_from_string(buffer,X+len);
	    
	    if (0x000C   /* FF */ == ch ||
		0x000B   /* VT */ == ch ||
		0x000A   /* LF */ == ch)
		break;
	    len++;		  
	} 
	
	/* clip_from_string updates X */
	data = clip_from_string(buffer,&X,len);
	
	if (oldX > 0) {
	    /* folding ...*/
	    state_add_prefix(s);
	    state_putc('\t',s);
	}
	
	state_printf(s,FRM("%S\n"),data);
	X++;
	
	free_string(&data);
    }
    
    if (0 == X) {
	/* No newline printed so print it now ... 

	   state_nlputs or state_printf is needed for EOLN_is_CRLF
	   conversions 
	*/	
	state_nlputs("\n",s);
    }
}

void state_write_headers(s,hdr,filter,flag,demime,defcharset) 
     out_state_t      * s;
     header_list_ptr    hdr;
     header_filter    * filter;
     int                flag;
     int                demime;
     charset_t          defcharset;
{
    header_list_ptr next = hdr;
    int ret;
    
    for (next = hdr; next; next = next -> next_header) {
	
	if (next -> magic != HEADER_magic)
	    header_panic(__FILE__,__LINE__,"state_write_headers",
			 "Bad magic number");
	
	if (! (ret = filter(next,flag))) {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_headers: header='%s', {filter}=%d FILTERED\n",
			     give_header_name(next->header_name), ret));
	    continue;
	} else {
	    DPRINT(Debug,12,(&Debug,
			     "state_write_headers: header='%s', {filter}=%d PASSED\n",
			     give_header_name(next->header_name), ret));
	}
	
	state_write_header(s,next,demime,defcharset);
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
