/* $Id: shared.h,v 1.12 2001/06/17 14:01:16 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include <dlfcn.h>

#ifdef ANSI_C
struct SE_option;
#endif

typedef int pop_capa_handler P_((struct folder_info *folder,
				 char *capa,
				 char *capa_args,
				 size_t fi_size,
				 struct pop_callbacks *commands,
				 size_t cb_size,
				 struct SE_option   *service_config,
				 size_t sc_size,
				 enum CAPA_phase *phase));

typedef int imap_capa_handler P_((struct connection_cache *con,
				  char *capa,
				  size_t con_size,
				  struct imap_callbacks *commands,
				  size_t cb_size,
				  struct SE_option   *service_config,
				  size_t sc_size,
				  enum CAPA_phase *phase));

typedef struct provides_shared_CT {
    struct connection_type *T;
}   * provides_shared_CT_f P_((int *count, size_t *s_size));

typedef struct provides_shared_FT {
    folder_type_p T;
}   * provides_shared_FT_f P_((int *count, size_t *s_size));

typedef struct provides_shared_ST {
    struct stream_type * T;
}   * provides_shared_ST_f P_((int *count, size_t *s_size));

typedef struct provides_shared_POP_CAPA {
    char                * capa;
    int                   priority;
    pop_capa_handler     *capa_handler;
}  *  provides_shared_POP_CAPA_f P_((int *count, size_t *s_size));

typedef struct provides_shared_IMAP_CAPA {
    char                * capa;
    int                   priority;
    imap_capa_handler     *capa_handler;
}  *  provides_shared_IMAP_CAPA_f P_((int *count, size_t *s_size));

typedef struct provides_shared_SEOT {
     struct SE_option_type * T;
} *  provides_shared_SEOT_f  P_((int *count, size_t *s_size));

typedef struct provides_shared_RCT {
    struct rc_type         * T;
} * provides_shared_RCT_f P_((int *count, size_t *s_size));

typedef struct rc_save_info_rec
* provides_RC_options_f P_((int *count, size_t *s_size));

typedef void RC_post_init_f P_((int *errors));

typedef void wants_rand_bits_f P_((const char *buf, int size, 
				   int entropy_bits));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
